/*
 * Decompiled with CFR 0.152.
 */
package net.dv8tion.jda.api.managers;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.CheckReturnValue;
import net.dv8tion.jda.api.JDA;
import net.dv8tion.jda.api.Permission;
import net.dv8tion.jda.api.entities.Category;
import net.dv8tion.jda.api.entities.ChannelType;
import net.dv8tion.jda.api.entities.Emote;
import net.dv8tion.jda.api.entities.Guild;
import net.dv8tion.jda.api.entities.GuildChannel;
import net.dv8tion.jda.api.entities.GuildVoiceState;
import net.dv8tion.jda.api.entities.ISnowflake;
import net.dv8tion.jda.api.entities.Icon;
import net.dv8tion.jda.api.entities.Member;
import net.dv8tion.jda.api.entities.Role;
import net.dv8tion.jda.api.entities.TextChannel;
import net.dv8tion.jda.api.entities.User;
import net.dv8tion.jda.api.entities.VoiceChannel;
import net.dv8tion.jda.api.exceptions.HierarchyException;
import net.dv8tion.jda.api.exceptions.InsufficientPermissionException;
import net.dv8tion.jda.api.exceptions.PermissionException;
import net.dv8tion.jda.api.requests.RestAction;
import net.dv8tion.jda.api.requests.restaction.AuditableRestAction;
import net.dv8tion.jda.api.requests.restaction.ChannelAction;
import net.dv8tion.jda.api.requests.restaction.RoleAction;
import net.dv8tion.jda.api.requests.restaction.order.CategoryOrderAction;
import net.dv8tion.jda.api.requests.restaction.order.ChannelOrderAction;
import net.dv8tion.jda.api.requests.restaction.order.RoleOrderAction;
import net.dv8tion.jda.api.utils.MiscUtil;
import net.dv8tion.jda.internal.JDAImpl;
import net.dv8tion.jda.internal.entities.GuildImpl;
import net.dv8tion.jda.internal.entities.MemberImpl;
import net.dv8tion.jda.internal.requests.EmptyRestAction;
import net.dv8tion.jda.internal.requests.RestActionImpl;
import net.dv8tion.jda.internal.requests.Route;
import net.dv8tion.jda.internal.requests.restaction.AuditableRestActionImpl;
import net.dv8tion.jda.internal.requests.restaction.ChannelActionImpl;
import net.dv8tion.jda.internal.requests.restaction.RoleActionImpl;
import net.dv8tion.jda.internal.requests.restaction.order.CategoryOrderActionImpl;
import net.dv8tion.jda.internal.requests.restaction.order.ChannelOrderActionImpl;
import net.dv8tion.jda.internal.requests.restaction.order.RoleOrderActionImpl;
import net.dv8tion.jda.internal.utils.Checks;
import net.dv8tion.jda.internal.utils.PermissionUtil;
import net.dv8tion.jda.internal.utils.cache.UpstreamReference;
import org.json.JSONObject;

public class GuildController {
    protected final UpstreamReference<GuildImpl> guild;

    public GuildController(Guild guild) {
        this.guild = new UpstreamReference<GuildImpl>((GuildImpl)guild);
    }

    public Guild getGuild() {
        return this.guild.get();
    }

    public JDA getJDA() {
        return this.getGuild().getJDA();
    }

    @CheckReturnValue
    public RestAction<Void> moveVoiceMember(Member member, VoiceChannel voiceChannel) {
        Checks.notNull(member, "Member");
        Checks.notNull(voiceChannel, "VoiceChannel");
        this.checkGuild(member.getGuild(), "Member");
        this.checkGuild(voiceChannel.getGuild(), "VoiceChannel");
        GuildVoiceState vState = member.getVoiceState();
        if (vState == null) {
            throw new IllegalStateException("Cannot move a Member with disabled CacheFlag.VOICE_STATE");
        }
        if (!vState.inVoiceChannel()) {
            throw new IllegalStateException("You cannot move a Member who isn't in a VoiceChannel!");
        }
        if (!PermissionUtil.checkPermission(vState.getChannel(), this.getGuild().getSelfMember(), Permission.VOICE_MOVE_OTHERS)) {
            throw new InsufficientPermissionException(Permission.VOICE_MOVE_OTHERS, "This account does not have Permission to MOVE_OTHERS out of the channel that the Member is currently in.");
        }
        if (!PermissionUtil.checkPermission(voiceChannel, this.getGuild().getSelfMember(), Permission.VOICE_CONNECT) && !PermissionUtil.checkPermission(voiceChannel, member, Permission.VOICE_CONNECT)) {
            throw new InsufficientPermissionException(Permission.VOICE_CONNECT, "Neither this account nor the Member that is attempting to be moved have the VOICE_CONNECT permission for the destination VoiceChannel, so the move cannot be done.");
        }
        JSONObject body = new JSONObject().put("channel_id", (Object)voiceChannel.getId());
        Route.CompiledRoute route = Route.Guilds.MODIFY_MEMBER.compile(this.getGuild().getId(), member.getUser().getId());
        return new RestActionImpl<Void>(this.getGuild().getJDA(), route, body);
    }

    @CheckReturnValue
    public AuditableRestAction<Void> setNickname(Member member, String nickname) {
        Checks.notNull(member, "Member");
        this.checkGuild(member.getGuild(), "Member");
        if (member.equals(this.getGuild().getSelfMember())) {
            if (!member.hasPermission(Permission.NICKNAME_CHANGE) && !member.hasPermission(Permission.NICKNAME_MANAGE)) {
                throw new InsufficientPermissionException(Permission.NICKNAME_CHANGE, "You neither have NICKNAME_CHANGE nor NICKNAME_MANAGE permission!");
            }
        } else {
            this.checkPermission(Permission.NICKNAME_MANAGE);
            this.checkPosition(member);
        }
        if (Objects.equals(nickname, member.getNickname())) {
            return new EmptyRestAction<Object>(this.getJDA(), null);
        }
        if (nickname == null) {
            nickname = "";
        }
        JSONObject body = new JSONObject().put("nick", (Object)nickname);
        Route.CompiledRoute route = member.equals(this.getGuild().getSelfMember()) ? Route.Guilds.MODIFY_SELF_NICK.compile(this.getGuild().getId()) : Route.Guilds.MODIFY_MEMBER.compile(this.getGuild().getId(), member.getUser().getId());
        return new AuditableRestActionImpl<Void>(this.getGuild().getJDA(), route, body);
    }

    @CheckReturnValue
    public AuditableRestAction<Integer> prune(int days) {
        this.checkPermission(Permission.KICK_MEMBERS);
        Checks.check(days >= 1, "Days amount must be at minimum 1 day.");
        Route.CompiledRoute route = Route.Guilds.PRUNE_MEMBERS.compile(this.getGuild().getId()).withQueryParams("days", Integer.toString(days));
        return new AuditableRestActionImpl<Integer>(this.getGuild().getJDA(), route, (response, request) -> response.getObject().getInt("pruned"));
    }

    @CheckReturnValue
    public AuditableRestAction<Void> kick(Member member, String reason) {
        Checks.notNull(member, "member");
        this.checkGuild(member.getGuild(), "member");
        this.checkPermission(Permission.KICK_MEMBERS);
        this.checkPosition(member);
        String userId = member.getUser().getId();
        String guildId = this.getGuild().getId();
        Route.CompiledRoute route = Route.Guilds.KICK_MEMBER.compile(guildId, userId);
        if (reason != null && !reason.isEmpty()) {
            route = route.withQueryParams("reason", MiscUtil.encodeUTF8(reason));
        }
        return new AuditableRestActionImpl<Void>(this.getGuild().getJDA(), route);
    }

    @CheckReturnValue
    public AuditableRestAction<Void> kick(String userId, String reason) {
        Member member = this.getGuild().getMemberById(userId);
        Checks.check(member != null, "The provided userId does not correspond to a member in this guild! Provided userId: %s", (Object)userId);
        return this.kick(member, reason);
    }

    @CheckReturnValue
    public AuditableRestAction<Void> kick(Member member) {
        return this.kick(member, null);
    }

    @CheckReturnValue
    public AuditableRestAction<Void> kick(String userId) {
        return this.kick(userId, null);
    }

    @CheckReturnValue
    public AuditableRestAction<Void> ban(Member member, int delDays, String reason) {
        Checks.notNull(member, "Member");
        return this.ban(member.getUser(), delDays, reason);
    }

    @CheckReturnValue
    public AuditableRestAction<Void> ban(User user, int delDays, String reason) {
        Checks.notNull(user, "User");
        this.checkPermission(Permission.BAN_MEMBERS);
        if (this.getGuild().isMember(user)) {
            this.checkPosition(this.getGuild().getMember(user));
        }
        Checks.notNegative(delDays, "Deletion Days");
        Checks.check(delDays <= 7, "Deletion Days must not be bigger than 7.");
        String userId = user.getId();
        Route.CompiledRoute route = Route.Guilds.BAN.compile(this.getGuild().getId(), userId);
        if (reason != null && !reason.isEmpty()) {
            route = route.withQueryParams("reason", MiscUtil.encodeUTF8(reason));
        }
        if (delDays > 0) {
            route = route.withQueryParams("delete-message-days", Integer.toString(delDays));
        }
        return new AuditableRestActionImpl<Void>(this.getGuild().getJDA(), route);
    }

    @CheckReturnValue
    public AuditableRestAction<Void> ban(String userId, int delDays, String reason) {
        Checks.notNull(userId, "User");
        this.checkPermission(Permission.BAN_MEMBERS);
        User user = this.getGuild().getJDA().getUserById(userId);
        if (user != null) {
            return this.ban(user, delDays, reason);
        }
        Checks.notNegative(delDays, "Deletion Days");
        Checks.check(delDays <= 7, "Deletion Days must not be bigger than 7.");
        Route.CompiledRoute route = Route.Guilds.BAN.compile(this.getGuild().getId(), userId);
        if (reason != null && !reason.isEmpty()) {
            route = route.withQueryParams("reason", MiscUtil.encodeUTF8(reason));
        }
        if (delDays > 0) {
            route = route.withQueryParams("delete-message-days", Integer.toString(delDays));
        }
        return new AuditableRestActionImpl<Void>(this.getGuild().getJDA(), route);
    }

    @CheckReturnValue
    public AuditableRestAction<Void> ban(Member member, int delDays) {
        return this.ban(member, delDays, null);
    }

    @CheckReturnValue
    public AuditableRestAction<Void> ban(User user, int delDays) {
        return this.ban(user, delDays, null);
    }

    @CheckReturnValue
    public AuditableRestAction<Void> ban(String userId, int delDays) {
        return this.ban(userId, delDays, null);
    }

    @CheckReturnValue
    public AuditableRestAction<Void> unban(User user) {
        Checks.notNull(user, "User");
        return this.unban(user.getId());
    }

    @CheckReturnValue
    public AuditableRestAction<Void> unban(String userId) {
        Checks.isSnowflake(userId, "User ID");
        this.checkPermission(Permission.BAN_MEMBERS);
        Route.CompiledRoute route = Route.Guilds.UNBAN.compile(this.getGuild().getId(), userId);
        return new AuditableRestActionImpl<Void>(this.getGuild().getJDA(), route);
    }

    @CheckReturnValue
    public AuditableRestAction<Void> setDeafen(Member member, boolean deafen) {
        Checks.notNull(member, "Member");
        this.checkGuild(member.getGuild(), "Member");
        this.checkPermission(Permission.VOICE_DEAF_OTHERS);
        if (this.getGuild().getOwner().equals(member)) {
            throw new HierarchyException("Cannot modify Guild Deafen status the Owner of the Guild");
        }
        GuildVoiceState voiceState = member.getVoiceState();
        if (voiceState != null && voiceState.isGuildDeafened() == deafen) {
            return new EmptyRestAction<Object>(this.getJDA(), null);
        }
        JSONObject body = new JSONObject().put("deaf", deafen);
        Route.CompiledRoute route = Route.Guilds.MODIFY_MEMBER.compile(this.getGuild().getId(), member.getUser().getId());
        return new AuditableRestActionImpl<Void>(this.getGuild().getJDA(), route, body);
    }

    @CheckReturnValue
    public AuditableRestAction<Void> setMute(Member member, boolean mute) {
        Checks.notNull(member, "Member");
        this.checkGuild(member.getGuild(), "Member");
        this.checkPermission(Permission.VOICE_MUTE_OTHERS);
        if (this.getGuild().getOwner().equals(member)) {
            throw new HierarchyException("Cannot modify Guild Mute status the Owner of the Guild");
        }
        GuildVoiceState voiceState = member.getVoiceState();
        if (voiceState != null && voiceState.isGuildMuted() == mute) {
            return new EmptyRestAction<Object>(this.getJDA(), null);
        }
        JSONObject body = new JSONObject().put("mute", mute);
        Route.CompiledRoute route = Route.Guilds.MODIFY_MEMBER.compile(this.getGuild().getId(), member.getUser().getId());
        return new AuditableRestActionImpl<Void>(this.getGuild().getJDA(), route, body);
    }

    @CheckReturnValue
    public AuditableRestAction<Void> addSingleRoleToMember(Member member, Role role) {
        Checks.notNull(member, "Member");
        Checks.notNull(role, "Role");
        this.checkGuild(member.getGuild(), "Member");
        this.checkGuild(role.getGuild(), "Role");
        this.checkPermission(Permission.MANAGE_ROLES);
        this.checkPosition(role);
        Route.CompiledRoute route = Route.Guilds.ADD_MEMBER_ROLE.compile(this.getGuild().getId(), member.getUser().getId(), role.getId());
        return new AuditableRestActionImpl<Void>(this.getJDA(), route);
    }

    @CheckReturnValue
    public AuditableRestAction<Void> removeSingleRoleFromMember(Member member, Role role) {
        Checks.notNull(member, "Member");
        Checks.notNull(role, "Role");
        this.checkGuild(member.getGuild(), "Member");
        this.checkGuild(role.getGuild(), "Role");
        this.checkPermission(Permission.MANAGE_ROLES);
        this.checkPosition(role);
        Route.CompiledRoute route = Route.Guilds.REMOVE_MEMBER_ROLE.compile(this.getGuild().getId(), member.getUser().getId(), role.getId());
        return new AuditableRestActionImpl<Void>(this.getJDA(), route);
    }

    @CheckReturnValue
    public AuditableRestAction<Void> addRolesToMember(Member member, Role ... roles) {
        return this.modifyMemberRoles(member, Arrays.asList(roles), Collections.emptyList());
    }

    @CheckReturnValue
    public AuditableRestAction<Void> addRolesToMember(Member member, Collection<Role> roles) {
        return this.modifyMemberRoles(member, roles, Collections.emptyList());
    }

    @CheckReturnValue
    public AuditableRestAction<Void> removeRolesFromMember(Member member, Role ... roles) {
        return this.modifyMemberRoles(member, Collections.emptyList(), Arrays.asList(roles));
    }

    @CheckReturnValue
    public AuditableRestAction<Void> removeRolesFromMember(Member member, Collection<Role> roles) {
        return this.modifyMemberRoles(member, Collections.emptyList(), roles);
    }

    @CheckReturnValue
    public AuditableRestAction<Void> modifyMemberRoles(Member member, Collection<Role> rolesToAdd, Collection<Role> rolesToRemove) {
        Checks.notNull(member, "Member");
        Checks.notNull(rolesToAdd, "Collection containing roles to be added to the member");
        Checks.notNull(rolesToRemove, "Collection containing roles to be removed from the member");
        this.checkGuild(member.getGuild(), "Member");
        this.checkPermission(Permission.MANAGE_ROLES);
        rolesToAdd.forEach(role -> {
            Checks.notNull(role, "Role in rolesToAdd");
            this.checkGuild(role.getGuild(), "Role: " + role.toString());
            this.checkPosition((Role)role);
            Checks.check(!role.isManaged(), "Cannot add a Managed role to a Member. Role: %s", (Object)role.toString());
        });
        rolesToRemove.forEach(role -> {
            Checks.notNull(role, "Role in rolesToRemove");
            this.checkGuild(role.getGuild(), "Role: " + role.toString());
            this.checkPosition((Role)role);
            Checks.check(!role.isManaged(), "Cannot remove a Managed role from a Member. Role: %s", (Object)role.toString());
        });
        HashSet<Role> currentRoles = new HashSet<Role>(((MemberImpl)member).getRoleSet());
        HashSet<Role> newRolesToAdd = new HashSet<Role>(rolesToAdd);
        newRolesToAdd.removeAll(rolesToRemove);
        if (currentRoles.addAll(newRolesToAdd)) {
            currentRoles.removeAll(rolesToRemove);
        } else if (!currentRoles.removeAll(rolesToRemove)) {
            return new EmptyRestAction<Void>(this.getGuild().getJDA());
        }
        Checks.check(!currentRoles.contains(this.getGuild().getPublicRole()), "Cannot add the PublicRole of a Guild to a Member. All members have this role by default!");
        JSONObject body = new JSONObject().put("roles", (Collection)currentRoles.stream().map(ISnowflake::getId).collect(Collectors.toList()));
        Route.CompiledRoute route = Route.Guilds.MODIFY_MEMBER.compile(this.getGuild().getId(), member.getUser().getId());
        return new AuditableRestActionImpl<Void>(this.getGuild().getJDA(), route, body);
    }

    @CheckReturnValue
    public AuditableRestAction<Void> modifyMemberRoles(Member member, Role ... roles) {
        return this.modifyMemberRoles(member, Arrays.asList(roles));
    }

    @CheckReturnValue
    public AuditableRestAction<Void> modifyMemberRoles(Member member, Collection<Role> roles) {
        Checks.notNull(member, "Member");
        Checks.notNull(roles, "Roles");
        this.checkGuild(member.getGuild(), "Member");
        roles.forEach(role -> {
            Checks.notNull(role, "Role in collection");
            this.checkGuild(role.getGuild(), "Role: " + role.toString());
            this.checkPosition((Role)role);
        });
        Checks.check(!roles.contains(this.getGuild().getPublicRole()), "Cannot add the PublicRole of a Guild to a Member. All members have this role by default!");
        List<Role> memberRoles = member.getRoles();
        if (memberRoles.size() == roles.size() && memberRoles.containsAll(roles)) {
            return new EmptyRestAction<Void>(this.getGuild().getJDA());
        }
        List currentManaged = memberRoles.stream().filter(Role::isManaged).collect(Collectors.toList());
        List newManaged = roles.stream().filter(Role::isManaged).collect(Collectors.toList());
        if (!currentManaged.isEmpty() || !newManaged.isEmpty()) {
            if (!newManaged.containsAll(currentManaged)) {
                currentManaged.removeAll(newManaged);
                throw new IllegalArgumentException("Cannot remove managed roles from a member! Roles: " + currentManaged.toString());
            }
            if (!currentManaged.containsAll(newManaged)) {
                newManaged.removeAll(currentManaged);
                throw new IllegalArgumentException("Cannot add managed roles to a member! Roles: " + newManaged.toString());
            }
        }
        JSONObject body = new JSONObject().put("roles", (Collection)roles.stream().map(ISnowflake::getId).collect(Collectors.toList()));
        Route.CompiledRoute route = Route.Guilds.MODIFY_MEMBER.compile(this.getGuild().getId(), member.getUser().getId());
        return new AuditableRestActionImpl<Void>(this.getGuild().getJDA(), route, body);
    }

    @CheckReturnValue
    public AuditableRestAction<Void> transferOwnership(Member newOwner) {
        Checks.notNull(newOwner, "Member");
        this.checkGuild(newOwner.getGuild(), "Member");
        if (!this.getGuild().getOwner().equals(this.getGuild().getSelfMember())) {
            throw new PermissionException("The logged in account must be the owner of this Guild to be able to transfer ownership");
        }
        Checks.check(!this.getGuild().getSelfMember().equals(newOwner), "The member provided as the newOwner is the currently logged in account. Provide a different member to give ownership to.");
        Checks.check(!newOwner.getUser().isBot(), "Cannot transfer ownership of a Guild to a Bot!");
        JSONObject body = new JSONObject().put("owner_id", (Object)newOwner.getUser().getId());
        Route.CompiledRoute route = Route.Guilds.MODIFY_GUILD.compile(this.getGuild().getId());
        return new AuditableRestActionImpl<Void>(this.getGuild().getJDA(), route, body);
    }

    @CheckReturnValue
    public ChannelAction<TextChannel> createTextChannel(String name) {
        this.checkPermission(Permission.MANAGE_CHANNEL);
        Checks.notBlank(name, "Name");
        name = name.trim();
        Checks.check(name.length() > 0 && name.length() <= 100, "Provided name must be 1 - 100 characters in length");
        return new ChannelActionImpl<TextChannel>(TextChannel.class, name, this.getGuild(), ChannelType.TEXT);
    }

    @CheckReturnValue
    public ChannelAction<VoiceChannel> createVoiceChannel(String name) {
        this.checkPermission(Permission.MANAGE_CHANNEL);
        Checks.notBlank(name, "Name");
        name = name.trim();
        Checks.check(name.length() > 0 && name.length() <= 100, "Provided name must be 1 - 100 characters in length");
        return new ChannelActionImpl<VoiceChannel>(VoiceChannel.class, name, this.getGuild(), ChannelType.VOICE);
    }

    @CheckReturnValue
    public ChannelAction<Category> createCategory(String name) {
        this.checkPermission(Permission.MANAGE_CHANNEL);
        Checks.notBlank(name, "Name");
        name = name.trim();
        Checks.check(name.length() > 0 && name.length() <= 100, "Provided name must be 1 - 100 characters in length");
        return new ChannelActionImpl<Category>(Category.class, name, this.getGuild(), ChannelType.CATEGORY);
    }

    @CheckReturnValue
    public <T extends GuildChannel> ChannelAction<T> createCopyOfChannel(T channel) {
        Checks.notNull(channel, "Channel");
        return channel.createCopy(this.getGuild());
    }

    @CheckReturnValue
    public RoleAction createRole() {
        this.checkPermission(Permission.MANAGE_ROLES);
        return new RoleActionImpl(this.getGuild());
    }

    @CheckReturnValue
    public RoleAction createCopyOfRole(Role role) {
        Checks.notNull(role, "Role");
        return role.createCopy(this.getGuild());
    }

    @CheckReturnValue
    public AuditableRestAction<Emote> createEmote(String name, Icon icon, Role ... roles) {
        this.checkPermission(Permission.MANAGE_EMOTES);
        Checks.notBlank(name, "Emote name");
        Checks.notNull(icon, "Emote icon");
        Checks.notNull(roles, "Roles");
        JSONObject body = new JSONObject();
        body.put("name", (Object)name);
        body.put("image", (Object)icon.getEncoding());
        if (roles.length > 0) {
            body.put("roles", (Collection)Stream.of(roles).filter(Objects::nonNull).map(ISnowflake::getId).collect(Collectors.toSet()));
        }
        JDAImpl jda = (JDAImpl)this.getJDA();
        Route.CompiledRoute route = Route.Emotes.CREATE_EMOTE.compile(this.getGuild().getId());
        return new AuditableRestActionImpl<Emote>((JDA)jda, route, body, (response, request) -> {
            JSONObject obj = response.getObject();
            return jda.getEntityBuilder().createEmote((GuildImpl)this.getGuild(), obj, true);
        });
    }

    @CheckReturnValue
    public ChannelOrderAction<Category> modifyCategoryPositions() {
        return new ChannelOrderActionImpl<Category>(this.getGuild(), ChannelType.CATEGORY);
    }

    @CheckReturnValue
    public ChannelOrderAction<TextChannel> modifyTextChannelPositions() {
        return new ChannelOrderActionImpl<TextChannel>(this.getGuild(), ChannelType.TEXT);
    }

    @CheckReturnValue
    public ChannelOrderAction<VoiceChannel> modifyVoiceChannelPositions() {
        return new ChannelOrderActionImpl<VoiceChannel>(this.getGuild(), ChannelType.VOICE);
    }

    @CheckReturnValue
    public CategoryOrderAction<TextChannel> modifyTextChannelPositions(Category category) {
        Checks.notNull(category, "Category");
        this.checkGuild(category.getGuild(), "Category");
        return new CategoryOrderActionImpl<TextChannel>(category, ChannelType.TEXT);
    }

    @CheckReturnValue
    public CategoryOrderAction<VoiceChannel> modifyVoiceChannelPositions(Category category) {
        Checks.notNull(category, "Category");
        this.checkGuild(category.getGuild(), "Category");
        return new CategoryOrderActionImpl<VoiceChannel>(category, ChannelType.VOICE);
    }

    @CheckReturnValue
    public RoleOrderAction modifyRolePositions() {
        return this.modifyRolePositions(true);
    }

    @CheckReturnValue
    public RoleOrderAction modifyRolePositions(boolean useAscendingOrder) {
        return new RoleOrderActionImpl(this.getGuild(), useAscendingOrder);
    }

    protected void checkGuild(Guild providedGuild, String comment) {
        if (!this.getGuild().equals(providedGuild)) {
            throw new IllegalArgumentException("Provided " + comment + " is not part of this Guild!");
        }
    }

    protected void checkPermission(Permission perm) {
        if (!this.getGuild().getSelfMember().hasPermission(perm)) {
            throw new InsufficientPermissionException(perm);
        }
    }

    protected void checkPosition(Member member) {
        if (!this.getGuild().getSelfMember().canInteract(member)) {
            throw new HierarchyException("Can't modify a member with higher or equal highest role than yourself!");
        }
    }

    protected void checkPosition(Role role) {
        if (!this.getGuild().getSelfMember().canInteract(role)) {
            throw new HierarchyException("Can't modify a role with higher or equal highest role than yourself! Role: " + role.toString());
        }
    }
}

