/*
 * Decompiled with CFR 0.152.
 */
package net.dv8tion.jda.api.events.user;

import java.time.OffsetDateTime;
import net.dv8tion.jda.api.JDA;
import net.dv8tion.jda.api.entities.ChannelType;
import net.dv8tion.jda.api.entities.Guild;
import net.dv8tion.jda.api.entities.Member;
import net.dv8tion.jda.api.entities.MessageChannel;
import net.dv8tion.jda.api.entities.PrivateChannel;
import net.dv8tion.jda.api.entities.TextChannel;
import net.dv8tion.jda.api.entities.User;
import net.dv8tion.jda.api.events.user.GenericUserEvent;

public class UserTypingEvent
extends GenericUserEvent {
    private final MessageChannel channel;
    private final OffsetDateTime timestamp;

    public UserTypingEvent(JDA api, long responseNumber, User user, MessageChannel channel, OffsetDateTime timestamp) {
        super(api, responseNumber, user);
        this.channel = channel;
        this.timestamp = timestamp;
    }

    public OffsetDateTime getTimestamp() {
        return this.timestamp;
    }

    public MessageChannel getChannel() {
        return this.channel;
    }

    public boolean isFromType(ChannelType type) {
        return this.channel.getType() == type;
    }

    public ChannelType getType() {
        return this.channel.getType();
    }

    public PrivateChannel getPrivateChannel() {
        return this.isFromType(ChannelType.PRIVATE) ? (PrivateChannel)this.channel : null;
    }

    public TextChannel getTextChannel() {
        return this.isFromType(ChannelType.TEXT) ? (TextChannel)this.channel : null;
    }

    public Guild getGuild() {
        return this.isFromType(ChannelType.TEXT) ? this.getTextChannel().getGuild() : null;
    }

    public Member getMember() {
        return this.isFromType(ChannelType.TEXT) ? this.getGuild().getMember(this.getUser()) : null;
    }
}

