/*
 * Decompiled with CFR 0.152.
 */
package net.dv8tion.jda.api.entities;

import java.util.Objects;
import javax.annotation.CheckReturnValue;
import net.dv8tion.jda.api.JDA;
import net.dv8tion.jda.api.Permission;
import net.dv8tion.jda.api.entities.ChannelType;
import net.dv8tion.jda.api.entities.Emote;
import net.dv8tion.jda.api.entities.Guild;
import net.dv8tion.jda.api.entities.GuildChannel;
import net.dv8tion.jda.api.entities.ISnowflake;
import net.dv8tion.jda.api.entities.MessageChannel;
import net.dv8tion.jda.api.entities.PrivateChannel;
import net.dv8tion.jda.api.entities.TextChannel;
import net.dv8tion.jda.api.entities.User;
import net.dv8tion.jda.api.exceptions.InsufficientPermissionException;
import net.dv8tion.jda.api.exceptions.PermissionException;
import net.dv8tion.jda.api.requests.RestAction;
import net.dv8tion.jda.api.requests.restaction.pagination.ReactionPaginationAction;
import net.dv8tion.jda.api.utils.MiscUtil;
import net.dv8tion.jda.internal.requests.RestActionImpl;
import net.dv8tion.jda.internal.requests.Route;
import net.dv8tion.jda.internal.requests.restaction.pagination.ReactionPaginationActionImpl;

public class MessageReaction {
    private final MessageChannel channel;
    private final ReactionEmote emote;
    private final long messageId;
    private final boolean self;
    private final int count;

    public MessageReaction(MessageChannel channel, ReactionEmote emote, long messageId, boolean self, int count) {
        this.channel = channel;
        this.emote = emote;
        this.messageId = messageId;
        this.self = self;
        this.count = count;
    }

    public JDA getJDA() {
        return this.channel.getJDA();
    }

    public boolean isSelf() {
        return this.self;
    }

    public int getCount() {
        if (this.count < 0) {
            throw new IllegalStateException("Cannot retrieve count for this MessageReaction!");
        }
        return this.count;
    }

    public ChannelType getChannelType() {
        return this.channel.getType();
    }

    public boolean isFromType(ChannelType type) {
        return this.getChannelType() == type;
    }

    public Guild getGuild() {
        TextChannel channel = this.getTextChannel();
        return channel != null ? channel.getGuild() : null;
    }

    public TextChannel getTextChannel() {
        return this.getChannel() instanceof TextChannel ? (TextChannel)this.getChannel() : null;
    }

    public PrivateChannel getPrivateChannel() {
        return this.getChannel() instanceof PrivateChannel ? (PrivateChannel)this.getChannel() : null;
    }

    public MessageChannel getChannel() {
        return this.channel;
    }

    public ReactionEmote getReactionEmote() {
        return this.emote;
    }

    public String getMessageId() {
        return Long.toUnsignedString(this.messageId);
    }

    public long getMessageIdLong() {
        return this.messageId;
    }

    @CheckReturnValue
    public ReactionPaginationAction retrieveUsers() {
        return this.retrieveUsers(100);
    }

    @CheckReturnValue
    public ReactionPaginationAction retrieveUsers(int amount) {
        return (ReactionPaginationAction)new ReactionPaginationActionImpl(this).limit(amount);
    }

    @CheckReturnValue
    public RestAction<Void> removeReaction() {
        return this.removeReaction(this.getJDA().getSelfUser());
    }

    @CheckReturnValue
    public RestAction<Void> removeReaction(User user) {
        if (user == null) {
            throw new IllegalArgumentException("Provided User was null!");
        }
        if (!user.equals(this.getJDA().getSelfUser())) {
            if (this.channel.getType() == ChannelType.TEXT) {
                GuildChannel channel = (GuildChannel)((Object)this.channel);
                if (!channel.getGuild().getSelfMember().hasPermission(channel, Permission.MESSAGE_MANAGE)) {
                    throw new InsufficientPermissionException(Permission.MESSAGE_MANAGE);
                }
            } else {
                throw new PermissionException("Unable to remove Reaction of other user in non-text channel!");
            }
        }
        String code = this.emote.isEmote() ? this.emote.getName() + ":" + this.emote.getId() : MiscUtil.encodeUTF8(this.emote.getName());
        Route.CompiledRoute route = user.equals(this.getJDA().getSelfUser()) ? Route.Messages.REMOVE_REACTION.compile(this.channel.getId(), this.getMessageId(), code, "@me") : Route.Messages.REMOVE_REACTION.compile(this.channel.getId(), this.getMessageId(), code, user.getId());
        return new RestActionImpl<Void>(this.getJDA(), route);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof MessageReaction)) {
            return false;
        }
        MessageReaction r = (MessageReaction)obj;
        return r.emote.equals(this.emote) && r.self == this.self && r.messageId == this.messageId;
    }

    public String toString() {
        return "MR:(M:(" + this.messageId + ") / " + this.emote + ")";
    }

    public static class ReactionEmote
    implements ISnowflake {
        private final JDA api;
        private final String name;
        private final Long id;
        private Emote emote = null;

        public ReactionEmote(String name, Long id, JDA api) {
            this.name = name;
            this.id = id;
            this.api = api;
        }

        public ReactionEmote(Emote emote) {
            this(emote.getName(), emote.getIdLong(), emote.getJDA());
            this.emote = emote;
        }

        public boolean isEmote() {
            return this.emote != null;
        }

        @Override
        public String getId() {
            return this.id != null ? String.valueOf(this.id) : null;
        }

        @Override
        public long getIdLong() {
            if (this.id == null) {
                throw new IllegalStateException("No id available");
            }
            return this.id;
        }

        public String getName() {
            return this.name;
        }

        public Emote getEmote() {
            return this.emote;
        }

        public JDA getJDA() {
            return this.api;
        }

        public boolean equals(Object obj) {
            return obj instanceof ReactionEmote && Objects.equals(((ReactionEmote)obj).id, this.id) && ((ReactionEmote)obj).getName().equals(this.name);
        }

        public String toString() {
            return "RE:" + (this.isEmote() ? this.getEmote() : this.getName() + "(" + this.id + ")");
        }
    }
}

