/*
 * Decompiled with CFR 0.152.
 */
package net.dv8tion.jda.api.entities;

import java.time.OffsetDateTime;
import java.util.List;
import java.util.Set;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import net.dv8tion.jda.api.JDA;
import net.dv8tion.jda.api.entities.ChannelType;
import net.dv8tion.jda.api.entities.Guild;
import net.dv8tion.jda.api.entities.ISnowflake;
import net.dv8tion.jda.api.entities.User;
import net.dv8tion.jda.api.requests.RestAction;
import net.dv8tion.jda.api.requests.restaction.AuditableRestAction;
import net.dv8tion.jda.internal.entities.InviteImpl;

public interface Invite {
    public static RestAction<Invite> resolve(JDA api, String code) {
        return Invite.resolve(api, code, false);
    }

    public static RestAction<Invite> resolve(JDA api, String code, boolean withCounts) {
        return InviteImpl.resolve(api, code, withCounts);
    }

    @CheckReturnValue
    public AuditableRestAction<Void> delete();

    @CheckReturnValue
    public RestAction<Invite> expand();

    public InviteType getType();

    public Channel getChannel();

    public String getCode();

    public Group getGroup();

    default public String getUrl() {
        return "https://discord.gg/" + this.getCode();
    }

    public OffsetDateTime getCreationTime();

    public Guild getGuild();

    public User getInviter();

    public JDA getJDA();

    public int getMaxAge();

    public int getMaxUses();

    public int getUses();

    public boolean isExpanded();

    public boolean isTemporary();

    public static enum InviteType {
        GUILD,
        GROUP,
        UNKNOWN;

    }

    public static interface Group
    extends ISnowflake {
        public String getIconId();

        public String getIconUrl();

        public String getName();

        @Nullable
        public List<String> getUsers();
    }

    public static interface Guild
    extends ISnowflake {
        public String getIconId();

        public String getIconUrl();

        public String getName();

        public String getSplashId();

        public String getSplashUrl();

        public Guild.VerificationLevel getVerificationLevel();

        public int getOnlineCount();

        public int getMemberCount();

        public Set<String> getFeatures();
    }

    public static interface Channel
    extends ISnowflake {
        public String getName();

        public ChannelType getType();
    }
}

