/*
 * Decompiled with CFR 0.152.
 */
package net.dv8tion.jda.api.utils;

import gnu.trove.impl.sync.TSynchronizedLongObjectMap;
import gnu.trove.map.TLongObjectMap;
import gnu.trove.map.hash.TLongObjectHashMap;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.Formatter;
import java.util.concurrent.locks.ReentrantLock;
import java.util.function.Supplier;
import net.dv8tion.jda.api.entities.Guild;
import net.dv8tion.jda.internal.utils.Checks;
import net.dv8tion.jda.internal.utils.Helpers;

public class MiscUtil {
    public static int getShardForGuild(long guildId, int shards) {
        return (int)((guildId >>> 22) % (long)shards);
    }

    public static int getShardForGuild(String guildId, int shards) {
        return MiscUtil.getShardForGuild(MiscUtil.parseSnowflake(guildId), shards);
    }

    public static int getShardForGuild(Guild guild, int shards) {
        return MiscUtil.getShardForGuild(guild.getIdLong(), shards);
    }

    public static <T> TLongObjectMap<T> newLongMap() {
        return new TSynchronizedLongObjectMap((TLongObjectMap)new TLongObjectHashMap(), new Object());
    }

    public static long parseSnowflake(String input) {
        Checks.notEmpty(input, "ID");
        try {
            if (!input.startsWith("-")) {
                return Long.parseUnsignedLong(input);
            }
            return Long.parseLong(input);
        }
        catch (NumberFormatException ex) {
            throw new NumberFormatException(String.format("The specified ID is not a valid snowflake (%s). Expecting a valid long value!", input));
        }
    }

    public static <E> E locked(ReentrantLock lock, Supplier<E> task) {
        try {
            lock.lockInterruptibly();
            E e = task.get();
            return e;
        }
        catch (InterruptedException e) {
            throw new IllegalStateException(e);
        }
        finally {
            if (lock.isHeldByCurrentThread()) {
                lock.unlock();
            }
        }
    }

    public static void locked(ReentrantLock lock, Runnable task) {
        try {
            lock.lockInterruptibly();
            task.run();
        }
        catch (InterruptedException e) {
            throw new IllegalStateException(e);
        }
        finally {
            if (lock.isHeldByCurrentThread()) {
                lock.unlock();
            }
        }
    }

    public static void appendTo(Formatter formatter, int width, int precision, boolean leftJustified, String out) {
        try {
            Appendable appendable = formatter.out();
            if (precision > -1 && out.length() > precision) {
                appendable.append(Helpers.truncate(out, precision));
                return;
            }
            if (leftJustified) {
                appendable.append(Helpers.rightPad(out, width));
            } else {
                appendable.append(Helpers.leftPad(out, width));
            }
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }
}

