/*
 * Decompiled with CFR 0.152.
 */
package net.dv8tion.jda.core.utils.cache.impl;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.SortedSet;
import java.util.Spliterator;
import java.util.Spliterators;
import java.util.TreeSet;
import java.util.function.Function;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import net.dv8tion.jda.core.entities.ISnowflake;
import net.dv8tion.jda.core.utils.cache.impl.SnowflakeCacheViewImpl;
import org.apache.commons.collections4.iterators.ObjectArrayIterator;

public class SortedSnowflakeCacheView<T extends ISnowflake & Comparable<T>>
extends SnowflakeCacheViewImpl<T> {
    protected static final int SPLIT_CHARACTERISTICS = 1296;
    protected final Comparator<T> comparator;

    public SortedSnowflakeCacheView(Class<T> type, Comparator<T> comparator) {
        this(type, null, comparator);
    }

    public SortedSnowflakeCacheView(Class<T> type, Function<T, String> nameMapper, Comparator<T> comparator) {
        super(type, nameMapper);
        this.comparator = comparator;
    }

    @Override
    public List<T> asList() {
        ArrayList list = new ArrayList(this.elements.size());
        this.elements.forEachValue(x$0 -> list.add(x$0));
        list.sort(this.comparator);
        return Collections.unmodifiableList(list);
    }

    @Override
    public SortedSet<T> asSet() {
        TreeSet set = new TreeSet(this.comparator);
        this.elements.forEachValue(x$0 -> set.add(x$0));
        return Collections.unmodifiableSortedSet(set);
    }

    @Override
    public Spliterator<T> spliterator() {
        return Spliterators.spliterator(this.iterator(), (long)this.elements.size(), 1296);
    }

    @Override
    public Stream<T> stream() {
        return super.stream().sorted(this.comparator);
    }

    @Override
    public Stream<T> parallelStream() {
        return super.parallelStream().sorted(this.comparator);
    }

    @Override
    @Nonnull
    public Iterator<T> iterator() {
        Object[] arr = (ISnowflake[])this.elements.values((Object[])((ISnowflake[])this.emptyArray));
        Arrays.sort(arr, this.comparator);
        return new ObjectArrayIterator(arr);
    }
}

