/*
 * Decompiled with CFR 0.152.
 */
package net.dv8tion.jda.core.managers;

import gnu.trove.map.hash.TLongObjectHashMap;
import gnu.trove.set.TLongSet;
import gnu.trove.set.hash.TLongHashSet;
import java.util.Collection;
import javax.annotation.CheckReturnValue;
import net.dv8tion.jda.core.Permission;
import net.dv8tion.jda.core.entities.Category;
import net.dv8tion.jda.core.entities.Channel;
import net.dv8tion.jda.core.entities.ChannelType;
import net.dv8tion.jda.core.entities.Guild;
import net.dv8tion.jda.core.entities.IPermissionHolder;
import net.dv8tion.jda.core.entities.Member;
import net.dv8tion.jda.core.entities.PermissionOverride;
import net.dv8tion.jda.core.entities.Role;
import net.dv8tion.jda.core.entities.impl.AbstractChannelImpl;
import net.dv8tion.jda.core.exceptions.InsufficientPermissionException;
import net.dv8tion.jda.core.managers.impl.ManagerBase;
import net.dv8tion.jda.core.requests.Route;
import net.dv8tion.jda.core.requests.restaction.PermOverrideData;
import net.dv8tion.jda.core.utils.Checks;
import net.dv8tion.jda.core.utils.cache.UpstreamReference;
import okhttp3.RequestBody;
import org.json.JSONObject;

public class ChannelManager
extends ManagerBase {
    public static final long NAME = 1L;
    public static final long PARENT = 2L;
    public static final long TOPIC = 4L;
    public static final long POSITION = 8L;
    public static final long NSFW = 16L;
    public static final long USERLIMIT = 32L;
    public static final long BITRATE = 64L;
    public static final long PERMISSION = 128L;
    public static final long SLOWMODE = 256L;
    protected final UpstreamReference<Channel> channel;
    protected String name;
    protected String parent;
    protected String topic;
    protected int position;
    protected boolean nsfw;
    protected int slowmode;
    protected int userlimit;
    protected int bitrate;
    protected final Object lock = new Object();
    protected final TLongObjectHashMap<PermOverrideData> overridesAdd;
    protected final TLongSet overridesRem;

    public ChannelManager(Channel channel) {
        super(channel.getJDA(), Route.Channels.MODIFY_CHANNEL.compile(channel.getId()));
        this.channel = new UpstreamReference<Channel>(channel);
        if (ChannelManager.isPermissionChecksEnabled()) {
            this.checkPermissions();
        }
        this.overridesAdd = new TLongObjectHashMap();
        this.overridesRem = new TLongHashSet();
    }

    public ChannelType getType() {
        return this.getChannel().getType();
    }

    public Channel getChannel() {
        return this.channel.get();
    }

    public Guild getGuild() {
        return this.getChannel().getGuild();
    }

    @Override
    @CheckReturnValue
    public ChannelManager reset(long fields) {
        super.reset(fields);
        if ((fields & 1L) == 1L) {
            this.name = null;
        }
        if ((fields & 2L) == 2L) {
            this.parent = null;
        }
        if ((fields & 4L) == 4L) {
            this.topic = null;
        }
        if ((fields & 0x80L) == 128L) {
            this.withLock(this.lock, lock -> {
                this.overridesRem.clear();
                this.overridesAdd.clear();
            });
        }
        return this;
    }

    @Override
    @CheckReturnValue
    public ChannelManager reset(long ... fields) {
        super.reset(fields);
        return this;
    }

    @Override
    @CheckReturnValue
    public ChannelManager reset() {
        super.reset();
        this.name = null;
        this.parent = null;
        this.topic = null;
        this.withLock(this.lock, lock -> {
            this.overridesRem.clear();
            this.overridesAdd.clear();
        });
        return this;
    }

    public ChannelManager clearOverridesAdded() {
        this.withLock(this.lock, lock -> {
            this.overridesAdd.clear();
            if (this.overridesRem.isEmpty()) {
                this.set &= 0xFFFFFFFFFFFFFF7FL;
            }
        });
        return this;
    }

    public ChannelManager clearOverridesRemoved() {
        this.withLock(this.lock, lock -> {
            this.overridesRem.clear();
            if (this.overridesAdd.isEmpty()) {
                this.set &= 0xFFFFFFFFFFFFFF7FL;
            }
        });
        return this;
    }

    @CheckReturnValue
    public ChannelManager putPermissionOverride(IPermissionHolder permHolder, long allow, long deny) {
        Checks.notNull(permHolder, "PermissionHolder");
        Checks.check(permHolder.getGuild().equals(this.getGuild()), "PermissionHolder is not from the same Guild!");
        if (ChannelManager.isPermissionChecksEnabled() && !this.getGuild().getSelfMember().hasPermission(this.getChannel(), Permission.MANAGE_PERMISSIONS)) {
            throw new InsufficientPermissionException(Permission.MANAGE_PERMISSIONS);
        }
        long id = this.getId(permHolder);
        int type = permHolder instanceof Role ? 0 : 1;
        this.withLock(this.lock, lock -> {
            this.overridesRem.remove(id);
            this.overridesAdd.put(id, (Object)new PermOverrideData(type, id, allow, deny));
            this.set |= 0x80L;
        });
        return this;
    }

    @CheckReturnValue
    public ChannelManager putPermissionOverride(IPermissionHolder permHolder, Collection<Permission> allow, Collection<Permission> deny) {
        long allowRaw = allow == null ? 0L : Permission.getRaw(allow);
        long denyRaw = deny == null ? 0L : Permission.getRaw(deny);
        return this.putPermissionOverride(permHolder, allowRaw, denyRaw);
    }

    @CheckReturnValue
    public ChannelManager removePermissionOverride(IPermissionHolder permHolder) {
        Checks.notNull(permHolder, "PermissionHolder");
        Checks.check(permHolder.getGuild().equals(this.getGuild()), "PermissionHolder is not from the same Guild!");
        if (ChannelManager.isPermissionChecksEnabled() && !this.getGuild().getSelfMember().hasPermission(this.getChannel(), Permission.MANAGE_PERMISSIONS)) {
            throw new InsufficientPermissionException(Permission.MANAGE_PERMISSIONS);
        }
        long id = this.getId(permHolder);
        this.withLock(this.lock, lock -> {
            this.overridesRem.add(id);
            this.overridesAdd.remove(id);
            this.set |= 0x80L;
        });
        return this;
    }

    @CheckReturnValue
    public ChannelManager sync() {
        if (this.getChannel().getParent() == null) {
            throw new IllegalStateException("sync() requires a parent category");
        }
        return this.sync(this.getChannel().getParent());
    }

    @CheckReturnValue
    public ChannelManager sync(Channel syncSource) {
        Checks.notNull(syncSource, "SyncSource");
        Checks.check(this.getGuild().equals(syncSource.getGuild()), "Sync only works for channels of same guild");
        if (syncSource.equals(this.getChannel())) {
            return this;
        }
        if (ChannelManager.isPermissionChecksEnabled() && !this.getGuild().getSelfMember().hasPermission(this.getChannel(), Permission.MANAGE_PERMISSIONS)) {
            throw new InsufficientPermissionException(Permission.MANAGE_PERMISSIONS);
        }
        this.withLock(this.lock, lock -> {
            this.overridesRem.clear();
            this.overridesAdd.clear();
            this.getChannel().getPermissionOverrides().forEach(permO -> this.overridesRem.add(this.getId(permO.isRoleOverride() ? permO.getRole() : permO.getMember())));
            syncSource.getPermissionOverrides().forEach(permO -> {
                int type = permO.isRoleOverride() ? 0 : 1;
                long id = this.getId(permO.isRoleOverride() ? permO.getRole() : permO.getMember());
                this.overridesRem.remove(id);
                this.overridesAdd.put(id, (Object)new PermOverrideData(type, id, permO.getAllowedRaw(), permO.getDeniedRaw()));
            });
            this.set |= 0x80L;
        });
        return this;
    }

    @CheckReturnValue
    public ChannelManager setName(String name) {
        Checks.notBlank(name, "Name");
        Checks.check(name.length() > 0 && name.length() <= 100, "Name must be between 1-100 characters long");
        if (this.getType() == ChannelType.TEXT) {
            Checks.noWhitespace(name, "Name");
        }
        this.name = name;
        this.set |= 1L;
        return this;
    }

    @CheckReturnValue
    public ChannelManager setParent(Category category) {
        if (category != null) {
            if (this.getType() == ChannelType.CATEGORY) {
                throw new IllegalStateException("Cannot set the parent of a category");
            }
            Checks.check(category.getGuild().equals(this.getGuild()), "Category is not from the same guild");
        }
        this.parent = category == null ? null : category.getId();
        this.set |= 2L;
        return this;
    }

    @CheckReturnValue
    public ChannelManager setPosition(int position) {
        this.position = position;
        this.set |= 8L;
        return this;
    }

    @CheckReturnValue
    public ChannelManager setTopic(String topic) {
        if (this.getType() != ChannelType.TEXT) {
            throw new IllegalStateException("Can only set topic on text channels");
        }
        Checks.check(topic == null || topic.length() <= 1024, "Topic must be less or equal to 1024 characters in length");
        this.topic = topic;
        this.set |= 4L;
        return this;
    }

    @CheckReturnValue
    public ChannelManager setNSFW(boolean nsfw) {
        if (this.getType() != ChannelType.TEXT) {
            throw new IllegalStateException("Can only set nsfw on text channels");
        }
        this.nsfw = nsfw;
        this.set |= 0x10L;
        return this;
    }

    @CheckReturnValue
    public ChannelManager setSlowmode(int slowmode) {
        if (this.getType() != ChannelType.TEXT) {
            throw new IllegalStateException("Can only set slowmode on text channels");
        }
        Checks.check(slowmode <= 21600 && slowmode >= 0, "Slowmode per user must be between 0 and 21600 (seconds)!");
        this.slowmode = slowmode;
        this.set |= 0x100L;
        return this;
    }

    @CheckReturnValue
    public ChannelManager setUserLimit(int userLimit) {
        if (this.getType() != ChannelType.VOICE) {
            throw new IllegalStateException("Can only set userlimit on voice channels");
        }
        Checks.notNegative(userLimit, "Userlimit");
        Checks.check(userLimit <= 99, "Userlimit may not be greater than 99");
        this.userlimit = userLimit;
        this.set |= 0x20L;
        return this;
    }

    @CheckReturnValue
    public ChannelManager setBitrate(int bitrate) {
        if (this.getType() != ChannelType.VOICE) {
            throw new IllegalStateException("Can only set bitrate on voice channels");
        }
        int maxBitrate = this.getGuild().getFeatures().contains("VIP_REGIONS") ? 128000 : 96000;
        Checks.check(bitrate >= 8000, "Bitrate must be greater or equal to 8000");
        Checks.check(bitrate <= maxBitrate, "Bitrate must be less or equal to %s", (Object)maxBitrate);
        this.bitrate = bitrate;
        this.set |= 0x40L;
        return this;
    }

    @Override
    protected RequestBody finalizeData() {
        JSONObject frame = new JSONObject().put("name", (Object)this.getChannel().getName());
        if (this.shouldUpdate(1L)) {
            frame.put("name", (Object)this.name);
        }
        if (this.shouldUpdate(8L)) {
            frame.put("position", this.position);
        }
        if (this.shouldUpdate(4L)) {
            frame.put("topic", this.opt(this.topic));
        }
        if (this.shouldUpdate(16L)) {
            frame.put("nsfw", this.nsfw);
        }
        if (this.shouldUpdate(256L)) {
            frame.put("rate_limit_per_user", this.slowmode);
        }
        if (this.shouldUpdate(32L)) {
            frame.put("user_limit", this.userlimit);
        }
        if (this.shouldUpdate(64L)) {
            frame.put("bitrate", this.bitrate);
        }
        if (this.shouldUpdate(2L)) {
            frame.put("parent_id", this.opt(this.parent));
        }
        this.withLock(this.lock, lock -> {
            if (this.shouldUpdate(128L)) {
                frame.put("permission_overwrites", this.getOverrides());
            }
        });
        this.reset();
        return this.getRequestBody(frame);
    }

    @Override
    protected boolean checkPermissions() {
        Member selfMember = this.getGuild().getSelfMember();
        if (!selfMember.hasPermission(this.getChannel(), Permission.MANAGE_CHANNEL)) {
            throw new InsufficientPermissionException(Permission.MANAGE_CHANNEL);
        }
        return super.checkPermissions();
    }

    protected Collection<PermOverrideData> getOverrides() {
        TLongObjectHashMap data = new TLongObjectHashMap(this.overridesAdd);
        AbstractChannelImpl impl = (AbstractChannelImpl)this.getChannel();
        impl.getOverrideMap().forEachEntry((id, override) -> {
            if (!this.overridesRem.remove(id) && !data.containsKey(id)) {
                data.put(id, (Object)new PermOverrideData((PermissionOverride)override));
            }
            return true;
        });
        return data.valueCollection();
    }

    protected long getId(IPermissionHolder holder) {
        if (holder instanceof Role) {
            return ((Role)holder).getIdLong();
        }
        return ((Member)holder).getUser().getIdLong();
    }
}

