/*
 * Decompiled with CFR 0.152.
 */
package net.dv8tion.jda.core.handle;

import net.dv8tion.jda.client.entities.impl.GroupImpl;
import net.dv8tion.jda.client.events.message.group.GroupMessageReceivedEvent;
import net.dv8tion.jda.core.JDA;
import net.dv8tion.jda.core.entities.Message;
import net.dv8tion.jda.core.entities.MessageType;
import net.dv8tion.jda.core.entities.impl.JDAImpl;
import net.dv8tion.jda.core.entities.impl.PrivateChannelImpl;
import net.dv8tion.jda.core.entities.impl.TextChannelImpl;
import net.dv8tion.jda.core.events.message.MessageReceivedEvent;
import net.dv8tion.jda.core.events.message.guild.GuildMessageReceivedEvent;
import net.dv8tion.jda.core.events.message.priv.PrivateMessageReceivedEvent;
import net.dv8tion.jda.core.handle.EventCache;
import net.dv8tion.jda.core.handle.SocketHandler;
import net.dv8tion.jda.core.hooks.IEventManager;
import net.dv8tion.jda.core.requests.WebSocketClient;
import org.json.JSONObject;

public class MessageCreateHandler
extends SocketHandler {
    public MessageCreateHandler(JDAImpl api) {
        super(api);
    }

    @Override
    protected Long handleInternally(JSONObject content) {
        Message message;
        MessageType type = MessageType.fromId(content.getInt("type"));
        if (type == MessageType.UNKNOWN) {
            WebSocketClient.LOG.debug("JDA received a message of unknown type. Type: {}  JSON: {}", (Object)type, (Object)content);
            return null;
        }
        if (!content.isNull("guild_id")) {
            long guildId = content.getLong("guild_id");
            if (this.getJDA().getGuildSetupController().isLocked(guildId)) {
                return guildId;
            }
        }
        try {
            message = this.getJDA().getEntityBuilder().createMessage(content, true);
        }
        catch (IllegalArgumentException e) {
            switch (e.getMessage()) {
                case "MISSING_CHANNEL": {
                    long channelId = content.getLong("channel_id");
                    this.getJDA().getEventCache().cache(EventCache.Type.CHANNEL, channelId, this.responseNumber, this.allContent, this::handle);
                    EventCache.LOG.debug("Received a message for a channel that JDA does not currently have cached");
                    return null;
                }
                case "MISSING_USER": {
                    long authorId = content.getJSONObject("author").getLong("id");
                    this.getJDA().getEventCache().cache(EventCache.Type.USER, authorId, this.responseNumber, this.allContent, this::handle);
                    EventCache.LOG.debug("Received a message for a user that JDA does not currently have cached");
                    return null;
                }
            }
            throw e;
        }
        IEventManager manager = this.getJDA().getEventManager();
        switch (message.getChannelType()) {
            case NEWS: 
            case TEXT: {
                TextChannelImpl channel = (TextChannelImpl)message.getTextChannel();
                if (this.getJDA().getGuildSetupController().isLocked(channel.getGuild().getIdLong())) {
                    return channel.getGuild().getIdLong();
                }
                channel.setLastMessageId(message.getIdLong());
                manager.handle(new GuildMessageReceivedEvent((JDA)this.getJDA(), this.responseNumber, message));
                break;
            }
            case PRIVATE: {
                PrivateChannelImpl channel = (PrivateChannelImpl)message.getPrivateChannel();
                channel.setLastMessageId(message.getIdLong());
                manager.handle(new PrivateMessageReceivedEvent(this.getJDA(), this.responseNumber, message));
                break;
            }
            case GROUP: {
                GroupImpl channel = (GroupImpl)message.getGroup();
                channel.setLastMessageId(message.getIdLong());
                manager.handle(new GroupMessageReceivedEvent((JDA)this.getJDA(), this.responseNumber, message));
                break;
            }
            default: {
                WebSocketClient.LOG.warn("Received a MESSAGE_CREATE with a unknown MessageChannel ChannelType. JSON: {}", (Object)content);
                return null;
            }
        }
        manager.handle(new MessageReceivedEvent(this.getJDA(), this.responseNumber, message));
        return null;
    }
}

