/*
 * Decompiled with CFR 0.152.
 */
package net.dv8tion.jda.core.entities.impl;

import java.awt.Color;
import java.time.Instant;
import java.time.OffsetDateTime;
import java.time.ZoneOffset;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.annotation.Nullable;
import net.dv8tion.jda.core.JDA;
import net.dv8tion.jda.core.OnlineStatus;
import net.dv8tion.jda.core.Permission;
import net.dv8tion.jda.core.entities.Channel;
import net.dv8tion.jda.core.entities.Emote;
import net.dv8tion.jda.core.entities.Game;
import net.dv8tion.jda.core.entities.GuildVoiceState;
import net.dv8tion.jda.core.entities.Member;
import net.dv8tion.jda.core.entities.Role;
import net.dv8tion.jda.core.entities.TextChannel;
import net.dv8tion.jda.core.entities.User;
import net.dv8tion.jda.core.entities.impl.GuildImpl;
import net.dv8tion.jda.core.entities.impl.GuildVoiceStateImpl;
import net.dv8tion.jda.core.entities.impl.JDAImpl;
import net.dv8tion.jda.core.utils.Checks;
import net.dv8tion.jda.core.utils.PermissionUtil;
import net.dv8tion.jda.core.utils.cache.CacheFlag;
import net.dv8tion.jda.core.utils.cache.UpstreamReference;

public class MemberImpl
implements Member {
    private static final ZoneOffset OFFSET = ZoneOffset.of("+00:00");
    private final UpstreamReference<GuildImpl> guild;
    private final User user;
    private final Set<Role> roles = new HashSet<Role>();
    private final GuildVoiceState voiceState;
    private String nickname;
    private long joinDate;
    private Game game;
    private OnlineStatus onlineStatus = OnlineStatus.OFFLINE;

    public MemberImpl(GuildImpl guild, User user) {
        this.guild = new UpstreamReference<GuildImpl>(guild);
        this.user = user;
        JDAImpl jda = (JDAImpl)this.getJDA();
        boolean cacheState = jda.isCacheFlagSet(CacheFlag.VOICE_STATE) || user.equals(jda.getSelfUser());
        this.voiceState = cacheState ? new GuildVoiceStateImpl(guild, this) : null;
    }

    @Override
    public User getUser() {
        return this.user;
    }

    @Override
    public GuildImpl getGuild() {
        return this.guild.get();
    }

    @Override
    public JDA getJDA() {
        return this.user.getJDA();
    }

    @Override
    public OffsetDateTime getJoinDate() {
        return OffsetDateTime.ofInstant(Instant.ofEpochMilli(this.joinDate), OFFSET);
    }

    @Override
    public GuildVoiceState getVoiceState() {
        return this.voiceState;
    }

    @Override
    public Game getGame() {
        return this.game;
    }

    @Override
    public OnlineStatus getOnlineStatus() {
        return this.onlineStatus;
    }

    @Override
    public String getNickname() {
        return this.nickname;
    }

    @Override
    public String getEffectiveName() {
        return this.nickname != null ? this.nickname : this.user.getName();
    }

    @Override
    public List<Role> getRoles() {
        ArrayList<Role> roleList = new ArrayList<Role>(this.roles);
        roleList.sort(Comparator.reverseOrder());
        return Collections.unmodifiableList(roleList);
    }

    @Override
    public Color getColor() {
        int raw = this.getColorRaw();
        return raw != 0x1FFFFFFF ? new Color(raw) : null;
    }

    @Override
    public int getColorRaw() {
        for (Role r : this.getRoles()) {
            int colorRaw = r.getColorRaw();
            if (colorRaw == 0x1FFFFFFF) continue;
            return colorRaw;
        }
        return 0x1FFFFFFF;
    }

    @Override
    public List<Permission> getPermissions() {
        return Collections.unmodifiableList(Permission.getPermissions(PermissionUtil.getEffectivePermission(this)));
    }

    @Override
    public List<Permission> getPermissions(Channel channel) {
        if (!this.getGuild().equals(channel.getGuild())) {
            throw new IllegalArgumentException("Provided channel is not in the same guild as this member!");
        }
        return Collections.unmodifiableList(Permission.getPermissions(PermissionUtil.getEffectivePermission(channel, this)));
    }

    @Override
    public boolean hasPermission(Permission ... permissions) {
        return PermissionUtil.checkPermission(this, permissions);
    }

    @Override
    public boolean hasPermission(Collection<Permission> permissions) {
        Checks.notNull(permissions, "Permission Collection");
        return this.hasPermission(permissions.toArray(Permission.EMPTY_PERMISSIONS));
    }

    @Override
    public boolean hasPermission(Channel channel, Permission ... permissions) {
        return PermissionUtil.checkPermission(channel, this, permissions);
    }

    @Override
    public boolean hasPermission(Channel channel, Collection<Permission> permissions) {
        Checks.notNull(permissions, "Permission Collection");
        return this.hasPermission(channel, permissions.toArray(Permission.EMPTY_PERMISSIONS));
    }

    @Override
    public boolean canInteract(Member member) {
        return PermissionUtil.canInteract((Member)this, member);
    }

    @Override
    public boolean canInteract(Role role) {
        return PermissionUtil.canInteract((Member)this, role);
    }

    @Override
    public boolean canInteract(Emote emote) {
        return PermissionUtil.canInteract((Member)this, emote);
    }

    @Override
    public boolean isOwner() {
        return this.equals(this.getGuild().getOwner());
    }

    public MemberImpl setNickname(String nickname) {
        this.nickname = nickname;
        return this;
    }

    public MemberImpl setJoinDate(long joinDate) {
        this.joinDate = joinDate;
        return this;
    }

    public MemberImpl setGame(Game game) {
        this.game = game;
        return this;
    }

    public MemberImpl setOnlineStatus(OnlineStatus onlineStatus) {
        this.onlineStatus = onlineStatus;
        return this;
    }

    public Set<Role> getRoleSet() {
        return this.roles;
    }

    public boolean equals(Object o) {
        if (!(o instanceof Member)) {
            return false;
        }
        Member oMember = (Member)o;
        return this == oMember || oMember.getUser().equals(this.user) && oMember.getGuild().equals(this.getGuild());
    }

    public int hashCode() {
        return (this.getGuild().getId() + this.user.getId()).hashCode();
    }

    public String toString() {
        return "MB:" + this.getEffectiveName() + '(' + this.user.toString() + " / " + this.getGuild().toString() + ')';
    }

    @Override
    public String getAsMention() {
        return this.nickname == null ? this.user.getAsMention() : "<@!" + this.user.getIdLong() + '>';
    }

    @Override
    @Nullable
    public TextChannel getDefaultChannel() {
        return this.getGuild().getTextChannelsMap().valueCollection().stream().sorted(Comparator.reverseOrder()).filter(c -> this.hasPermission((Channel)c, Permission.MESSAGE_READ)).findFirst().orElse(null);
    }
}

