/*
 * Decompiled with CFR 0.152.
 */
package net.dv8tion.jda.webhook;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.dv8tion.jda.core.entities.Message;
import net.dv8tion.jda.core.entities.MessageEmbed;
import net.dv8tion.jda.core.requests.Requester;
import net.dv8tion.jda.core.utils.Checks;
import net.dv8tion.jda.core.utils.MiscUtil;
import net.dv8tion.jda.webhook.MessageAttachment;
import okhttp3.MediaType;
import okhttp3.MultipartBody;
import okhttp3.RequestBody;
import org.json.JSONArray;
import org.json.JSONObject;

public class WebhookMessage {
    protected final String username;
    protected final String avatarUrl;
    protected final String content;
    protected final List<MessageEmbed> embeds;
    protected final boolean isTTS;
    protected final MessageAttachment[] attachments;

    protected WebhookMessage(String username, String avatarUrl, String content, List<MessageEmbed> embeds, boolean isTTS, MessageAttachment[] files) {
        this.username = username;
        this.avatarUrl = avatarUrl;
        this.content = content;
        this.embeds = embeds;
        this.isTTS = isTTS;
        this.attachments = files;
    }

    public static WebhookMessage embeds(MessageEmbed first, MessageEmbed ... embeds) {
        Checks.notNull(first, "Embeds");
        Checks.noneNull(embeds, "Embeds");
        ArrayList<MessageEmbed> list = new ArrayList<MessageEmbed>(1 + embeds.length);
        list.add(first);
        Collections.addAll(list, embeds);
        return new WebhookMessage(null, null, null, list, false, null);
    }

    public static WebhookMessage embeds(Collection<MessageEmbed> embeds) {
        Checks.notEmpty(embeds, "Embeds");
        Checks.noneNull(embeds, "Embeds");
        return new WebhookMessage(null, null, null, new ArrayList<MessageEmbed>(embeds), false, null);
    }

    public static WebhookMessage files(Map<String, ?> attachments) {
        Checks.notNull(attachments, "Attachments");
        Set<Map.Entry<String, ?>> entries = attachments.entrySet();
        Checks.notEmpty(entries, "Attachments");
        int fileAmount = attachments.size();
        Checks.check(fileAmount <= 10, "Cannot add more than %d files to a message", (Object)10);
        MessageAttachment[] files = new MessageAttachment[fileAmount];
        int i = 0;
        for (Map.Entry<String, ?> attachment : entries) {
            String name = attachment.getKey();
            Checks.notEmpty(name, "Name");
            Object data = attachment.getValue();
            files[i++] = WebhookMessage.convertAttachment(name, data);
        }
        return new WebhookMessage(null, null, null, null, false, files);
    }

    public static WebhookMessage files(String name1, Object data1, Object ... attachments) {
        Checks.notBlank(name1, "Name");
        Checks.notNull(data1, "Data");
        Checks.notNull(attachments, "Attachments");
        Checks.check(attachments.length % 2 == 0, "Must provide even number of varargs arguments");
        int fileAmount = 1 + attachments.length / 2;
        Checks.check(fileAmount <= 10, "Cannot add more than %d files to a message", (Object)10);
        MessageAttachment[] files = new MessageAttachment[fileAmount];
        files[0] = WebhookMessage.convertAttachment(name1, data1);
        int j = 1;
        for (int i = 0; i < attachments.length; i += 2) {
            Object name = attachments[i];
            Object data = attachments[i + 1];
            if (!(name instanceof String)) {
                throw new IllegalArgumentException("Provided arguments must be pairs for (String, Data). Expected String and found " + (name == null ? null : name.getClass().getName()));
            }
            files[j] = WebhookMessage.convertAttachment((String)name, data);
            ++j;
        }
        return new WebhookMessage(null, null, null, null, false, files);
    }

    public static WebhookMessage from(Message message) {
        Checks.notNull(message, "Message");
        String content = message.getContentRaw();
        List<MessageEmbed> embeds = message.getEmbeds();
        boolean isTTS = message.isTTS();
        return new WebhookMessage(null, null, content, embeds, isTTS, null);
    }

    public boolean isFile() {
        return this.attachments != null;
    }

    protected RequestBody getBody() {
        JSONObject payload = new JSONObject();
        if (this.content != null) {
            payload.put("content", (Object)this.content);
        }
        if (this.embeds != null && !this.embeds.isEmpty()) {
            JSONArray array = new JSONArray();
            for (MessageEmbed embed : this.embeds) {
                array.put((Object)embed.toJSONObject());
            }
            payload.put("embeds", (Object)array);
        }
        if (this.avatarUrl != null) {
            payload.put("avatar_url", (Object)this.avatarUrl);
        }
        if (this.username != null) {
            payload.put("username", (Object)this.username);
        }
        payload.put("tts", this.isTTS);
        if (this.isFile()) {
            MessageAttachment attachment;
            MultipartBody.Builder builder = new MultipartBody.Builder().setType(MultipartBody.FORM);
            for (int i = 0; i < this.attachments.length && (attachment = this.attachments[i]) != null; ++i) {
                builder.addFormDataPart("file" + i, attachment.name, MiscUtil.createRequestBody(Requester.MEDIA_TYPE_OCTET, attachment.getData()));
            }
            return builder.addFormDataPart("payload_json", payload.toString()).build();
        }
        return RequestBody.create((MediaType)Requester.MEDIA_TYPE_JSON, (String)payload.toString());
    }

    private static MessageAttachment convertAttachment(String name, Object data) {
        Checks.notNull(data, "Data");
        try {
            MessageAttachment a;
            if (data instanceof File) {
                a = new MessageAttachment(name, (File)data);
            } else if (data instanceof InputStream) {
                a = new MessageAttachment(name, (InputStream)data);
            } else if (data instanceof byte[]) {
                a = new MessageAttachment(name, (byte[])data);
            } else {
                throw new IllegalArgumentException("Provided arguments must be pairs for (String, Data). Unexpected data type " + data.getClass().getName());
            }
            return a;
        }
        catch (IOException ex) {
            throw new IllegalArgumentException(ex);
        }
    }
}

