/*
 * Decompiled with CFR 0.152.
 */
package net.dv8tion.jda.core.requests.restaction.pagination;

import gnu.trove.map.hash.TLongObjectHashMap;
import java.util.ArrayList;
import java.util.List;
import net.dv8tion.jda.core.Permission;
import net.dv8tion.jda.core.audit.ActionType;
import net.dv8tion.jda.core.audit.AuditLogEntry;
import net.dv8tion.jda.core.entities.EntityBuilder;
import net.dv8tion.jda.core.entities.Guild;
import net.dv8tion.jda.core.entities.User;
import net.dv8tion.jda.core.entities.impl.GuildImpl;
import net.dv8tion.jda.core.entities.impl.JDAImpl;
import net.dv8tion.jda.core.exceptions.InsufficientPermissionException;
import net.dv8tion.jda.core.requests.Request;
import net.dv8tion.jda.core.requests.Response;
import net.dv8tion.jda.core.requests.Route;
import net.dv8tion.jda.core.requests.restaction.pagination.PaginationAction;
import net.dv8tion.jda.core.utils.Checks;
import net.dv8tion.jda.core.utils.Helpers;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class AuditLogPaginationAction
extends PaginationAction<AuditLogEntry, AuditLogPaginationAction> {
    protected final Guild guild;
    protected ActionType type = null;
    protected String userId = null;

    public AuditLogPaginationAction(Guild guild) {
        super(guild.getJDA(), Route.Guilds.GET_AUDIT_LOGS.compile(guild.getId()), 1, 100, 100);
        if (!guild.getSelfMember().hasPermission(Permission.VIEW_AUDIT_LOGS)) {
            throw new InsufficientPermissionException(Permission.VIEW_AUDIT_LOGS);
        }
        this.guild = guild;
    }

    public AuditLogPaginationAction type(ActionType type) {
        this.type = type;
        return this;
    }

    public AuditLogPaginationAction user(User user) {
        return this.user(user == null ? null : user.getId());
    }

    public AuditLogPaginationAction user(String userId) {
        Checks.isSnowflake(userId, "User ID");
        this.userId = userId;
        return this;
    }

    public AuditLogPaginationAction user(long userId) {
        return this.user(Long.toUnsignedString(userId));
    }

    public Guild getGuild() {
        return this.guild;
    }

    @Override
    protected Route.CompiledRoute finalizeRoute() {
        Route.CompiledRoute route = super.finalizeRoute();
        String limit = String.valueOf(this.limit.get());
        AuditLogEntry last = (AuditLogEntry)this.last;
        route = route.withQueryParams("limit", limit);
        if (this.type != null) {
            route = route.withQueryParams("action_type", String.valueOf(this.type.getKey()));
        }
        if (this.userId != null) {
            route = route.withQueryParams("user_id", this.userId);
        }
        if (last != null) {
            route = route.withQueryParams("before", last.getId());
        }
        return route;
    }

    @Override
    protected void handleResponse(Response response, Request<List<AuditLogEntry>> request) {
        int i;
        if (!response.isOk()) {
            request.onFailure(response);
            return;
        }
        JSONObject obj = response.getObject();
        JSONArray users = obj.getJSONArray("users");
        JSONArray webhooks = obj.getJSONArray("webhooks");
        JSONArray entries = obj.getJSONArray("audit_log_entries");
        ArrayList<AuditLogEntry> list = new ArrayList<AuditLogEntry>(entries.length());
        EntityBuilder builder = ((JDAImpl)this.api.get()).getEntityBuilder();
        TLongObjectHashMap userMap = new TLongObjectHashMap();
        for (int i2 = 0; i2 < users.length(); ++i2) {
            JSONObject user = users.getJSONObject(i2);
            userMap.put(user.getLong("id"), (Object)user);
        }
        TLongObjectHashMap webhookMap = new TLongObjectHashMap();
        for (i = 0; i < webhooks.length(); ++i) {
            JSONObject webhook = webhooks.getJSONObject(i);
            webhookMap.put(webhook.getLong("id"), (Object)webhook);
        }
        for (i = 0; i < entries.length(); ++i) {
            try {
                JSONObject entry = entries.getJSONObject(i);
                JSONObject user = (JSONObject)userMap.get(Helpers.optLong(entry, "user_id", 0L));
                JSONObject webhook = (JSONObject)webhookMap.get(Helpers.optLong(entry, "target_id", 0L));
                AuditLogEntry result = builder.createAuditLogEntry((GuildImpl)this.guild, entry, user, webhook);
                list.add(result);
                if (this.useCache) {
                    this.cached.add(result);
                }
                this.last = result;
                continue;
            }
            catch (NullPointerException | JSONException e) {
                LOG.warn("Encountered exception in AuditLogPagination", e);
            }
        }
        request.onSuccess(list);
    }
}

