/*
 * Decompiled with CFR 0.152.
 */
package net.dv8tion.jda.core.handle;

import java.time.Instant;
import java.time.OffsetDateTime;
import java.time.ZoneOffset;
import net.dv8tion.jda.client.entities.Group;
import net.dv8tion.jda.client.entities.impl.GroupImpl;
import net.dv8tion.jda.core.AccountType;
import net.dv8tion.jda.core.entities.MessageChannel;
import net.dv8tion.jda.core.entities.PrivateChannel;
import net.dv8tion.jda.core.entities.User;
import net.dv8tion.jda.core.entities.impl.JDAImpl;
import net.dv8tion.jda.core.events.user.UserTypingEvent;
import net.dv8tion.jda.core.handle.SocketHandler;
import org.json.JSONObject;

public class TypingStartHandler
extends SocketHandler {
    public TypingStartHandler(JDAImpl api) {
        super(api);
    }

    @Override
    protected Long handleInternally(JSONObject content) {
        if (!content.isNull("guild_id")) {
            long guildId = content.getLong("guild_id");
            if (this.getJDA().getGuildSetupController().isLocked(guildId)) {
                return guildId;
            }
        }
        long channelId = content.getLong("channel_id");
        MessageChannel channel = (MessageChannel)this.getJDA().getTextChannelMap().get(channelId);
        if (channel == null) {
            channel = (MessageChannel)this.getJDA().getPrivateChannelMap().get(channelId);
        }
        if (channel == null) {
            channel = (MessageChannel)this.getJDA().getFakePrivateChannelMap().get(channelId);
        }
        if (channel == null && this.getJDA().getAccountType() == AccountType.CLIENT) {
            channel = this.getJDA().asClient().getGroupById(channelId);
        }
        if (channel == null) {
            return null;
        }
        long userId = content.getLong("user_id");
        User user = channel instanceof PrivateChannel ? ((PrivateChannel)channel).getUser() : (channel instanceof Group ? (User)((GroupImpl)channel).getUserMap().get(userId) : (User)this.getJDA().getUserMap().get(userId));
        if (user == null) {
            return null;
        }
        OffsetDateTime timestamp = Instant.ofEpochSecond(content.getInt("timestamp")).atOffset(ZoneOffset.UTC);
        this.getJDA().getEventManager().handle(new UserTypingEvent(this.getJDA(), this.responseNumber, user, channel, timestamp));
        return null;
    }
}

