/*
 * Decompiled with CFR 0.152.
 */
package net.dv8tion.jda.core.managers;

import java.util.Collection;
import javax.annotation.CheckReturnValue;
import net.dv8tion.jda.core.Permission;
import net.dv8tion.jda.core.entities.Channel;
import net.dv8tion.jda.core.entities.Guild;
import net.dv8tion.jda.core.entities.PermissionOverride;
import net.dv8tion.jda.core.exceptions.InsufficientPermissionException;
import net.dv8tion.jda.core.managers.impl.ManagerBase;
import net.dv8tion.jda.core.requests.Route;
import net.dv8tion.jda.core.utils.Checks;
import okhttp3.RequestBody;
import org.json.JSONObject;

public class PermOverrideManager
extends ManagerBase {
    public static final long DENIED = 1L;
    public static final long ALLOWED = 2L;
    public static final long PERMISSIONS = 3L;
    protected final PermissionOverride override;
    protected long allowed;
    protected long denied;

    public PermOverrideManager(PermissionOverride override) {
        super(override.getJDA(), Route.Channels.MODIFY_PERM_OVERRIDE.compile(override.getChannel().getId(), override.isMemberOverride() ? override.getMember().getUser().getId() : override.getRole().getId()));
        this.override = override;
        this.allowed = override.getAllowedRaw();
        this.denied = override.getDeniedRaw();
        if (PermOverrideManager.isPermissionChecksEnabled()) {
            this.checkPermissions();
        }
    }

    private void setupValues() {
        if (!this.shouldUpdate(2L)) {
            this.allowed = this.override.getAllowedRaw();
        }
        if (!this.shouldUpdate(1L)) {
            this.denied = this.override.getDeniedRaw();
        }
    }

    public Guild getGuild() {
        return this.override.getGuild();
    }

    public Channel getChannel() {
        return this.override.getChannel();
    }

    public PermissionOverride getPermissionOverride() {
        return this.override;
    }

    @Override
    @CheckReturnValue
    public PermOverrideManager reset(long fields) {
        super.reset(fields);
        return this;
    }

    @Override
    @CheckReturnValue
    public PermOverrideManager reset(long ... fields) {
        super.reset(fields);
        return this;
    }

    @Override
    @CheckReturnValue
    public PermOverrideManager reset() {
        super.reset();
        return this;
    }

    @CheckReturnValue
    public PermOverrideManager grant(long permissions) {
        if (permissions == 0L) {
            return this;
        }
        this.setupValues();
        this.allowed |= permissions;
        this.denied &= permissions ^ 0xFFFFFFFFFFFFFFFFL;
        this.set |= 2L;
        return this;
    }

    @CheckReturnValue
    public PermOverrideManager grant(Permission ... permissions) {
        Checks.notNull(permissions, "Permissions");
        return this.grant(Permission.getRaw(permissions));
    }

    @CheckReturnValue
    public PermOverrideManager grant(Collection<Permission> permissions) {
        return this.grant(Permission.getRaw(permissions));
    }

    @CheckReturnValue
    public PermOverrideManager deny(long permissions) {
        if (permissions == 0L) {
            return this;
        }
        this.setupValues();
        this.denied |= permissions;
        this.allowed &= permissions ^ 0xFFFFFFFFFFFFFFFFL;
        this.set |= 1L;
        return this;
    }

    @CheckReturnValue
    public PermOverrideManager deny(Permission ... permissions) {
        Checks.notNull(permissions, "Permissions");
        return this.deny(Permission.getRaw(permissions));
    }

    @CheckReturnValue
    public PermOverrideManager deny(Collection<Permission> permissions) {
        return this.deny(Permission.getRaw(permissions));
    }

    @CheckReturnValue
    public PermOverrideManager clear(long permissions) {
        this.setupValues();
        if ((this.allowed & permissions) != 0L) {
            this.allowed &= permissions ^ 0xFFFFFFFFFFFFFFFFL;
            this.set |= 2L;
        }
        if ((this.denied & permissions) != 0L) {
            this.denied &= permissions ^ 0xFFFFFFFFFFFFFFFFL;
            this.set |= 1L;
        }
        return this;
    }

    @CheckReturnValue
    public PermOverrideManager clear(Permission ... permissions) {
        Checks.notNull(permissions, "Permissions");
        return this.clear(Permission.getRaw(permissions));
    }

    @CheckReturnValue
    public PermOverrideManager clear(Collection<Permission> permissions) {
        return this.clear(Permission.getRaw(permissions));
    }

    @Override
    protected RequestBody finalizeData() {
        String targetId = this.override.isMemberOverride() ? this.override.getMember().getUser().getId() : this.override.getRole().getId();
        this.setupValues();
        RequestBody data = this.getRequestBody(new JSONObject().put("id", (Object)targetId).put("type", (Object)(this.override.isMemberOverride() ? "member" : "role")).put("allow", this.allowed).put("deny", this.denied));
        this.reset();
        return data;
    }

    @Override
    protected boolean checkPermissions() {
        if (!this.getGuild().getSelfMember().hasPermission(this.getChannel(), Permission.MANAGE_PERMISSIONS)) {
            throw new InsufficientPermissionException(Permission.MANAGE_PERMISSIONS);
        }
        return super.checkPermissions();
    }
}

