/*
 * Decompiled with CFR 0.152.
 */
package net.dv8tion.jda.core.managers;

import java.util.Arrays;
import java.util.Collection;
import java.util.EnumSet;
import net.dv8tion.jda.core.JDA;
import net.dv8tion.jda.core.audio.AudioReceiveHandler;
import net.dv8tion.jda.core.audio.AudioSendHandler;
import net.dv8tion.jda.core.audio.SpeakingMode;
import net.dv8tion.jda.core.audio.hooks.ConnectionListener;
import net.dv8tion.jda.core.audio.hooks.ConnectionStatus;
import net.dv8tion.jda.core.entities.Guild;
import net.dv8tion.jda.core.entities.VoiceChannel;
import net.dv8tion.jda.core.utils.Checks;
import net.dv8tion.jda.core.utils.JDALogger;
import org.slf4j.Logger;

public interface AudioManager {
    public static final long DEFAULT_CONNECTION_TIMEOUT = 10000L;
    public static final Logger LOG = JDALogger.getLog(AudioManager.class);

    public void openAudioConnection(VoiceChannel var1);

    public void closeAudioConnection();

    public void setSpeakingMode(Collection<SpeakingMode> var1);

    default public void setSpeakingMode(SpeakingMode ... mode) {
        Checks.notNull(mode, "Speaking Mode");
        this.setSpeakingMode(Arrays.asList(mode));
    }

    public EnumSet<SpeakingMode> getSpeakingMode();

    public JDA getJDA();

    public Guild getGuild();

    public boolean isAttemptingToConnect();

    public VoiceChannel getQueuedAudioConnection();

    public VoiceChannel getConnectedChannel();

    public boolean isConnected();

    public void setConnectTimeout(long var1);

    public long getConnectTimeout();

    public void setSendingHandler(AudioSendHandler var1);

    public AudioSendHandler getSendingHandler();

    public void setReceivingHandler(AudioReceiveHandler var1);

    public AudioReceiveHandler getReceiveHandler();

    public void setConnectionListener(ConnectionListener var1);

    public ConnectionListener getConnectionListener();

    public ConnectionStatus getConnectionStatus();

    public void setAutoReconnect(boolean var1);

    public boolean isAutoReconnect();

    public void setSelfMuted(boolean var1);

    public boolean isSelfMuted();

    public void setSelfDeafened(boolean var1);

    public boolean isSelfDeafened();
}

