/*
 * Decompiled with CFR 0.152.
 */
package net.dv8tion.jda.client.entities.impl;

import gnu.trove.map.TLongObjectMap;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import net.dv8tion.jda.client.JDAClient;
import net.dv8tion.jda.client.entities.Application;
import net.dv8tion.jda.client.entities.AuthorizedApplication;
import net.dv8tion.jda.client.entities.CallUser;
import net.dv8tion.jda.client.entities.Friend;
import net.dv8tion.jda.client.entities.Group;
import net.dv8tion.jda.client.entities.Relationship;
import net.dv8tion.jda.client.entities.RelationshipType;
import net.dv8tion.jda.client.entities.UserSettings;
import net.dv8tion.jda.client.entities.impl.UserSettingsImpl;
import net.dv8tion.jda.client.requests.restaction.ApplicationAction;
import net.dv8tion.jda.client.requests.restaction.pagination.MentionPaginationAction;
import net.dv8tion.jda.core.JDA;
import net.dv8tion.jda.core.entities.EntityBuilder;
import net.dv8tion.jda.core.entities.Guild;
import net.dv8tion.jda.core.entities.Member;
import net.dv8tion.jda.core.entities.User;
import net.dv8tion.jda.core.entities.impl.JDAImpl;
import net.dv8tion.jda.core.exceptions.GuildUnavailableException;
import net.dv8tion.jda.core.requests.Request;
import net.dv8tion.jda.core.requests.Response;
import net.dv8tion.jda.core.requests.RestAction;
import net.dv8tion.jda.core.requests.Route;
import net.dv8tion.jda.core.utils.Checks;
import net.dv8tion.jda.core.utils.MiscUtil;
import net.dv8tion.jda.core.utils.cache.SnowflakeCacheView;
import net.dv8tion.jda.core.utils.cache.impl.SnowflakeCacheViewImpl;
import org.json.JSONArray;

public class JDAClientImpl
implements JDAClient {
    protected final JDAImpl api;
    protected final SnowflakeCacheViewImpl<Group> groups = new SnowflakeCacheViewImpl<Group>(Group.class, Group::getName);
    protected final TLongObjectMap<Relationship> relationships = MiscUtil.newLongMap();
    protected final TLongObjectMap<CallUser> callUsers = MiscUtil.newLongMap();
    protected UserSettingsImpl userSettings;

    public JDAClientImpl(JDAImpl api) {
        this.api = api;
        this.userSettings = new UserSettingsImpl(api);
    }

    @Override
    public JDA getJDA() {
        return this.api;
    }

    @Override
    public SnowflakeCacheView<Group> getGroupCache() {
        return this.groups;
    }

    @Override
    public List<Relationship> getRelationships() {
        return Collections.unmodifiableList(new ArrayList(this.relationships.valueCollection()));
    }

    @Override
    public List<Relationship> getRelationships(RelationshipType type) {
        return Collections.unmodifiableList(this.relationships.valueCollection().stream().filter(r -> r.getType().equals((Object)type)).collect(Collectors.toList()));
    }

    @Override
    public List<Relationship> getRelationships(RelationshipType type, String name, boolean ignoreCase) {
        return Collections.unmodifiableList(this.relationships.valueCollection().stream().filter(r -> r.getType().equals((Object)type)).filter(r -> ignoreCase ? r.getUser().getName().equalsIgnoreCase(name) : r.getUser().getName().equals(name)).collect(Collectors.toList()));
    }

    @Override
    public List<Relationship> getRelationshipsByName(String name, boolean ignoreCase) {
        return Collections.unmodifiableList(this.relationships.valueCollection().stream().filter(r -> ignoreCase ? r.getUser().getName().equalsIgnoreCase(name) : r.getUser().getName().equals(name)).collect(Collectors.toList()));
    }

    @Override
    public Relationship getRelationship(User user) {
        return this.getRelationshipById(user.getIdLong());
    }

    @Override
    public Relationship getRelationship(Member member) {
        return this.getRelationship(member.getUser());
    }

    @Override
    public Relationship getRelationshipById(String id) {
        return (Relationship)this.relationships.get(MiscUtil.parseSnowflake(id));
    }

    @Override
    public Relationship getRelationshipById(long id) {
        return (Relationship)this.relationships.get(id);
    }

    @Override
    public Relationship getRelationshipById(String id, RelationshipType type) {
        Relationship relationship = this.getRelationshipById(id);
        if (relationship != null && relationship.getType() == type) {
            return relationship;
        }
        return null;
    }

    @Override
    public Relationship getRelationshipById(long id, RelationshipType type) {
        Relationship relationship = this.getRelationshipById(id);
        if (relationship != null && relationship.getType() == type) {
            return relationship;
        }
        return null;
    }

    @Override
    public List<Friend> getFriends() {
        return this.getRelationships(RelationshipType.FRIEND);
    }

    @Override
    public List<Friend> getFriendsByName(String name, boolean ignoreCase) {
        return this.getRelationships(RelationshipType.FRIEND, name, ignoreCase);
    }

    @Override
    public Friend getFriend(User user) {
        return this.getFriendById(user.getIdLong());
    }

    @Override
    public Friend getFriend(Member member) {
        return this.getFriend(member.getUser());
    }

    @Override
    public Friend getFriendById(String id) {
        return (Friend)this.getRelationshipById(id, RelationshipType.FRIEND);
    }

    @Override
    public Friend getFriendById(long id) {
        return (Friend)this.getRelationshipById(id, RelationshipType.FRIEND);
    }

    @Override
    public MentionPaginationAction getRecentMentions() {
        return new MentionPaginationAction(this.getJDA());
    }

    @Override
    public MentionPaginationAction getRecentMentions(Guild guild) {
        Checks.notNull(guild, "Guild");
        if (!guild.isAvailable()) {
            throw new GuildUnavailableException("Cannot retrieve recent mentions for this Guild due to it being temporarily unavailable!");
        }
        return new MentionPaginationAction(guild);
    }

    @Override
    public UserSettings getSettings() {
        return this.userSettings;
    }

    public TLongObjectMap<Group> getGroupMap() {
        return this.groups.getMap();
    }

    public TLongObjectMap<Relationship> getRelationshipMap() {
        return this.relationships;
    }

    public TLongObjectMap<CallUser> getCallUserMap() {
        return this.callUsers;
    }

    @Override
    public ApplicationAction createApplication(String name) {
        return new ApplicationAction(this.api, name);
    }

    @Override
    public RestAction<List<Application>> getApplications() {
        Route.CompiledRoute route = Route.Applications.GET_APPLICATIONS.compile(new String[0]);
        return new RestAction<List<Application>>((JDA)this.api, route){

            @Override
            protected void handleResponse(Response response, Request<List<Application>> request) {
                if (response.isOk()) {
                    JSONArray array = response.getArray();
                    ArrayList<Application> applications = new ArrayList<Application>(array.length());
                    EntityBuilder entityBuilder = this.api.getEntityBuilder();
                    for (int i = 0; i < array.length(); ++i) {
                        applications.add(entityBuilder.createApplication(array.getJSONObject(i)));
                    }
                    request.onSuccess(Collections.unmodifiableList(applications));
                } else {
                    request.onFailure(response);
                }
            }
        };
    }

    @Override
    public RestAction<Application> getApplicationById(String id) {
        Checks.notEmpty(id, "id");
        Route.CompiledRoute route = Route.Applications.GET_APPLICATION.compile(id);
        return new RestAction<Application>((JDA)this.api, route){

            @Override
            protected void handleResponse(Response response, Request<Application> request) {
                if (response.isOk()) {
                    request.onSuccess(this.api.getEntityBuilder().createApplication(response.getObject()));
                } else {
                    request.onFailure(response);
                }
            }
        };
    }

    @Override
    public RestAction<List<AuthorizedApplication>> getAuthorizedApplications() {
        Route.CompiledRoute route = Route.Applications.GET_AUTHORIZED_APPLICATIONS.compile(new String[0]);
        return new RestAction<List<AuthorizedApplication>>((JDA)this.api, route){

            @Override
            protected void handleResponse(Response response, Request<List<AuthorizedApplication>> request) {
                if (response.isOk()) {
                    JSONArray array = response.getArray();
                    ArrayList<AuthorizedApplication> applications = new ArrayList<AuthorizedApplication>(array.length());
                    EntityBuilder entityBuilder = this.api.getEntityBuilder();
                    for (int i = 0; i < array.length(); ++i) {
                        applications.add(entityBuilder.createAuthorizedApplication(array.getJSONObject(i)));
                    }
                    request.onSuccess(Collections.unmodifiableList(applications));
                } else {
                    request.onFailure(response);
                }
            }
        };
    }

    @Override
    public RestAction<AuthorizedApplication> getAuthorizedApplicationById(String id) {
        Checks.notEmpty(id, "id");
        Route.CompiledRoute route = Route.Applications.GET_AUTHORIZED_APPLICATION.compile(id);
        return new RestAction<AuthorizedApplication>((JDA)this.api, route){

            @Override
            protected void handleResponse(Response response, Request<AuthorizedApplication> request) {
                if (response.isOk()) {
                    request.onSuccess(this.api.getEntityBuilder().createAuthorizedApplication(response.getObject()));
                } else {
                    request.onFailure(response);
                }
            }
        };
    }
}

