/*
 * Decompiled with CFR 0.152.
 */
package net.dv8tion.jda.webhook;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import net.dv8tion.jda.core.AccountType;
import net.dv8tion.jda.core.entities.Message;
import net.dv8tion.jda.core.entities.MessageEmbed;
import net.dv8tion.jda.core.utils.Checks;
import net.dv8tion.jda.core.utils.Helpers;
import net.dv8tion.jda.webhook.MessageAttachment;
import net.dv8tion.jda.webhook.WebhookMessage;

public class WebhookMessageBuilder {
    public static final int MAX_FILES = 10;
    protected final StringBuilder content = new StringBuilder();
    protected final List<MessageEmbed> embeds = new LinkedList<MessageEmbed>();
    protected final MessageAttachment[] files = new MessageAttachment[10];
    protected String username;
    protected String avatarUrl;
    protected boolean isTTS;
    private int fileIndex = 0;

    public WebhookMessageBuilder(Message message) {
        if (message != null) {
            this.embeds.addAll(message.getEmbeds());
            this.setContent(message.getContentRaw());
            this.isTTS = message.isTTS();
        }
    }

    public WebhookMessageBuilder() {
    }

    public boolean isEmpty() {
        return this.content.length() == 0 && this.embeds.isEmpty() && this.fileIndex == 0;
    }

    public int getFileAmount() {
        return this.fileIndex;
    }

    public WebhookMessageBuilder reset() {
        this.content.setLength(0);
        this.embeds.clear();
        this.resetFiles();
        this.username = null;
        this.avatarUrl = null;
        this.isTTS = false;
        return this;
    }

    public WebhookMessageBuilder resetFiles() {
        for (int i = 0; i < 10; ++i) {
            this.files[i] = null;
        }
        this.fileIndex = 0;
        return this;
    }

    public WebhookMessageBuilder resetEmbeds() {
        this.embeds.clear();
        return this;
    }

    public WebhookMessageBuilder addEmbeds(MessageEmbed ... embeds) {
        Checks.notNull(embeds, "Embeds");
        for (MessageEmbed embed : embeds) {
            Checks.notNull(embed, "Embed");
            Checks.check(embed.isSendable(AccountType.BOT), "One of the provided embeds is empty or exceeds the maximum character count of %d!", (Object)6000);
            this.embeds.add(embed);
        }
        return this;
    }

    public WebhookMessageBuilder addEmbeds(Collection<MessageEmbed> embeds) {
        Checks.notNull(embeds, "Embeds");
        for (MessageEmbed embed : embeds) {
            Checks.notNull(embed, "Embed");
            Checks.check(embed.isSendable(AccountType.BOT), "One of the provided embeds is empty or exceeds the maximum character count of %d!", (Object)6000);
            this.embeds.add(embed);
        }
        return this;
    }

    public WebhookMessageBuilder setContent(String content) {
        Checks.check(content == null || content.length() <= 2000, "Content may not exceed 2000 characters!");
        if (content != null) {
            this.content.replace(0, content.length(), content);
        } else {
            this.content.setLength(0);
        }
        return this;
    }

    public WebhookMessageBuilder append(String content) {
        Checks.notNull(content, "Content");
        Checks.check(this.content.length() + content.length() <= 2000, "Content may not exceed 2000 characters!");
        this.content.append(content);
        return this;
    }

    public WebhookMessageBuilder setUsername(String username) {
        this.username = Helpers.isBlank(username) ? null : username;
        return this;
    }

    public WebhookMessageBuilder setAvatarUrl(String avatarUrl) {
        this.avatarUrl = Helpers.isBlank(avatarUrl) ? null : avatarUrl;
        return this;
    }

    public WebhookMessageBuilder addFile(File file) {
        Checks.notNull(file, "File");
        return this.addFile(file.getName(), file);
    }

    public WebhookMessageBuilder addFile(String name, File file) {
        Checks.notNull(file, "File");
        Checks.notBlank(name, "Name");
        Checks.check(file.exists() && file.canRead(), "File must exist and be readable");
        if (this.fileIndex >= 10) {
            throw new IllegalStateException("Cannot add more than 10 attachments to a message");
        }
        try {
            MessageAttachment attachment = new MessageAttachment(name, file);
            this.files[this.fileIndex++] = attachment;
            return this;
        }
        catch (IOException ex) {
            throw new IllegalArgumentException(ex);
        }
    }

    public WebhookMessageBuilder addFile(String name, byte[] data) {
        Checks.notNull(data, "Data");
        Checks.notBlank(name, "Name");
        if (this.fileIndex >= 10) {
            throw new IllegalStateException("Cannot add more than 10 attachments to a message");
        }
        MessageAttachment attachment = new MessageAttachment(name, data);
        this.files[this.fileIndex++] = attachment;
        return this;
    }

    public WebhookMessageBuilder addFile(String name, InputStream data) {
        Checks.notNull(data, "InputStream");
        Checks.notBlank(name, "Name");
        if (this.fileIndex >= 10) {
            throw new IllegalStateException("Cannot add more than 10 attachments to a message");
        }
        try {
            MessageAttachment attachment = new MessageAttachment(name, data);
            this.files[this.fileIndex++] = attachment;
            return this;
        }
        catch (IOException ex) {
            throw new IllegalArgumentException(ex);
        }
    }

    @Deprecated
    public WebhookMessageBuilder setFile(File file) {
        return this.addFile(file == null ? null : file.getName(), file);
    }

    @Deprecated
    public WebhookMessageBuilder setFile(File file, String fileName) {
        return this.addFile(fileName, file);
    }

    @Deprecated
    public WebhookMessageBuilder setFile(byte[] data, String fileName) {
        return this.addFile(fileName, data);
    }

    @Deprecated
    public WebhookMessageBuilder setFile(InputStream data, String fileName) {
        return this.addFile(fileName, data);
    }

    public WebhookMessageBuilder setTTS(boolean tts) {
        this.isTTS = tts;
        return this;
    }

    public WebhookMessage build() {
        if (this.isEmpty()) {
            throw new IllegalStateException("Cannot build an empty message!");
        }
        return new WebhookMessage(this.username, this.avatarUrl, this.content.toString(), this.embeds, this.isTTS, this.fileIndex == 0 ? null : Arrays.copyOf(this.files, this.fileIndex));
    }
}

