/*
 * Decompiled with CFR 0.152.
 */
package net.dv8tion.jda.core.requests;

import java.util.concurrent.ExecutionException;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.function.BooleanSupplier;
import java.util.function.Consumer;
import net.dv8tion.jda.core.JDA;
import net.dv8tion.jda.core.entities.impl.JDAImpl;
import net.dv8tion.jda.core.exceptions.ErrorResponseException;
import net.dv8tion.jda.core.exceptions.PermissionException;
import net.dv8tion.jda.core.exceptions.RateLimitedException;
import net.dv8tion.jda.core.requests.Request;
import net.dv8tion.jda.core.requests.RequestFuture;
import net.dv8tion.jda.core.requests.Requester;
import net.dv8tion.jda.core.requests.Response;
import net.dv8tion.jda.core.requests.RestFuture;
import net.dv8tion.jda.core.requests.Route;
import net.dv8tion.jda.core.utils.Checks;
import net.dv8tion.jda.core.utils.JDALogger;
import okhttp3.MediaType;
import okhttp3.RequestBody;
import org.apache.commons.collections4.map.CaseInsensitiveMap;
import org.json.JSONArray;
import org.json.JSONObject;
import org.slf4j.Logger;

public abstract class RestAction<T> {
    public static final Logger LOG = JDALogger.getLog(RestAction.class);
    public static Consumer DEFAULT_SUCCESS = o -> {};
    public static Consumer<Throwable> DEFAULT_FAILURE = t -> {
        if (LOG.isDebugEnabled()) {
            LOG.error("RestAction queue returned failure", t);
        } else {
            LOG.error("RestAction queue returned failure: [{}] {}", (Object)t.getClass().getSimpleName(), (Object)t.getMessage());
        }
    };
    private static final Consumer FALLBACK_CONSUMER = o -> {};
    protected static boolean passContext = false;
    protected final JDAImpl api;
    private final Route.CompiledRoute route;
    private final RequestBody data;
    private Object rawData;
    private BooleanSupplier checks;

    public static void setPassContext(boolean enable) {
        passContext = enable;
    }

    public static boolean isPassContext() {
        return passContext;
    }

    public RestAction(JDA api, Route.CompiledRoute route) {
        this(api, route, (RequestBody)null);
    }

    public RestAction(JDA api, Route.CompiledRoute route, RequestBody data) {
        Checks.notNull(api, "api");
        this.api = (JDAImpl)api;
        this.route = route;
        this.data = data;
    }

    public RestAction(JDA api, Route.CompiledRoute route, JSONObject data) {
        this(api, route, data == null ? null : RequestBody.create((MediaType)Requester.MEDIA_TYPE_JSON, (String)data.toString()));
        this.rawData = data;
    }

    public JDA getJDA() {
        return this.api;
    }

    public RestAction<T> setCheck(BooleanSupplier checks) {
        this.checks = checks;
        return this;
    }

    public void queue() {
        this.queue(null, null);
    }

    public void queue(Consumer<? super T> success) {
        this.queue(success, null);
    }

    public void queue(Consumer<? super T> success, Consumer<? super Throwable> failure) {
        Route.CompiledRoute route = this.finalizeRoute();
        Checks.notNull(route, "Route");
        RequestBody data = this.finalizeData();
        CaseInsensitiveMap<String, String> headers = this.finalizeHeaders();
        CheckWrapper finisher = this.getFinisher();
        if (success == null) {
            Consumer consumer = success = DEFAULT_SUCCESS == null ? FALLBACK_CONSUMER : DEFAULT_SUCCESS;
        }
        if (failure == null) {
            failure = DEFAULT_FAILURE == null ? FALLBACK_CONSUMER : DEFAULT_FAILURE;
        }
        this.api.getRequester().request(new Request(this, success, failure, finisher, true, data, this.rawData, route, headers));
    }

    public RequestFuture<T> submit() {
        return this.submit(true);
    }

    public RequestFuture<T> submit(boolean shouldQueue) {
        Route.CompiledRoute route = this.finalizeRoute();
        Checks.notNull(route, "Route");
        RequestBody data = this.finalizeData();
        CaseInsensitiveMap<String, String> headers = this.finalizeHeaders();
        CheckWrapper finisher = this.getFinisher();
        return new RestFuture(this, shouldQueue, finisher, data, this.rawData, route, headers);
    }

    public T complete() {
        try {
            return this.complete(true);
        }
        catch (RateLimitedException e) {
            throw new AssertionError((Object)e);
        }
    }

    public T complete(boolean shouldQueue) throws RateLimitedException {
        try {
            return (T)this.submit(shouldQueue).get();
        }
        catch (Throwable e) {
            if (e instanceof ExecutionException) {
                Throwable t = e.getCause();
                if (t instanceof RateLimitedException) {
                    throw (RateLimitedException)t;
                }
                if (t instanceof PermissionException) {
                    throw (PermissionException)t;
                }
                if (t instanceof ErrorResponseException) {
                    throw (ErrorResponseException)t;
                }
            }
            throw new RuntimeException(e);
        }
    }

    public ScheduledFuture<T> submitAfter(long delay, TimeUnit unit) {
        return this.submitAfter(delay, unit, this.api.pool);
    }

    public ScheduledFuture<T> submitAfter(long delay, TimeUnit unit, ScheduledExecutorService executor) {
        Checks.notNull(executor, "Scheduler");
        Checks.notNull((Object)unit, "TimeUnit");
        return executor.schedule(this::complete, delay, unit);
    }

    public T completeAfter(long delay, TimeUnit unit) {
        Checks.notNull((Object)unit, "TimeUnit");
        try {
            unit.sleep(delay);
            return this.complete();
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
    }

    public ScheduledFuture<?> queueAfter(long delay, TimeUnit unit) {
        return this.queueAfter(delay, unit, this.api.pool);
    }

    public ScheduledFuture<?> queueAfter(long delay, TimeUnit unit, Consumer<? super T> success) {
        return this.queueAfter(delay, unit, success, this.api.pool);
    }

    public ScheduledFuture<?> queueAfter(long delay, TimeUnit unit, Consumer<? super T> success, Consumer<? super Throwable> failure) {
        return this.queueAfter(delay, unit, success, failure, this.api.pool);
    }

    public ScheduledFuture<?> queueAfter(long delay, TimeUnit unit, ScheduledExecutorService executor) {
        return this.queueAfter(delay, unit, null, executor);
    }

    public ScheduledFuture<?> queueAfter(long delay, TimeUnit unit, Consumer<? super T> success, ScheduledExecutorService executor) {
        return this.queueAfter(delay, unit, success, null, executor);
    }

    public ScheduledFuture<?> queueAfter(long delay, TimeUnit unit, Consumer<? super T> success, Consumer<? super Throwable> failure, ScheduledExecutorService executor) {
        Checks.notNull(executor, "Scheduler");
        Checks.notNull((Object)unit, "TimeUnit");
        return executor.schedule(() -> this.queue(success, failure), delay, unit);
    }

    protected RequestBody finalizeData() {
        return this.data;
    }

    protected Route.CompiledRoute finalizeRoute() {
        return this.route;
    }

    protected CaseInsensitiveMap<String, String> finalizeHeaders() {
        return null;
    }

    protected BooleanSupplier finalizeChecks() {
        return null;
    }

    protected RequestBody getRequestBody(JSONObject object) {
        this.rawData = object;
        return object == null ? null : RequestBody.create((MediaType)Requester.MEDIA_TYPE_JSON, (String)object.toString());
    }

    protected RequestBody getRequestBody(JSONArray array) {
        this.rawData = array;
        return array == null ? null : RequestBody.create((MediaType)Requester.MEDIA_TYPE_JSON, (String)array.toString());
    }

    private CheckWrapper getFinisher() {
        BooleanSupplier pre = this.finalizeChecks();
        BooleanSupplier wrapped = this.checks;
        return pre != null || wrapped != null ? new CheckWrapper(wrapped, pre) : CheckWrapper.EMPTY;
    }

    protected abstract void handleResponse(Response var1, Request<T> var2);

    protected static class CheckWrapper
    implements BooleanSupplier {
        public static final CheckWrapper EMPTY = new CheckWrapper(null, null){

            @Override
            public boolean getAsBoolean() {
                return true;
            }
        };
        protected final BooleanSupplier pre;
        protected final BooleanSupplier wrapped;

        public CheckWrapper(BooleanSupplier wrapped, BooleanSupplier pre) {
            this.pre = pre;
            this.wrapped = wrapped;
        }

        public boolean pre() {
            return this.pre == null || this.pre.getAsBoolean();
        }

        public boolean test() {
            return this.wrapped == null || this.wrapped.getAsBoolean();
        }

        @Override
        public boolean getAsBoolean() {
            return this.pre() && this.test();
        }
    }

    public static class EmptyRestAction<T>
    extends RestAction<T> {
        private final T returnObj;

        public EmptyRestAction(JDA api, T returnObj) {
            super(api, null);
            this.returnObj = returnObj;
        }

        @Override
        public void queue(Consumer<? super T> success, Consumer<? super Throwable> failure) {
            if (success != null) {
                success.accept(this.returnObj);
            }
        }

        @Override
        public RequestFuture<T> submit(boolean shouldQueue) {
            return new RestFuture<T>(this.returnObj);
        }

        @Override
        public T complete(boolean shouldQueue) {
            return this.returnObj;
        }

        @Override
        protected void handleResponse(Response response, Request<T> request) {
        }
    }
}

