/*
 * Decompiled with CFR 0.152.
 */
package net.dv8tion.jda.core.managers;

import javax.annotation.CheckReturnValue;
import net.dv8tion.jda.core.JDA;
import net.dv8tion.jda.core.Permission;
import net.dv8tion.jda.core.entities.Category;
import net.dv8tion.jda.core.entities.Channel;
import net.dv8tion.jda.core.entities.ChannelType;
import net.dv8tion.jda.core.entities.Guild;
import net.dv8tion.jda.core.entities.TextChannel;
import net.dv8tion.jda.core.entities.VoiceChannel;
import net.dv8tion.jda.core.exceptions.InsufficientPermissionException;
import net.dv8tion.jda.core.managers.fields.ChannelField;
import net.dv8tion.jda.core.requests.Request;
import net.dv8tion.jda.core.requests.Response;
import net.dv8tion.jda.core.requests.Route;
import net.dv8tion.jda.core.requests.restaction.AuditableRestAction;
import net.dv8tion.jda.core.utils.Checks;
import org.json.JSONObject;

public class ChannelManagerUpdatable {
    protected final Channel channel;
    protected ChannelField<String> name;
    protected ChannelField<String> topic;
    protected ChannelField<Integer> userLimit;
    protected ChannelField<Integer> bitrate;
    protected ChannelField<Boolean> nsfw;
    protected ChannelField<Category> parent;
    protected ChannelField<Integer> position;

    public ChannelManagerUpdatable(Channel channel) {
        this.channel = channel;
        this.setupFields();
    }

    public JDA getJDA() {
        return this.channel.getJDA();
    }

    public Channel getChannel() {
        return this.channel;
    }

    public Guild getGuild() {
        return this.channel.getGuild();
    }

    public ChannelField<String> getNameField() {
        return this.name;
    }

    public ChannelField<Category> getParentField() {
        if (this.channel instanceof Category) {
            throw new UnsupportedOperationException("Setting the parent is not allowed on categories!");
        }
        return this.parent;
    }

    public ChannelField<String> getTopicField() {
        if (this.channel.getType() != ChannelType.TEXT) {
            throw new UnsupportedOperationException("Setting a Topic is only allowed on TextChannels!");
        }
        return this.topic;
    }

    public ChannelField<Integer> getUserLimitField() {
        if (this.channel.getType() != ChannelType.VOICE) {
            throw new UnsupportedOperationException("Setting user limit is only allowed on VoiceChannels!");
        }
        return this.userLimit;
    }

    public ChannelField<Boolean> getNSFWField() {
        if (this.channel.getType() != ChannelType.TEXT) {
            throw new UnsupportedOperationException("Setting the nsfw flag is only allowed on TextChannels!");
        }
        return this.nsfw;
    }

    public ChannelField<Integer> getBitrateField() {
        if (this.channel.getType() != ChannelType.VOICE) {
            throw new UnsupportedOperationException("Setting user limit is only allowed on VoiceChannels!");
        }
        return this.bitrate;
    }

    public ChannelField<Integer> getPositionField() {
        if (!this.getGuild().getSelfMember().hasPermission(Permission.MANAGE_CHANNEL)) {
            throw new InsufficientPermissionException(Permission.MANAGE_CHANNEL);
        }
        return this.position;
    }

    public void reset() {
        this.name.reset();
        if (this.channel instanceof TextChannel) {
            this.parent.reset();
            this.topic.reset();
        } else if (this.channel instanceof VoiceChannel) {
            this.parent.reset();
            this.bitrate.reset();
            this.userLimit.reset();
        }
    }

    @CheckReturnValue
    public AuditableRestAction<Void> update() {
        this.checkPermission(Permission.MANAGE_CHANNEL);
        if (!this.needToUpdate()) {
            return new AuditableRestAction.EmptyRestAction<Object>(this.getJDA(), null);
        }
        JSONObject frame = new JSONObject().put("name", (Object)this.channel.getName());
        if (this.name.shouldUpdate()) {
            frame.put("name", this.name.getValue());
        }
        if (this.position.shouldUpdate()) {
            frame.put("position", this.position.getValue());
        }
        if (this.topic != null && this.topic.shouldUpdate()) {
            frame.put("topic", this.topic.getValue() == null ? JSONObject.NULL : this.topic.getValue());
        }
        if (this.nsfw != null && this.nsfw.shouldUpdate()) {
            frame.put("nsfw", this.nsfw.getValue());
        }
        if (this.userLimit != null && this.userLimit.shouldUpdate()) {
            frame.put("user_limit", this.userLimit.getValue());
        }
        if (this.bitrate != null && this.bitrate.shouldUpdate()) {
            frame.put("bitrate", this.bitrate.getValue());
        }
        if (this.parent != null && this.parent.shouldUpdate()) {
            frame.put("parent_id", this.parent.getValue() == null ? JSONObject.NULL : Long.valueOf(((Category)this.parent.getValue()).getIdLong()));
        }
        this.reset();
        Route.CompiledRoute route = Route.Channels.MODIFY_CHANNEL.compile(this.channel.getId());
        return new AuditableRestAction<Void>(this.channel.getJDA(), route, frame){

            @Override
            protected void handleResponse(Response response, Request<Void> request) {
                if (response.isOk()) {
                    request.onSuccess(null);
                } else {
                    request.onFailure(response);
                }
            }
        };
    }

    protected boolean needToUpdate() {
        return this.name.shouldUpdate() || this.position.shouldUpdate() || this.parent != null && this.parent.shouldUpdate() || this.topic != null && this.topic.shouldUpdate() || this.userLimit != null && this.userLimit.shouldUpdate() || this.bitrate != null && this.bitrate.shouldUpdate() || this.nsfw != null && this.nsfw.shouldUpdate();
    }

    protected void checkPermission(Permission perm) {
        if (!this.getGuild().getSelfMember().hasPermission(this.channel, perm)) {
            throw new InsufficientPermissionException(perm);
        }
    }

    protected void setupFields() {
        this.name = new ChannelField<String>(this, this.channel::getName){

            @Override
            public void checkValue(String value) {
                Checks.notEmpty(value, "name");
                if (value.length() < 2 || value.length() > 100) {
                    throw new IllegalArgumentException("Provided channel name must be 2 to 100 characters in length");
                }
            }
        };
        this.position = new ChannelField<Integer>(this, this.channel::getPositionRaw){

            @Override
            public void checkValue(Integer value) {
                Checks.notNull(value, "Position");
            }
        };
        if (!(this.channel instanceof Category)) {
            this.parent = new ChannelField<Category>(this, this.channel::getParent){

                @Override
                public void checkValue(Category value) {
                    if (value != null) {
                        Checks.check(value.getGuild().equals(ChannelManagerUpdatable.this.getGuild()), "Category is not from same Guild!");
                    }
                }
            };
        }
        if (this.channel instanceof TextChannel) {
            TextChannel tc = (TextChannel)this.channel;
            this.topic = new ChannelField<String>(this, tc::getTopic){

                @Override
                public void checkValue(String value) {
                    if (value != null && value.length() > 1024) {
                        throw new IllegalArgumentException("Provided topic must less than or equal to 1024 characters in length");
                    }
                }
            };
            this.nsfw = new ChannelField<Boolean>(this, tc::isNSFW){

                @Override
                public void checkValue(Boolean value) {
                    if (value == null) {
                        throw new IllegalArgumentException("NSFW flag must not be null");
                    }
                }
            };
        } else if (this.channel instanceof VoiceChannel) {
            VoiceChannel vc = (VoiceChannel)this.channel;
            this.userLimit = new ChannelField<Integer>(this, vc::getUserLimit){

                @Override
                public void checkValue(Integer value) {
                    Checks.notNull(value, "user limit");
                    if (value < 0 || value > 99) {
                        throw new IllegalArgumentException("Provided user limit must be 0 to 99.");
                    }
                }
            };
            this.bitrate = new ChannelField<Integer>(this, vc::getBitrate){

                @Override
                public void checkValue(Integer value) {
                    Checks.notNull(value, "bitrate");
                    if (value < 8000 || value > (ChannelManagerUpdatable.this.getGuild().getFeatures().contains("VIP_REGIONS") ? 128000 : 96000)) {
                        throw new IllegalArgumentException("Provided bitrate must be 8000 to 96000 (128000 for VIP Guilds)");
                    }
                }
            };
        }
    }
}

