/*
 * Decompiled with CFR 0.152.
 */
package net.dv8tion.jda.core.handle;

import gnu.trove.TDecorators;
import gnu.trove.list.TLongList;
import gnu.trove.list.linked.TLongLinkedList;
import gnu.trove.map.TLongObjectMap;
import gnu.trove.set.TLongSet;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import net.dv8tion.jda.client.entities.impl.GroupImpl;
import net.dv8tion.jda.client.events.group.update.GroupUpdateIconEvent;
import net.dv8tion.jda.client.events.group.update.GroupUpdateNameEvent;
import net.dv8tion.jda.client.events.group.update.GroupUpdateOwnerEvent;
import net.dv8tion.jda.core.entities.Category;
import net.dv8tion.jda.core.entities.ChannelType;
import net.dv8tion.jda.core.entities.Guild;
import net.dv8tion.jda.core.entities.IPermissionHolder;
import net.dv8tion.jda.core.entities.Member;
import net.dv8tion.jda.core.entities.PermissionOverride;
import net.dv8tion.jda.core.entities.Role;
import net.dv8tion.jda.core.entities.User;
import net.dv8tion.jda.core.entities.impl.AbstractChannelImpl;
import net.dv8tion.jda.core.entities.impl.CategoryImpl;
import net.dv8tion.jda.core.entities.impl.JDAImpl;
import net.dv8tion.jda.core.entities.impl.PermissionOverrideImpl;
import net.dv8tion.jda.core.entities.impl.TextChannelImpl;
import net.dv8tion.jda.core.entities.impl.VoiceChannelImpl;
import net.dv8tion.jda.core.events.channel.category.update.CategoryUpdateNameEvent;
import net.dv8tion.jda.core.events.channel.category.update.CategoryUpdatePermissionsEvent;
import net.dv8tion.jda.core.events.channel.category.update.CategoryUpdatePositionEvent;
import net.dv8tion.jda.core.events.channel.text.update.TextChannelUpdateNSFWEvent;
import net.dv8tion.jda.core.events.channel.text.update.TextChannelUpdateNameEvent;
import net.dv8tion.jda.core.events.channel.text.update.TextChannelUpdateParentEvent;
import net.dv8tion.jda.core.events.channel.text.update.TextChannelUpdatePermissionsEvent;
import net.dv8tion.jda.core.events.channel.text.update.TextChannelUpdatePositionEvent;
import net.dv8tion.jda.core.events.channel.text.update.TextChannelUpdateTopicEvent;
import net.dv8tion.jda.core.events.channel.voice.update.VoiceChannelUpdateBitrateEvent;
import net.dv8tion.jda.core.events.channel.voice.update.VoiceChannelUpdateNameEvent;
import net.dv8tion.jda.core.events.channel.voice.update.VoiceChannelUpdateParentEvent;
import net.dv8tion.jda.core.events.channel.voice.update.VoiceChannelUpdatePermissionsEvent;
import net.dv8tion.jda.core.events.channel.voice.update.VoiceChannelUpdatePositionEvent;
import net.dv8tion.jda.core.events.channel.voice.update.VoiceChannelUpdateUserLimitEvent;
import net.dv8tion.jda.core.handle.EventCache;
import net.dv8tion.jda.core.handle.SocketHandler;
import net.dv8tion.jda.core.utils.Helpers;
import org.json.JSONArray;
import org.json.JSONObject;

public class ChannelUpdateHandler
extends SocketHandler {
    public ChannelUpdateHandler(JDAImpl api) {
        super(api);
    }

    @Override
    protected Long handleInternally(JSONObject content) {
        ChannelType type = ChannelType.fromId(content.getInt("type"));
        if (type == ChannelType.GROUP) {
            this.handleGroup(content);
            return null;
        }
        ArrayList<IPermissionHolder> changed = new ArrayList<IPermissionHolder>();
        ArrayList<IPermissionHolder> contained = new ArrayList<IPermissionHolder>();
        long channelId = content.getLong("id");
        Long parentId = content.isNull("parent_id") ? null : Long.valueOf(content.getLong("parent_id"));
        int position = content.getInt("position");
        String name = content.getString("name");
        boolean nsfw = Helpers.optBoolean(content, "nsfw");
        JSONArray permOverwrites = content.getJSONArray("permission_overwrites");
        switch (type) {
            case TEXT: {
                String topic = content.optString("topic", null);
                TextChannelImpl textChannel = (TextChannelImpl)this.api.getTextChannelMap().get(channelId);
                if (textChannel == null) {
                    this.api.getEventCache().cache(EventCache.Type.CHANNEL, channelId, () -> this.handle(this.responseNumber, this.allContent));
                    EventCache.LOG.debug("CHANNEL_UPDATE attempted to update a TextChannel that does not exist. JSON: {}", (Object)content);
                    return null;
                }
                Category parent = textChannel.getParent();
                Long oldParent = parent == null ? null : Long.valueOf(parent.getIdLong());
                String oldName = textChannel.getName();
                String oldTopic = textChannel.getTopic();
                int oldPosition = textChannel.getPositionRaw();
                boolean oldNsfw = textChannel.isNSFW();
                if (!Objects.equals(oldName, name)) {
                    textChannel.setName(name);
                    this.api.getEventManager().handle(new TextChannelUpdateNameEvent(this.api, this.responseNumber, textChannel, oldName));
                }
                if (!Objects.equals(oldParent, parentId)) {
                    textChannel.setParent(parentId == null ? 0L : parentId);
                    this.api.getEventManager().handle(new TextChannelUpdateParentEvent(this.api, this.responseNumber, textChannel, parent));
                }
                if (!Objects.equals(oldTopic, topic)) {
                    textChannel.setTopic(topic);
                    this.api.getEventManager().handle(new TextChannelUpdateTopicEvent(this.api, this.responseNumber, textChannel, oldTopic));
                }
                if (oldPosition != position) {
                    textChannel.setRawPosition(position);
                    this.api.getEventManager().handle(new TextChannelUpdatePositionEvent(this.api, this.responseNumber, textChannel, oldPosition));
                }
                if (oldNsfw != nsfw) {
                    textChannel.setNSFW(nsfw);
                    this.api.getEventManager().handle(new TextChannelUpdateNSFWEvent(this.api, this.responseNumber, textChannel, nsfw));
                }
                this.applyPermissions(textChannel, content, permOverwrites, contained, changed);
                if (changed.isEmpty()) break;
                this.api.getEventManager().handle(new TextChannelUpdatePermissionsEvent(this.api, this.responseNumber, textChannel, changed));
                break;
            }
            case VOICE: {
                VoiceChannelImpl voiceChannel = (VoiceChannelImpl)this.api.getVoiceChannelMap().get(channelId);
                int userLimit = content.getInt("user_limit");
                int bitrate = content.getInt("bitrate");
                if (voiceChannel == null) {
                    this.api.getEventCache().cache(EventCache.Type.CHANNEL, channelId, () -> this.handle(this.responseNumber, this.allContent));
                    EventCache.LOG.debug("CHANNEL_UPDATE attempted to update a VoiceChannel that does not exist. JSON: {}", (Object)content);
                    return null;
                }
                Category parent = voiceChannel.getParent();
                Long oldParent = parent == null ? null : Long.valueOf(parent.getIdLong());
                String oldName = voiceChannel.getName();
                int oldPosition = voiceChannel.getPositionRaw();
                int oldLimit = voiceChannel.getUserLimit();
                int oldBitrate = voiceChannel.getBitrate();
                if (!Objects.equals(oldName, name)) {
                    voiceChannel.setName(name);
                    this.api.getEventManager().handle(new VoiceChannelUpdateNameEvent(this.api, this.responseNumber, voiceChannel, oldName));
                }
                if (!Objects.equals(oldParent, parentId)) {
                    voiceChannel.setParent(parentId == null ? 0L : parentId);
                    this.api.getEventManager().handle(new VoiceChannelUpdateParentEvent(this.api, this.responseNumber, voiceChannel, parent));
                }
                if (oldPosition != position) {
                    voiceChannel.setRawPosition(position);
                    this.api.getEventManager().handle(new VoiceChannelUpdatePositionEvent(this.api, this.responseNumber, voiceChannel, oldPosition));
                }
                if (oldLimit != userLimit) {
                    voiceChannel.setUserLimit(userLimit);
                    this.api.getEventManager().handle(new VoiceChannelUpdateUserLimitEvent(this.api, this.responseNumber, voiceChannel, oldLimit));
                }
                if (oldBitrate != bitrate) {
                    voiceChannel.setBitrate(bitrate);
                    this.api.getEventManager().handle(new VoiceChannelUpdateBitrateEvent(this.api, this.responseNumber, voiceChannel, oldBitrate));
                }
                this.applyPermissions(voiceChannel, content, permOverwrites, contained, changed);
                if (changed.isEmpty()) break;
                this.api.getEventManager().handle(new VoiceChannelUpdatePermissionsEvent(this.api, this.responseNumber, voiceChannel, changed));
                break;
            }
            case CATEGORY: {
                CategoryImpl category = (CategoryImpl)this.api.getCategoryById(channelId);
                if (category == null) {
                    this.api.getEventCache().cache(EventCache.Type.CHANNEL, channelId, () -> this.handle(this.responseNumber, this.allContent));
                    EventCache.LOG.debug("CHANNEL_UPDATE attempted to update a Category that does not exist. JSON: {}", (Object)content);
                    return null;
                }
                String oldName = category.getName();
                int oldPosition = category.getPositionRaw();
                if (!Objects.equals(oldName, name)) {
                    category.setName(name);
                    this.api.getEventManager().handle(new CategoryUpdateNameEvent(this.api, this.responseNumber, category, oldName));
                }
                if (!Objects.equals(oldPosition, position)) {
                    category.setRawPosition(position);
                    this.api.getEventManager().handle(new CategoryUpdatePositionEvent(this.api, this.responseNumber, category, oldPosition));
                }
                this.applyPermissions(category, content, permOverwrites, contained, changed);
                if (changed.isEmpty()) break;
                this.api.getEventManager().handle(new CategoryUpdatePermissionsEvent(this.api, this.responseNumber, category, changed));
                break;
            }
            default: {
                throw new IllegalArgumentException("CHANNEL_UPDATE provided an unrecognized channel type JSON: " + content);
            }
        }
        return null;
    }

    private long getIdLong(IPermissionHolder permHolder) {
        if (permHolder instanceof Member) {
            return ((Member)permHolder).getUser().getIdLong();
        }
        return ((Role)permHolder).getIdLong();
    }

    private void applyPermissions(AbstractChannelImpl<?> channel, JSONObject content, JSONArray permOverwrites, List<IPermissionHolder> contained, List<IPermissionHolder> changed) {
        for (int i = 0; i < permOverwrites.length(); ++i) {
            this.handlePermissionOverride(permOverwrites.getJSONObject(i), channel, content, changed, contained);
        }
        TLongLinkedList toRemove = new TLongLinkedList();
        TLongObjectMap<PermissionOverride> overridesMap = channel.getOverrideMap();
        TDecorators.wrap((TLongSet)overridesMap.keySet()).stream().map(id -> this.mapPermissionHolder((long)id, channel.getGuild())).filter(Objects::nonNull).filter(permHolder -> !contained.contains(permHolder)).forEach(arg_0 -> this.lambda$applyPermissions$5(changed, (TLongList)toRemove, arg_0));
        toRemove.forEach(id -> {
            overridesMap.remove(id);
            return true;
        });
    }

    private IPermissionHolder mapPermissionHolder(long id, Guild guild) {
        Role holder = guild.getRoleById(id);
        return holder == null ? guild.getMemberById(id) : holder;
    }

    private void handlePermissionOverride(JSONObject override, AbstractChannelImpl<?> channel, JSONObject content, List<IPermissionHolder> changedPermHolders, List<IPermissionHolder> containedPermHolders) {
        PermissionOverrideImpl permOverride;
        IPermissionHolder permHolder;
        long id = override.getLong("id");
        long allow = override.getLong("allow");
        long deny = override.getLong("deny");
        switch (override.getString("type")) {
            case "role": {
                permHolder = channel.getGuild().getRoleById(id);
                if (permHolder != null) break;
                this.api.getEventCache().cache(EventCache.Type.ROLE, id, () -> this.handlePermissionOverride(override, channel, content, changedPermHolders, containedPermHolders));
                EventCache.LOG.debug("CHANNEL_UPDATE attempted to create or update a PermissionOverride for a Role that doesn't exist! RoleId: {} JSON: {}", (Object)id, (Object)content);
                return;
            }
            case "member": {
                permHolder = channel.getGuild().getMemberById(id);
                if (permHolder != null) break;
                this.api.getEventCache().cache(EventCache.Type.USER, id, () -> this.handlePermissionOverride(override, channel, content, changedPermHolders, containedPermHolders));
                EventCache.LOG.debug("CHANNEL_UPDATE attempted to create or update a PermissionOverride for Member that doesn't exist in this Guild! MemberId: {} JSON: {}", (Object)id, (Object)content);
                return;
            }
            default: {
                throw new IllegalArgumentException("CHANNEL_UPDATE provided an unrecognized PermissionOverride type. JSON: " + content);
            }
        }
        if ((permOverride = (PermissionOverrideImpl)channel.getOverrideMap().get(id)) == null) {
            this.api.getEntityBuilder().createPermissionOverride(override, channel);
            changedPermHolders.add(permHolder);
        } else if (permOverride.getAllowedRaw() != allow || permOverride.getDeniedRaw() != deny) {
            permOverride.setAllow(allow);
            permOverride.setDeny(deny);
            changedPermHolders.add(permHolder);
        }
        containedPermHolders.add(permHolder);
    }

    private void handleGroup(JSONObject content) {
        long groupId = content.getLong("id");
        long ownerId = content.getLong("owner_id");
        String name = content.optString("name", null);
        String iconId = content.optString("icon", null);
        GroupImpl group = (GroupImpl)this.api.asClient().getGroupById(groupId);
        if (group == null) {
            this.api.getEventCache().cache(EventCache.Type.CHANNEL, groupId, () -> this.handle(this.responseNumber, this.allContent));
            EventCache.LOG.debug("Received CHANNEL_UPDATE for a group that was not yet cached. JSON: {}", (Object)content);
            return;
        }
        User owner = (User)group.getUserMap().get(ownerId);
        User oldOwner = group.getOwner();
        String oldName = group.getName();
        String oldIconId = group.getIconId();
        if (owner == null) {
            EventCache.LOG.warn("Received CHANNEL_UPDATE for a group with an owner_id for a user that is not cached. owner_id: {}", (Object)ownerId);
        } else if (!Objects.equals(owner, oldOwner)) {
            group.setOwner(owner);
            this.api.getEventManager().handle(new GroupUpdateOwnerEvent(this.api, this.responseNumber, group, oldOwner));
        }
        if (!Objects.equals(name, oldName)) {
            group.setName(name);
            this.api.getEventManager().handle(new GroupUpdateNameEvent(this.api, this.responseNumber, group, oldName));
        }
        if (!Objects.equals(iconId, oldIconId)) {
            group.setIconId(iconId);
            this.api.getEventManager().handle(new GroupUpdateIconEvent(this.api, this.responseNumber, group, oldIconId));
        }
    }

    private /* synthetic */ void lambda$applyPermissions$5(List changed, TLongList toRemove, IPermissionHolder permHolder) {
        changed.add(permHolder);
        toRemove.add(this.getIdLong(permHolder));
    }
}

