/*
 * Decompiled with CFR 0.152.
 */
package net.dv8tion.jda.webhook;

import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.dv8tion.jda.core.entities.Webhook;
import net.dv8tion.jda.core.utils.Checks;
import net.dv8tion.jda.webhook.WebhookClient;
import okhttp3.OkHttpClient;

public class WebhookClientBuilder {
    public static final OkHttpClient.Builder DEFAULT_HTTP_BUILDER = new OkHttpClient.Builder();
    protected final long id;
    protected final String token;
    protected ScheduledExecutorService pool;
    protected OkHttpClient.Builder builder;
    protected OkHttpClient client;
    protected ThreadFactory threadFactory;
    protected boolean isDaemon;

    public WebhookClientBuilder(long id, String token) {
        Checks.noWhitespace(token, "Token");
        this.id = id;
        this.token = token;
    }

    public WebhookClientBuilder(@Nonnull Webhook webhook) {
        this(webhook.getIdLong(), webhook.getToken());
    }

    public WebhookClientBuilder setExecutorService(@Nullable ScheduledExecutorService executorService) {
        this.pool = executorService;
        return this;
    }

    public WebhookClientBuilder setHttpClient(@Nullable OkHttpClient client) {
        this.client = client;
        return this;
    }

    public WebhookClientBuilder setHttpClientBuilder(@Nullable OkHttpClient.Builder builder) {
        Checks.notNull(builder, "Builder");
        this.builder = builder;
        return this;
    }

    public WebhookClientBuilder setThreadFactory(@Nullable ThreadFactory factory) {
        this.threadFactory = factory;
        return this;
    }

    public WebhookClientBuilder setDaemon(boolean isDaemon) {
        this.isDaemon = isDaemon;
        return this;
    }

    public WebhookClient build() {
        OkHttpClient client = this.client;
        if (client == null) {
            if (this.builder == null) {
                this.builder = DEFAULT_HTTP_BUILDER;
            }
            client = this.builder.build();
        }
        if (this.pool == null) {
            if (this.threadFactory == null) {
                this.threadFactory = new DefaultWebhookThreadFactory();
            }
            this.pool = Executors.newSingleThreadScheduledExecutor(this.threadFactory);
        }
        return new WebhookClient(this.id, this.token, client, this.pool);
    }

    public final class DefaultWebhookThreadFactory
    implements ThreadFactory {
        @Override
        public Thread newThread(Runnable r) {
            Thread thread = new Thread(r, "Webhook-RateLimit Thread WebhookID: " + WebhookClientBuilder.this.id);
            thread.setDaemon(WebhookClientBuilder.this.isDaemon);
            return thread;
        }
    }
}

