/*
 * Decompiled with CFR 0.152.
 */
package net.dv8tion.jda.webhook;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.time.Instant;
import java.time.OffsetDateTime;
import java.time.format.DateTimeFormatter;
import java.time.temporal.ChronoUnit;
import java.util.Collection;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import net.dv8tion.jda.core.JDAInfo;
import net.dv8tion.jda.core.entities.Message;
import net.dv8tion.jda.core.entities.MessageEmbed;
import net.dv8tion.jda.core.exceptions.HttpException;
import net.dv8tion.jda.core.requests.RequestFuture;
import net.dv8tion.jda.core.requests.Requester;
import net.dv8tion.jda.core.utils.Checks;
import net.dv8tion.jda.core.utils.IOUtil;
import net.dv8tion.jda.core.utils.Promise;
import net.dv8tion.jda.core.utils.SimpleLog;
import net.dv8tion.jda.core.utils.tuple.ImmutablePair;
import net.dv8tion.jda.core.utils.tuple.Pair;
import net.dv8tion.jda.webhook.WebhookMessage;
import net.dv8tion.jda.webhook.WebhookMessageBuilder;
import okhttp3.MediaType;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import org.json.JSONObject;
import org.json.JSONTokener;

public class WebhookClient
implements AutoCloseable {
    public static final String WEBHOOK_URL = "https://discordapp.com/api/v6/webhooks/%s/%s";
    public static final String USER_AGENT = "JDA Webhook(https://github.com/DV8FromTheWorld/JDA | " + JDAInfo.VERSION + ")";
    public static final SimpleLog LOG = SimpleLog.getLog(WebhookClient.class);
    protected final String url;
    protected final long id;
    protected final OkHttpClient client;
    protected final ScheduledExecutorService pool;
    protected final Bucket bucket;
    protected final BlockingQueue<Pair<RequestBody, CompletableFuture<?>>> queue;
    protected volatile boolean isQueued;
    protected boolean isShutdown;

    protected WebhookClient(long id, String token, OkHttpClient client, ScheduledExecutorService pool) {
        this.client = client;
        this.id = id;
        this.url = String.format(WEBHOOK_URL, Long.toUnsignedString(id), token);
        this.pool = pool;
        this.bucket = new Bucket();
        this.queue = new LinkedBlockingQueue();
        this.isQueued = false;
    }

    public long getIdLong() {
        return this.id;
    }

    public String getId() {
        return Long.toUnsignedString(this.id);
    }

    public String getUrl() {
        return this.url;
    }

    public RequestFuture<?> send(WebhookMessage message) {
        Checks.notNull(message, "WebhookMessage");
        return this.execute(message.getBody());
    }

    public RequestFuture<?> send(File file) {
        return this.send(new WebhookMessageBuilder().setFile(file).build());
    }

    public RequestFuture<?> send(File file, String fileName) {
        return this.send(new WebhookMessageBuilder().setFile(file, fileName).build());
    }

    public RequestFuture<?> send(byte[] data, String fileName) {
        return this.send(new WebhookMessageBuilder().setFile(data, fileName).build());
    }

    public RequestFuture<?> send(InputStream data, String fileName) {
        return this.send(new WebhookMessageBuilder().setFile(data, fileName).build());
    }

    public RequestFuture<?> send(Message message) {
        return this.send(WebhookMessage.from(message));
    }

    public RequestFuture<?> send(MessageEmbed ... embeds) {
        return this.send(WebhookMessage.of(embeds));
    }

    public RequestFuture<?> send(Collection<MessageEmbed> embeds) {
        return this.send(WebhookMessage.of(embeds));
    }

    public RequestFuture<?> send(String content) {
        Checks.notBlank(content, "Content");
        Checks.check(content.length() <= 2000, "Content may not exceed 2000 characters!");
        return this.execute(WebhookClient.newBody(new JSONObject().put("content", (Object)content).toString()));
    }

    @Override
    public void close() {
        this.isShutdown = true;
        this.pool.shutdown();
    }

    protected void finalize() throws Throwable {
        if (!this.isShutdown) {
            LOG.warn("Detected unclosed WebhookClient! Did you forget to close it?");
        }
    }

    protected void checkShutdown() {
        if (this.isShutdown) {
            throw new RejectedExecutionException("Cannot send to closed client!");
        }
    }

    protected static RequestBody newBody(String object) {
        return RequestBody.create((MediaType)Requester.MEDIA_TYPE_JSON, (String)object);
    }

    protected RequestFuture<?> execute(RequestBody body) {
        this.checkShutdown();
        return this.queueRequest(body);
    }

    protected static HttpException failure(Response response) throws IOException {
        InputStream stream = Requester.getBody(response);
        String responseBody = new String(IOUtil.readFully(stream));
        return new HttpException("Request returned failure " + response.code() + ": " + responseBody);
    }

    protected RequestFuture<?> queueRequest(RequestBody body) {
        boolean wasQueued = this.isQueued;
        this.isQueued = true;
        Promise callback = new Promise();
        this.queue.add(ImmutablePair.of(body, callback));
        if (!wasQueued) {
            this.backoffQueue();
        }
        return callback;
    }

    protected Request newRequest(RequestBody body) {
        return new Request.Builder().url(this.url).method("POST", body).header("accept-encoding", "gzip").header("user-agent", USER_AGENT).build();
    }

    protected void backoffQueue() {
        this.pool.schedule(this::drainQueue, this.bucket.retryAfter(), TimeUnit.MILLISECONDS);
    }

    protected void drainQueue() {
        while (!this.queue.isEmpty()) {
            Pair pair = (Pair)this.queue.peek();
            if (((CompletableFuture)pair.getRight()).isCancelled()) {
                this.queue.poll();
                continue;
            }
            Request request = this.newRequest((RequestBody)pair.getLeft());
            try {
                Response response = this.client.newCall(request).execute();
                Throwable throwable = null;
                try {
                    this.bucket.update(response);
                    if (response.code() == 429) {
                        this.backoffQueue();
                        return;
                    }
                    if (!response.isSuccessful()) {
                        HttpException exception = WebhookClient.failure(response);
                        LOG.fatal(exception);
                        ((CompletableFuture)((Pair)this.queue.poll()).getRight()).completeExceptionally(exception);
                        continue;
                    }
                    ((CompletableFuture)((Pair)this.queue.poll()).getRight()).complete(null);
                    if (!this.bucket.isRateLimit()) continue;
                    this.backoffQueue();
                    return;
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (response == null) continue;
                    if (throwable != null) {
                        try {
                            response.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        continue;
                    }
                    response.close();
                }
            }
            catch (IOException e) {
                LOG.fatal(e);
                ((CompletableFuture)((Pair)this.queue.poll()).getRight()).completeExceptionally(e);
            }
        }
        this.isQueued = false;
    }

    protected static final class Bucket {
        public static final int RATE_LIMIT_CODE = 429;
        public long resetTime;
        public int remainingUses;
        public int limit = Integer.MAX_VALUE;

        protected Bucket() {
        }

        public synchronized boolean isRateLimit() {
            if (this.retryAfter() <= 0L) {
                this.remainingUses = this.limit;
            }
            return this.remainingUses <= 0;
        }

        public synchronized long retryAfter() {
            return this.resetTime - System.currentTimeMillis();
        }

        private synchronized void handleRatelimit(Response response, long current) throws IOException {
            long delay;
            String retryAfter = response.header("Retry-After");
            if (retryAfter == null) {
                JSONObject body = new JSONObject(new JSONTokener(Requester.getBody(response)));
                delay = body.getLong("retry_after");
            } else {
                delay = Long.parseLong(retryAfter);
            }
            this.resetTime = current + delay;
        }

        private synchronized void update0(Response response) throws IOException {
            boolean is429;
            long current = System.currentTimeMillis();
            boolean bl = is429 = response.code() == 429;
            if (is429) {
                this.handleRatelimit(response, current);
            } else if (!response.isSuccessful()) {
                LOG.debug("Failed to update buckets due to unsuccessful response with code: " + response.code() + " and body: ");
                LOG.debug(new String(IOUtil.readFully(Requester.getBody(response))));
                return;
            }
            this.remainingUses = Integer.parseInt(response.header("X-RateLimit-Remaining"));
            this.limit = Integer.parseInt(response.header("X-RateLimit-Limit"));
            String date = response.header("Date");
            if (date != null && !is429) {
                long reset = Long.parseLong(response.header("X-RateLimit-Reset"));
                OffsetDateTime tDate = OffsetDateTime.parse(date, DateTimeFormatter.RFC_1123_DATE_TIME);
                long delay = tDate.toInstant().until(Instant.ofEpochSecond(reset), ChronoUnit.MILLIS);
                this.resetTime = current + delay;
            }
        }

        public void update(Response response) {
            try {
                this.update0(response);
            }
            catch (Exception ex) {
                LOG.fatal(ex);
            }
        }
    }
}

