/*
 * Decompiled with CFR 0.152.
 */
package net.dv8tion.jda.core.utils.cache.impl;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.function.Function;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import net.dv8tion.jda.core.entities.ISnowflake;
import net.dv8tion.jda.core.utils.cache.impl.SnowflakeCacheViewImpl;

public class SortedSnowflakeCacheView<T extends ISnowflake & Comparable<T>>
extends SnowflakeCacheViewImpl<T> {
    protected final Comparator<T> comparator;

    public SortedSnowflakeCacheView(Comparator<T> comparator) {
        this(null, comparator);
    }

    public SortedSnowflakeCacheView(Function<T, String> nameMapper, Comparator<T> comparator) {
        super(nameMapper);
        this.comparator = comparator;
    }

    @Override
    public List<T> asList() {
        ArrayList<T> list = new ArrayList<T>(this.elements.valueCollection());
        list.sort(this.comparator);
        return Collections.unmodifiableList(list);
    }

    @Override
    public Stream<T> stream() {
        return super.stream().sorted(this.comparator);
    }

    @Override
    public Stream<T> parallelStream() {
        return super.parallelStream().sorted(this.comparator);
    }

    @Override
    @Nonnull
    public Iterator<T> iterator() {
        return this.asList().iterator();
    }
}

