/*
 * Decompiled with CFR 0.152.
 */
package net.dv8tion.jda.core.utils.cache.impl;

import gnu.trove.map.TLongObjectMap;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import net.dv8tion.jda.core.utils.Checks;
import net.dv8tion.jda.core.utils.MiscUtil;
import net.dv8tion.jda.core.utils.cache.CacheView;

public abstract class AbstractCacheView<T>
implements CacheView<T> {
    protected final TLongObjectMap<T> elements = MiscUtil.newLongMap();
    protected final Function<T, String> nameMapper;

    protected AbstractCacheView(Function<T, String> nameMapper) {
        this.nameMapper = nameMapper;
    }

    public void clear() {
        this.elements.clear();
    }

    public TLongObjectMap<T> getMap() {
        return this.elements;
    }

    @Override
    public List<T> asList() {
        return Collections.unmodifiableList(new ArrayList(this.elements.valueCollection()));
    }

    @Override
    public Set<T> asSet() {
        return Collections.unmodifiableSet(new HashSet(this.elements.valueCollection()));
    }

    @Override
    public long size() {
        return this.elements.size();
    }

    @Override
    public boolean isEmpty() {
        return this.elements.isEmpty();
    }

    @Override
    public List<T> getElementsByName(String name, boolean ignoreCase) {
        Checks.notEmpty(name, "Name");
        if (this.elements.isEmpty()) {
            return Collections.emptyList();
        }
        if (this.nameMapper == null) {
            throw new UnsupportedOperationException("The contained elements are not assigned with names.");
        }
        LinkedList list = new LinkedList();
        for (Object elem : this.elements.valueCollection()) {
            String elementName = this.nameMapper.apply(elem);
            if (elementName == null) continue;
            if (ignoreCase) {
                if (!elementName.equalsIgnoreCase(name)) continue;
                list.add(elem);
                continue;
            }
            if (!elementName.equals(name)) continue;
            list.add(elem);
        }
        return list;
    }

    @Override
    public Stream<T> stream() {
        return this.elements.valueCollection().stream();
    }

    @Override
    public Stream<T> parallelStream() {
        return this.elements.valueCollection().parallelStream();
    }

    @Override
    @Nonnull
    public Iterator<T> iterator() {
        return this.elements.valueCollection().iterator();
    }
}

