/*
 * Decompiled with CFR 0.152.
 */
package net.dv8tion.jda.core.utils;

import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import net.dv8tion.jda.core.JDA;
import net.dv8tion.jda.core.utils.Helpers;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.event.Level;

public class SimpleLog {
    public static Level LEVEL = Level.INFO;
    public static final boolean SLF4J_ENABLED;
    private static final String FORMAT = "[%time%] [%level%] [%name%]: %text%";
    private static final SimpleDateFormat DFORMAT;
    private static final Map<String, SimpleLog> LOGS;
    private static final Set<LogListener> listeners;
    private final String name;
    private final Logger logger;
    private Level level = null;

    private SimpleLog(Class<?> clazz) {
        this.name = clazz.getName();
        this.logger = SLF4J_ENABLED ? LoggerFactory.getLogger(clazz) : null;
    }

    private SimpleLog(String name) {
        this.name = name;
        this.logger = SLF4J_ENABLED ? LoggerFactory.getLogger((String)name) : null;
    }

    public String getName() {
        return this.name;
    }

    public void setLevel(Level lev) {
        this.level = lev;
    }

    public Level getLevel() {
        return this.level;
    }

    public Level getEffectiveLevel() {
        if (this.logger != null) {
            if (this.logger.isTraceEnabled()) {
                return Level.TRACE;
            }
            if (this.logger.isDebugEnabled()) {
                return Level.DEBUG;
            }
            if (this.logger.isInfoEnabled()) {
                return Level.INFO;
            }
            if (this.logger.isWarnEnabled()) {
                return Level.WARN;
            }
            return Level.ERROR;
        }
        return this.level == null ? LEVEL : this.level;
    }

    private void slf4j(Level level, Object obj) {
        if (obj instanceof Throwable) {
            Throwable t = (Throwable)obj;
            switch (level) {
                case ERROR: {
                    this.logger.error("Encountered an Exception ", t);
                    break;
                }
                case WARN: {
                    this.logger.warn("Encountered an Exception ", t);
                    break;
                }
                case INFO: {
                    this.logger.info("Encountered an Exception ", t);
                    break;
                }
                case DEBUG: {
                    this.logger.debug("Encountered an Exception ", t);
                    break;
                }
                case TRACE: {
                    this.logger.trace("Encountered an Exception ", t);
                    break;
                }
            }
            return;
        }
        String msg = String.valueOf(obj);
        switch (level) {
            case ERROR: {
                this.logger.error(msg);
                break;
            }
            case WARN: {
                this.logger.warn(msg);
                break;
            }
            case INFO: {
                this.logger.info(msg);
                break;
            }
            case DEBUG: {
                this.logger.debug(msg);
                break;
            }
            case TRACE: {
                this.logger.trace(msg);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void log(Level level, Object obj) {
        if (this.logger != null) {
            this.slf4j(level, obj);
            return;
        }
        if (this.getEffectiveLevel().ordinal() < level.ordinal()) {
            return;
        }
        String msg = obj instanceof Throwable ? "Encountered an Exception: \n" + Helpers.getStackTrace((Throwable)obj) : String.valueOf(obj);
        Set<LogListener> set = listeners;
        synchronized (set) {
            for (LogListener listener : listeners) {
                if (obj instanceof Throwable) {
                    listener.onError(this, (Throwable)obj);
                    continue;
                }
                listener.onLog(this, level, msg);
            }
        }
        this.print(FORMAT.replace("%time%", DFORMAT.format(new Date())).replace("%level%", level.toString()).replace("%name%", this.name).replace("%text%", msg), level);
    }

    public void trace(Object msg) {
        this.log(Level.TRACE, msg);
    }

    public void debug(Object msg) {
        this.log(Level.DEBUG, msg);
    }

    public void info(Object msg) {
        this.log(Level.INFO, msg);
    }

    public void warn(Object msg) {
        this.log(Level.WARN, msg);
    }

    public void fatal(Object msg) {
        this.log(Level.ERROR, msg);
    }

    private void print(String msg, Level level) {
        if (level == Level.ERROR || level == Level.WARN) {
            System.err.println(msg);
        } else {
            System.out.println(msg);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static SimpleLog getLog(String name) {
        Map<String, SimpleLog> map = LOGS;
        synchronized (map) {
            return LOGS.computeIfAbsent(name.toLowerCase(), n -> new SimpleLog(name));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static SimpleLog getLog(Class<?> clazz) {
        Map<String, SimpleLog> map = LOGS;
        synchronized (map) {
            return LOGS.computeIfAbsent(clazz.getName().toLowerCase(), name -> new SimpleLog(clazz));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addListener(LogListener listener) {
        Set<LogListener> set = listeners;
        synchronized (set) {
            listeners.add(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void removeListener(LogListener listener) {
        Set<LogListener> set = listeners;
        synchronized (set) {
            listeners.remove(listener);
        }
    }

    static {
        boolean tmp = false;
        try {
            Class.forName("org.slf4j.impl.StaticLoggerBinder");
            tmp = true;
        }
        catch (ClassNotFoundException e) {
            LoggerFactory.getLogger(JDA.class);
        }
        SLF4J_ENABLED = tmp;
        DFORMAT = new SimpleDateFormat("HH:mm:ss");
        LOGS = new HashMap<String, SimpleLog>();
        listeners = new HashSet<LogListener>();
    }

    public static interface LogListener {
        public void onLog(SimpleLog var1, Level var2, Object var3);

        public void onError(SimpleLog var1, Throwable var2);
    }
}

