/*
 * Decompiled with CFR 0.152.
 */
package net.dv8tion.jda.core.requests.restaction.order;

import java.util.List;
import net.dv8tion.jda.core.Permission;
import net.dv8tion.jda.core.entities.Channel;
import net.dv8tion.jda.core.entities.ChannelType;
import net.dv8tion.jda.core.entities.Guild;
import net.dv8tion.jda.core.entities.Member;
import net.dv8tion.jda.core.entities.TextChannel;
import net.dv8tion.jda.core.exceptions.InsufficientPermissionException;
import net.dv8tion.jda.core.requests.Route;
import net.dv8tion.jda.core.requests.restaction.order.OrderAction;
import net.dv8tion.jda.core.utils.Checks;
import okhttp3.RequestBody;
import org.json.JSONArray;
import org.json.JSONObject;

public class ChannelOrderAction<T extends Channel>
extends OrderAction<T, ChannelOrderAction<T>> {
    protected final Guild guild;
    protected final ChannelType type;

    public ChannelOrderAction(Guild guild, ChannelType type) {
        super(guild.getJDA(), Route.Guilds.MODIFY_CHANNELS.compile(guild.getId()));
        List<Comparable<TextChannel>> chans;
        this.guild = guild;
        this.type = type;
        switch (type) {
            case TEXT: {
                chans = guild.getTextChannels();
                break;
            }
            case VOICE: {
                chans = guild.getVoiceChannels();
                break;
            }
            case CATEGORY: {
                chans = guild.getCategories();
                break;
            }
            default: {
                throw new IllegalArgumentException("Cannot order specified channel type " + (Object)((Object)type));
            }
        }
        this.orderList.addAll(chans);
    }

    public Guild getGuild() {
        return this.guild;
    }

    public ChannelType getChannelType() {
        return this.type;
    }

    @Override
    protected RequestBody finalizeData() {
        Member self = this.guild.getSelfMember();
        if (!self.hasPermission(Permission.MANAGE_CHANNEL)) {
            throw new InsufficientPermissionException(Permission.MANAGE_CHANNEL);
        }
        JSONArray array = new JSONArray();
        for (int i = 0; i < this.orderList.size(); ++i) {
            Channel chan = (Channel)this.orderList.get(i);
            array.put((Object)new JSONObject().put("id", (Object)chan.getId()).put("position", i));
        }
        return this.getRequestBody(array);
    }

    @Override
    protected void validateInput(T entity) {
        Checks.check(entity.getGuild().equals(this.guild), "Provided channel is not from this Guild!");
        Checks.check(this.orderList.contains(entity), "Provided channel is not in the list of orderable channels!");
    }
}

