/*
 * Decompiled with CFR 0.152.
 */
package net.dv8tion.jda.core.requests.restaction;

import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import javax.annotation.CheckReturnValue;
import net.dv8tion.jda.core.Permission;
import net.dv8tion.jda.core.entities.Category;
import net.dv8tion.jda.core.entities.Channel;
import net.dv8tion.jda.core.entities.ChannelType;
import net.dv8tion.jda.core.entities.EntityBuilder;
import net.dv8tion.jda.core.entities.Guild;
import net.dv8tion.jda.core.entities.Member;
import net.dv8tion.jda.core.entities.Role;
import net.dv8tion.jda.core.entities.VoiceChannel;
import net.dv8tion.jda.core.requests.Request;
import net.dv8tion.jda.core.requests.Response;
import net.dv8tion.jda.core.requests.Route;
import net.dv8tion.jda.core.requests.restaction.AuditableRestAction;
import net.dv8tion.jda.core.utils.Checks;
import okhttp3.RequestBody;
import org.json.JSONArray;
import org.json.JSONObject;
import org.json.JSONString;

public class ChannelAction
extends AuditableRestAction<Channel> {
    public static final int ROLE_TYPE = 0;
    public static final int MEMBER_TYPE = 1;
    protected final Set<PromisePermissionOverride> overrides = new HashSet<PromisePermissionOverride>();
    protected final Guild guild;
    protected final ChannelType type;
    protected String name;
    protected Category parent;
    protected String topic = null;
    protected Boolean nsfw = null;
    protected Integer bitrate = null;
    protected Integer userlimit = null;

    public ChannelAction(Route.CompiledRoute route, String name, Guild guild, ChannelType type) {
        super(guild.getJDA(), route);
        this.guild = guild;
        this.type = type;
        this.name = name;
    }

    @CheckReturnValue
    public ChannelAction setName(String name) {
        Checks.notNull(name, "Channel name");
        if (name.length() < 2 || name.length() > 100) {
            throw new IllegalArgumentException("Provided channel name must be 2 to 100 characters in length");
        }
        this.name = name;
        return this;
    }

    @CheckReturnValue
    public ChannelAction setParent(Category category) {
        Checks.check(category == null || category.getGuild().equals(this.guild), "Category is not from same guild!");
        this.parent = category;
        return this;
    }

    @CheckReturnValue
    public ChannelAction setTopic(String topic) {
        if (this.type != ChannelType.TEXT) {
            throw new UnsupportedOperationException("Can only set the topic for a TextChannel!");
        }
        if (topic != null && topic.length() > 1024) {
            throw new IllegalArgumentException("Channel Topic must not be greater than 1024 in length!");
        }
        this.topic = topic;
        return this;
    }

    @CheckReturnValue
    public ChannelAction setNSFW(boolean nsfw) {
        if (this.type != ChannelType.TEXT) {
            throw new UnsupportedOperationException("Can only set nsfw for a TextChannel!");
        }
        this.nsfw = nsfw;
        return this;
    }

    @CheckReturnValue
    public ChannelAction addPermissionOverride(Role role, Collection<Permission> allow, Collection<Permission> deny) {
        this.checkPermissions(allow);
        this.checkPermissions(deny);
        long allowRaw = allow != null ? Permission.getRaw(allow) : 0L;
        long denyRaw = deny != null ? Permission.getRaw(deny) : 0L;
        return this.addPermissionOverride(role, allowRaw, denyRaw);
    }

    @CheckReturnValue
    public ChannelAction addPermissionOverride(Member member, Collection<Permission> allow, Collection<Permission> deny) {
        this.checkPermissions(allow);
        this.checkPermissions(deny);
        long allowRaw = allow != null ? Permission.getRaw(allow) : 0L;
        long denyRaw = deny != null ? Permission.getRaw(deny) : 0L;
        return this.addPermissionOverride(member, allowRaw, denyRaw);
    }

    @CheckReturnValue
    public ChannelAction addPermissionOverride(Role role, long allow, long deny) {
        Checks.notNull(role, "Override Role");
        Checks.notNegative(allow, "Granted permissions value");
        Checks.notNegative(deny, "Denied permissions value");
        Checks.check(allow <= Permission.ALL_PERMISSIONS, "Specified allow value may not be greater than a full permission set");
        Checks.check(deny <= Permission.ALL_PERMISSIONS, "Specified deny value may not be greater than a full permission set");
        Checks.check(role.getGuild().equals(this.guild), "Specified Role is not in the same Guild!");
        String id = role.getId();
        this.overrides.add(new PromisePermissionOverride(0, id, allow, deny));
        return this;
    }

    @CheckReturnValue
    public ChannelAction addPermissionOverride(Member member, long allow, long deny) {
        Checks.notNull(member, "Override Member");
        Checks.notNegative(allow, "Granted permissions value");
        Checks.notNegative(deny, "Denied permissions value");
        Checks.check(allow <= Permission.ALL_PERMISSIONS, "Specified allow value may not be greater than a full permission set");
        Checks.check(deny <= Permission.ALL_PERMISSIONS, "Specified deny value may not be greater than a full permission set");
        Checks.check(member.getGuild().equals(this.guild), "Specified Member is not in the same Guild!");
        String id = member.getUser().getId();
        this.overrides.add(new PromisePermissionOverride(1, id, allow, deny));
        return this;
    }

    @CheckReturnValue
    public ChannelAction setBitrate(Integer bitrate) {
        if (this.type != ChannelType.VOICE) {
            throw new UnsupportedOperationException("Can only set the bitrate for a VoiceChannel!");
        }
        if (bitrate != null) {
            if (bitrate < 8000) {
                throw new IllegalArgumentException("Bitrate must be greater than 8000.");
            }
            if (bitrate > 128000) {
                throw new IllegalArgumentException("Bitrate must be less than 128000.");
            }
        }
        this.bitrate = bitrate;
        return this;
    }

    @CheckReturnValue
    public ChannelAction setUserlimit(Integer userlimit) {
        if (this.type != ChannelType.VOICE) {
            throw new UnsupportedOperationException("Can only set the userlimit for a VoiceChannel!");
        }
        if (userlimit != null && (userlimit < 0 || userlimit > 99)) {
            throw new IllegalArgumentException("Userlimit must be between 0-99!");
        }
        this.userlimit = userlimit;
        return this;
    }

    @Override
    protected RequestBody finalizeData() {
        JSONObject object = new JSONObject();
        object.put("name", (Object)this.name);
        object.put("type", this.type.getId());
        object.put("permission_overwrites", (Object)new JSONArray(this.overrides));
        switch (this.type) {
            case VOICE: {
                if (this.bitrate != null) {
                    object.put("bitrate", this.bitrate.intValue());
                }
                if (this.userlimit == null) break;
                object.put("user_limit", this.userlimit.intValue());
                break;
            }
            case TEXT: {
                if (this.topic != null && !this.topic.isEmpty()) {
                    object.put("topic", (Object)this.topic);
                }
                if (this.nsfw == null) break;
                object.put("nsfw", (Object)this.nsfw);
            }
        }
        if (this.type != ChannelType.CATEGORY && this.parent != null) {
            object.put("parent_id", (Object)this.parent.getId());
        }
        return this.getRequestBody(object);
    }

    @Override
    protected void handleResponse(Response response, Request<Channel> request) {
        Comparable<VoiceChannel> channel;
        if (!response.isOk()) {
            request.onFailure(response);
            return;
        }
        EntityBuilder builder = this.api.getEntityBuilder();
        switch (this.type) {
            case VOICE: {
                channel = builder.createVoiceChannel(response.getObject(), this.guild.getIdLong());
                break;
            }
            case TEXT: {
                channel = builder.createTextChannel(response.getObject(), this.guild.getIdLong());
                break;
            }
            case CATEGORY: {
                channel = builder.createCategory(response.getObject(), this.guild.getIdLong());
                break;
            }
            default: {
                request.onFailure(new IllegalStateException("Created channel of unknown type!"));
                return;
            }
        }
        request.onSuccess((Channel)((Object)channel));
    }

    protected void checkPermissions(Permission ... permissions) {
        if (permissions == null) {
            return;
        }
        for (Permission p : permissions) {
            Checks.notNull((Object)p, "Permissions");
        }
    }

    protected void checkPermissions(Collection<Permission> permissions) {
        if (permissions == null) {
            return;
        }
        for (Permission p : permissions) {
            Checks.notNull((Object)p, "Permissions");
        }
    }

    protected final class PromisePermissionOverride
    implements JSONString {
        protected final String id;
        protected final long deny;
        protected final long allow;
        protected final int type;

        public PromisePermissionOverride(int type, String id, long allow, long deny) {
            this.type = type;
            this.id = id;
            this.deny = deny;
            this.allow = allow;
        }

        public String toJSONString() {
            JSONObject object = new JSONObject();
            object.put("id", (Object)this.id);
            object.put("type", this.type);
            object.put("deny", this.deny);
            object.put("allow", this.allow);
            return object.toString();
        }
    }
}

