/*
 * Decompiled with CFR 0.152.
 */
package net.dv8tion.jda.core.requests;

import com.neovisionaries.ws.client.ThreadType;
import com.neovisionaries.ws.client.WebSocket;
import com.neovisionaries.ws.client.WebSocketAdapter;
import com.neovisionaries.ws.client.WebSocketException;
import com.neovisionaries.ws.client.WebSocketFrame;
import com.neovisionaries.ws.client.WebSocketListener;
import gnu.trove.iterator.TLongObjectIterator;
import gnu.trove.map.TLongObjectMap;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.time.OffsetDateTime;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.Semaphore;
import java.util.zip.DataFormatException;
import java.util.zip.InflaterOutputStream;
import net.dv8tion.jda.client.entities.impl.JDAClientImpl;
import net.dv8tion.jda.client.handle.CallCreateHandler;
import net.dv8tion.jda.client.handle.CallDeleteHandler;
import net.dv8tion.jda.client.handle.CallUpdateHandler;
import net.dv8tion.jda.client.handle.ChannelRecipientAddHandler;
import net.dv8tion.jda.client.handle.ChannelRecipientRemoveHandler;
import net.dv8tion.jda.client.handle.RelationshipAddHandler;
import net.dv8tion.jda.client.handle.RelationshipRemoveHandler;
import net.dv8tion.jda.core.AccountType;
import net.dv8tion.jda.core.JDA;
import net.dv8tion.jda.core.Permission;
import net.dv8tion.jda.core.audio.ConnectionRequest;
import net.dv8tion.jda.core.audio.ConnectionStage;
import net.dv8tion.jda.core.audio.hooks.ConnectionListener;
import net.dv8tion.jda.core.audio.hooks.ConnectionStatus;
import net.dv8tion.jda.core.entities.Channel;
import net.dv8tion.jda.core.entities.Guild;
import net.dv8tion.jda.core.entities.GuildVoiceState;
import net.dv8tion.jda.core.entities.VoiceChannel;
import net.dv8tion.jda.core.entities.impl.GuildImpl;
import net.dv8tion.jda.core.entities.impl.JDAImpl;
import net.dv8tion.jda.core.events.DisconnectEvent;
import net.dv8tion.jda.core.events.ExceptionEvent;
import net.dv8tion.jda.core.events.ReadyEvent;
import net.dv8tion.jda.core.events.ReconnectedEvent;
import net.dv8tion.jda.core.events.ResumedEvent;
import net.dv8tion.jda.core.events.ShutdownEvent;
import net.dv8tion.jda.core.handle.ChannelCreateHandler;
import net.dv8tion.jda.core.handle.ChannelDeleteHandler;
import net.dv8tion.jda.core.handle.ChannelUpdateHandler;
import net.dv8tion.jda.core.handle.GuildBanHandler;
import net.dv8tion.jda.core.handle.GuildCreateHandler;
import net.dv8tion.jda.core.handle.GuildDeleteHandler;
import net.dv8tion.jda.core.handle.GuildEmojisUpdateHandler;
import net.dv8tion.jda.core.handle.GuildMemberAddHandler;
import net.dv8tion.jda.core.handle.GuildMemberRemoveHandler;
import net.dv8tion.jda.core.handle.GuildMemberUpdateHandler;
import net.dv8tion.jda.core.handle.GuildMembersChunkHandler;
import net.dv8tion.jda.core.handle.GuildRoleCreateHandler;
import net.dv8tion.jda.core.handle.GuildRoleDeleteHandler;
import net.dv8tion.jda.core.handle.GuildRoleUpdateHandler;
import net.dv8tion.jda.core.handle.GuildSyncHandler;
import net.dv8tion.jda.core.handle.GuildUpdateHandler;
import net.dv8tion.jda.core.handle.MessageBulkDeleteHandler;
import net.dv8tion.jda.core.handle.MessageCreateHandler;
import net.dv8tion.jda.core.handle.MessageDeleteHandler;
import net.dv8tion.jda.core.handle.MessageReactionBulkRemoveHandler;
import net.dv8tion.jda.core.handle.MessageReactionHandler;
import net.dv8tion.jda.core.handle.MessageUpdateHandler;
import net.dv8tion.jda.core.handle.PresenceUpdateHandler;
import net.dv8tion.jda.core.handle.ReadyHandler;
import net.dv8tion.jda.core.handle.SocketHandler;
import net.dv8tion.jda.core.handle.TypingStartHandler;
import net.dv8tion.jda.core.handle.UserUpdateHandler;
import net.dv8tion.jda.core.handle.VoiceServerUpdateHandler;
import net.dv8tion.jda.core.handle.VoiceStateUpdateHandler;
import net.dv8tion.jda.core.managers.AudioManager;
import net.dv8tion.jda.core.managers.impl.AudioManagerImpl;
import net.dv8tion.jda.core.managers.impl.PresenceImpl;
import net.dv8tion.jda.core.requests.CloseCode;
import net.dv8tion.jda.core.requests.Request;
import net.dv8tion.jda.core.requests.Response;
import net.dv8tion.jda.core.requests.RestAction;
import net.dv8tion.jda.core.requests.Route;
import net.dv8tion.jda.core.requests.SessionReconnectQueue;
import net.dv8tion.jda.core.utils.MiscUtil;
import net.dv8tion.jda.core.utils.SimpleLog;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class WebSocketClient
extends WebSocketAdapter
implements WebSocketListener {
    public static final SimpleLog LOG = SimpleLog.getLog(WebSocketClient.class);
    public static final int DISCORD_GATEWAY_VERSION = 6;
    public static final int IDENTIFY_DELAY = 5;
    private static final String INVALIDATE_REASON = "INVALIDATE_SESSION";
    protected final JDAImpl api;
    protected final JDA.ShardInfo shardInfo;
    protected final Map<String, SocketHandler> handlers = new HashMap<String, SocketHandler>();
    protected final Set<String> cfRays = new HashSet<String>();
    protected final Set<String> traces = new HashSet<String>();
    protected WebSocket socket;
    protected String gatewayUrl = null;
    protected String sessionId = null;
    protected volatile Thread keepAliveThread;
    protected boolean initiating;
    protected final List<JSONObject> cachedEvents = new LinkedList<JSONObject>();
    protected int reconnectTimeoutS = 2;
    protected long heartbeatStartTime;
    protected final TLongObjectMap<ConnectionRequest> queuedAudioConnections = MiscUtil.newLongMap();
    protected final Semaphore audioQueueLock = new Semaphore(1, true);
    protected final LinkedList<String> chunkSyncQueue = new LinkedList();
    protected final LinkedList<String> ratelimitQueue = new LinkedList();
    protected final SessionReconnectQueue reconnectQueue;
    protected volatile Thread ratelimitThread = null;
    protected volatile long ratelimitResetTime;
    protected volatile int messagesSent;
    protected volatile boolean shutdown = false;
    protected boolean shouldReconnect = true;
    protected boolean handleIdentifyRateLimit = false;
    protected boolean connected = false;
    protected volatile boolean chunkingAndSyncing = false;
    protected volatile boolean printedRateLimitMessage = false;
    protected boolean sentAuthInfo = false;
    protected boolean firstInit = true;
    protected boolean processingReady = true;

    public WebSocketClient(JDAImpl api, SessionReconnectQueue reconnectQueue) {
        this.api = api;
        this.shardInfo = api.getShardInfo();
        this.shouldReconnect = api.isAutoReconnect();
        this.reconnectQueue = reconnectQueue;
        this.setupHandlers();
        this.setupSendingThread();
        this.connect();
    }

    public Set<String> getCfRays() {
        return this.cfRays;
    }

    public Set<String> getTraces() {
        return this.traces;
    }

    protected void updateTraces(JSONArray arr, String type, int opCode) {
        String msg = String.format("Received a _trace for %s (OP: %d) with %s", type, opCode, arr);
        LOG.debug(msg);
        this.traces.clear();
        for (Object o : arr) {
            this.traces.add(String.valueOf(o));
        }
    }

    public void setAutoReconnect(boolean reconnect) {
        this.shouldReconnect = reconnect;
    }

    public boolean isConnected() {
        return this.connected;
    }

    public void ready() {
        if (this.initiating) {
            this.initiating = false;
            this.processingReady = false;
            if (this.firstInit) {
                this.firstInit = false;
                JDAImpl.LOG.info("Finished Loading!");
                if (this.api.getGuilds().size() >= 2500) {
                    JDAImpl.LOG.warn(" __      __ _    ___  _  _  ___  _  _   ___  _ ");
                    JDAImpl.LOG.warn(" \\ \\    / //_\\  | _ \\| \\| ||_ _|| \\| | / __|| |");
                    JDAImpl.LOG.warn("  \\ \\/\\/ // _ \\ |   /| .` | | | | .` || (_ ||_|");
                    JDAImpl.LOG.warn("   \\_/\\_//_/ \\_\\|_|_\\|_|\\_||___||_|\\_| \\___|(_)");
                    JDAImpl.LOG.warn("You're running a session with over 2500 connected");
                    JDAImpl.LOG.warn("guilds. You should shard the connection in order");
                    JDAImpl.LOG.warn("to split the load or things like resuming");
                    JDAImpl.LOG.warn("connection might not work as expected.");
                    JDAImpl.LOG.warn("For more info see https://git.io/vrFWP");
                }
                this.api.getEventManager().handle(new ReadyEvent(this.api, this.api.getResponseTotal()));
            } else {
                this.updateAudioManagerReferences();
                JDAImpl.LOG.info("Finished (Re)Loading!");
                this.api.getEventManager().handle(new ReconnectedEvent(this.api, this.api.getResponseTotal()));
            }
        } else {
            JDAImpl.LOG.info("Successfully resumed Session!");
            this.api.getEventManager().handle(new ResumedEvent(this.api, this.api.getResponseTotal()));
        }
        this.api.setStatus(JDA.Status.CONNECTED);
        LOG.debug("Resending " + this.cachedEvents.size() + " cached events...");
        this.handle(this.cachedEvents);
        LOG.debug("Sending of cached events finished.");
        this.cachedEvents.clear();
    }

    public boolean isReady() {
        return !this.initiating;
    }

    public void handle(List<JSONObject> events) {
        events.forEach(this::handleEvent);
    }

    public void send(String message) {
        this.ratelimitQueue.addLast(message);
    }

    public void chunkOrSyncRequest(JSONObject request) {
        this.chunkSyncQueue.addLast(request.toString());
    }

    private boolean send(String message, boolean skipQueue) {
        if (!this.connected) {
            return false;
        }
        long now = System.currentTimeMillis();
        if (this.ratelimitResetTime <= now) {
            this.messagesSent = 0;
            this.ratelimitResetTime = now + 60000L;
            this.printedRateLimitMessage = false;
        }
        if (this.messagesSent <= 115 || skipQueue && this.messagesSent <= 119) {
            LOG.trace("<- " + message);
            this.socket.sendText(message);
            ++this.messagesSent;
            return true;
        }
        if (!this.printedRateLimitMessage) {
            LOG.warn("Hit the WebSocket RateLimit! If you see this message a lot then you might need to talk to DV8FromTheWorld.");
            this.printedRateLimitMessage = true;
        }
        return false;
    }

    private void setupSendingThread() {
        this.ratelimitThread = new Thread(() -> {
            boolean queueLocked = false;
            while (!Thread.currentThread().isInterrupted()) {
                try {
                    if (!this.sentAuthInfo) {
                        Thread.sleep(500L);
                        continue;
                    }
                    boolean attemptedToSend = false;
                    boolean needRatelimit = false;
                    this.audioQueueLock.acquire();
                    queueLocked = true;
                    ConnectionRequest audioRequest = this.getNextAudioConnectRequest();
                    String chunkOrSyncRequest = this.chunkSyncQueue.peekFirst();
                    if (chunkOrSyncRequest != null) {
                        this.audioQueueLock.release();
                        queueLocked = false;
                        boolean bl = needRatelimit = !this.send(chunkOrSyncRequest, false);
                        if (!needRatelimit) {
                            this.chunkSyncQueue.removeFirst();
                        }
                        attemptedToSend = true;
                    } else if (audioRequest != null) {
                        JSONObject packet;
                        VoiceChannel channel = audioRequest.getChannel();
                        Guild guild = this.api.getGuildById(audioRequest.getGuildIdLong());
                        if (guild == null) {
                            this.queuedAudioConnections.remove(audioRequest.getGuildIdLong());
                            this.audioQueueLock.release();
                            queueLocked = false;
                            continue;
                        }
                        ConnectionStage stage = audioRequest.getStage();
                        AudioManager audioManager = guild.getAudioManager();
                        switch (stage) {
                            case DISCONNECT: 
                            case RECONNECT: {
                                packet = this.newVoiceClose(audioRequest.getGuildIdLong());
                                break;
                            }
                            default: {
                                packet = this.newVoiceOpen(audioManager, channel);
                            }
                        }
                        boolean bl = needRatelimit = !this.send(packet.toString(), false);
                        if (!needRatelimit) {
                            audioRequest.setNextAttemptEpoch(System.currentTimeMillis() + 2000L);
                            GuildVoiceState voiceState = guild.getSelfMember().getVoiceState();
                            this.updateAudioConnection0(guild.getIdLong(), voiceState.getChannel());
                        }
                        this.audioQueueLock.release();
                        queueLocked = false;
                        attemptedToSend = true;
                    } else {
                        this.audioQueueLock.release();
                        queueLocked = false;
                        String message = this.ratelimitQueue.peekFirst();
                        if (message != null) {
                            boolean bl = needRatelimit = !this.send(message, false);
                            if (!needRatelimit) {
                                this.ratelimitQueue.removeFirst();
                            }
                            attemptedToSend = true;
                        }
                    }
                    if (!needRatelimit && attemptedToSend) continue;
                    Thread.sleep(1000L);
                }
                catch (InterruptedException ignored) {
                    LOG.debug("Main WS send thread interrupted. Most likely JDA is disconnecting the websocket.");
                    break;
                }
                finally {
                    if (!queueLocked) continue;
                    this.audioQueueLock.release();
                }
            }
        });
        this.ratelimitThread.setUncaughtExceptionHandler((thread, throwable) -> {
            this.handleCallbackError(this.socket, throwable);
            this.setupSendingThread();
        });
        this.ratelimitThread.setName(this.api.getIdentifierString() + " MainWS-Sending Thread");
        this.ratelimitThread.start();
    }

    private JSONObject newVoiceClose(long guildId) {
        return new JSONObject().put("op", 4).put("d", (Object)new JSONObject().put("guild_id", (Object)Long.toUnsignedString(guildId)).put("channel_id", JSONObject.NULL).put("self_mute", false).put("self_deaf", false));
    }

    private JSONObject newVoiceOpen(AudioManager manager, VoiceChannel channel) {
        return new JSONObject().put("op", 4).put("d", (Object)new JSONObject().put("guild_id", (Object)channel.getGuild().getId()).put("channel_id", (Object)channel.getId()).put("self_mute", manager.isSelfMuted()).put("self_deaf", manager.isSelfDeafened()));
    }

    public void close() {
        this.socket.sendClose(1000);
    }

    public void close(int code) {
        this.socket.sendClose(code);
    }

    public void close(int code, String reason) {
        this.socket.sendClose(code, reason);
    }

    public void shutdown() {
        this.shutdown = true;
        this.shouldReconnect = false;
        if (this.reconnectQueue != null) {
            this.reconnectQueue.reconnectQueue.remove((Object)this);
        }
        this.close(1000, "Shutting down");
    }

    protected void connect() {
        if (this.api.getStatus() != JDA.Status.ATTEMPTING_TO_RECONNECT) {
            this.api.setStatus(JDA.Status.CONNECTING_TO_WEBSOCKET);
        }
        if (this.shutdown) {
            throw new RejectedExecutionException("JDA is shutdown!");
        }
        this.initiating = true;
        try {
            if (this.gatewayUrl == null) {
                this.gatewayUrl = this.getGateway();
                if (this.gatewayUrl == null) {
                    throw new RuntimeException("Could not fetch WS-Gateway!");
                }
            }
            this.socket = this.api.getWebSocketFactory().createSocket(this.gatewayUrl).addHeader("Accept-Encoding", "gzip").addListener((WebSocketListener)this);
            this.socket.connect();
        }
        catch (WebSocketException | IOException e) {
            throw new IllegalStateException(e);
        }
    }

    protected String getGateway() {
        try {
            RestAction<String> gateway = new RestAction<String>((JDA)this.api, Route.Misc.GATEWAY.compile(new String[0])){

                @Override
                protected void handleResponse(Response response, Request<String> request) {
                    try {
                        if (response.isOk()) {
                            request.onSuccess(response.getObject().getString("url"));
                        } else {
                            request.onFailure(new Exception("Failed to get gateway url"));
                        }
                    }
                    catch (Exception e) {
                        request.onFailure(e);
                    }
                }
            };
            return (String)gateway.complete(false) + "?encoding=json&v=" + 6;
        }
        catch (Exception ex) {
            return null;
        }
    }

    public void onConnected(WebSocket websocket, Map<String, List<String>> headers) {
        List<String> values;
        this.api.setStatus(JDA.Status.LOADING_SUBSYSTEMS);
        LOG.info("Connected to WebSocket");
        if (headers.containsKey("cf-ray") && !(values = headers.get("cf-ray")).isEmpty()) {
            String ray = values.get(0);
            this.cfRays.add(ray);
            LOG.debug("Received new CF-RAY: " + ray);
        }
        this.connected = true;
        this.reconnectTimeoutS = 2;
        this.messagesSent = 0;
        this.ratelimitResetTime = System.currentTimeMillis() + 60000L;
        if (this.sessionId == null) {
            this.sendIdentify();
        } else {
            this.sendResume();
        }
    }

    public void onDisconnected(WebSocket websocket, WebSocketFrame serverCloseFrame, WebSocketFrame clientCloseFrame, boolean closedByServer) {
        boolean closeCodeIsReconnect;
        this.sentAuthInfo = false;
        this.connected = false;
        this.api.setStatus(JDA.Status.DISCONNECTED);
        CloseCode closeCode = null;
        int rawCloseCode = 1000;
        boolean isInvalidate = false;
        if (this.keepAliveThread != null) {
            this.keepAliveThread.interrupt();
            this.keepAliveThread = null;
        }
        if (serverCloseFrame != null) {
            rawCloseCode = serverCloseFrame.getCloseCode();
            closeCode = CloseCode.from(rawCloseCode);
            if (closeCode == CloseCode.RATE_LIMITED) {
                LOG.fatal("WebSocket connection closed due to ratelimit! Sent more than 120 websocket messages in under 60 seconds!");
            } else if (closeCode != null) {
                LOG.debug("WebSocket connection closed with code " + (Object)((Object)closeCode));
            } else {
                LOG.warn("WebSocket connection closed with unknown meaning for close-code " + rawCloseCode);
            }
        }
        if (clientCloseFrame != null && clientCloseFrame.getCloseCode() == 1000 && Objects.equals(clientCloseFrame.getCloseReason(), INVALIDATE_REASON)) {
            isInvalidate = true;
        }
        boolean bl = closeCodeIsReconnect = closeCode == null || closeCode.isReconnect();
        if (!this.shouldReconnect || !closeCodeIsReconnect) {
            if (this.ratelimitThread != null) {
                this.ratelimitThread.interrupt();
            }
            if (!closeCodeIsReconnect) {
                LOG.fatal("WebSocket connection was closed and cannot be recovered due to identification issues");
                LOG.fatal((Object)closeCode);
            }
            this.api.setStatus(JDA.Status.SHUTDOWN);
            this.api.getEventManager().handle(new ShutdownEvent(this.api, OffsetDateTime.now(), rawCloseCode));
        } else {
            if (isInvalidate) {
                this.invalidate();
            }
            this.api.getEventManager().handle(new DisconnectEvent(this.api, serverCloseFrame, clientCloseFrame, closedByServer, OffsetDateTime.now()));
            if (this.sessionId == null && this.reconnectQueue != null) {
                this.queueReconnect();
            } else {
                this.reconnect();
            }
        }
    }

    protected void queueReconnect() {
        if (!this.handleIdentifyRateLimit) {
            LOG.warn("Got disconnected from WebSocket (Internet?!)... Appending session to reconnect queue");
        }
        try {
            this.api.setStatus(JDA.Status.RECONNECT_QUEUED);
            this.reconnectQueue.appendSession(this);
        }
        catch (IllegalStateException ex) {
            LOG.fatal("Reconnect queue rejected session. Shutting down...");
            this.api.setStatus(JDA.Status.SHUTDOWN);
            this.api.getEventManager().handle(new ShutdownEvent(this.api, OffsetDateTime.now(), 1006));
        }
    }

    protected void reconnect() {
        this.reconnect(false, true);
    }

    protected void reconnect(boolean callFromQueue, boolean shouldHandleIdentify) {
        if (this.shutdown) {
            this.api.setStatus(JDA.Status.SHUTDOWN);
            this.api.getEventManager().handle(new ShutdownEvent(this.api, OffsetDateTime.now(), 1000));
            return;
        }
        if (!this.handleIdentifyRateLimit) {
            if (callFromQueue) {
                LOG.warn("Queue is attempting to reconnect a shard..." + (this.shardInfo != null ? " Shard: " + this.shardInfo.getShardString() : ""));
            } else {
                LOG.warn("Got disconnected from WebSocket (Internet?!)...");
            }
            LOG.warn("Attempting to reconnect in " + this.reconnectTimeoutS + "s");
        }
        while (this.shouldReconnect) {
            try {
                this.api.setStatus(JDA.Status.WAITING_TO_RECONNECT);
                if (this.handleIdentifyRateLimit && shouldHandleIdentify) {
                    LOG.fatal("Encountered IDENTIFY (OP 2) Rate Limit! Waiting 5 seconds before trying again!");
                    Thread.sleep(5000L);
                } else {
                    Thread.sleep(this.reconnectTimeoutS * 1000);
                }
                this.handleIdentifyRateLimit = false;
                this.api.setStatus(JDA.Status.ATTEMPTING_TO_RECONNECT);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            LOG.warn("Attempting to reconnect!");
            try {
                this.connect();
                break;
            }
            catch (RejectedExecutionException ex) {
                this.api.setStatus(JDA.Status.SHUTDOWN);
                this.api.getEventManager().handle(new ShutdownEvent(this.api, OffsetDateTime.now(), 1000));
                return;
            }
            catch (RuntimeException ex) {
                this.reconnectTimeoutS = Math.min(this.reconnectTimeoutS << 1, this.api.getMaxReconnectDelay());
                LOG.warn("Reconnect failed! Next attempt in " + this.reconnectTimeoutS + "s");
            }
        }
    }

    public void onTextMessage(WebSocket websocket, String message) {
        JSONObject content = new JSONObject(message);
        int opCode = content.getInt("op");
        if (!content.isNull("s")) {
            this.api.setResponseTotal(content.getInt("s"));
        }
        switch (opCode) {
            case 0: {
                this.handleEvent(content);
                break;
            }
            case 1: {
                LOG.debug("Got Keep-Alive request (OP 1). Sending response...");
                this.sendKeepAlive();
                break;
            }
            case 7: {
                LOG.debug("Got Reconnect request (OP 7). Closing connection now...");
                this.close();
                break;
            }
            case 9: {
                int closeCode;
                LOG.debug("Got Invalidate request (OP 9). Invalidating...");
                boolean isResume = content.getBoolean("d");
                int n = closeCode = isResume ? 4000 : 1000;
                if (isResume) {
                    LOG.debug("Session can be recovered... Closing and sending new RESUME request");
                } else {
                    this.invalidate();
                }
                this.close(closeCode, INVALIDATE_REASON);
                break;
            }
            case 10: {
                LOG.debug("Got HELLO packet (OP 10). Initializing keep-alive.");
                JSONObject data = content.getJSONObject("d");
                this.setupKeepAlive(data.getLong("heartbeat_interval"));
                if (data.isNull("_trace")) break;
                this.updateTraces(data.getJSONArray("_trace"), "HELLO", 10);
                break;
            }
            case 11: {
                LOG.trace("Got Heartbeat Ack (OP 11).");
                this.api.setPing(System.currentTimeMillis() - this.heartbeatStartTime);
                break;
            }
            default: {
                LOG.debug("Got unknown op-code: " + opCode + " with content: " + message);
            }
        }
    }

    protected void setupKeepAlive(long timeout) {
        this.keepAliveThread = new Thread(() -> {
            while (this.connected) {
                try {
                    this.sendKeepAlive();
                    Thread.sleep(timeout);
                }
                catch (InterruptedException ex) {
                    break;
                }
            }
        });
        this.keepAliveThread.setUncaughtExceptionHandler((thread, throwable) -> {
            this.handleCallbackError(this.socket, throwable);
            this.setupKeepAlive(timeout);
        });
        this.keepAliveThread.setName(this.api.getIdentifierString() + " MainWS-KeepAlive Thread");
        this.keepAliveThread.setPriority(10);
        this.keepAliveThread.setDaemon(true);
        this.keepAliveThread.start();
    }

    protected void sendKeepAlive() {
        String keepAlivePacket = new JSONObject().put("op", 1).put("d", this.api.getResponseTotal()).toString();
        if (!this.send(keepAlivePacket, true)) {
            this.ratelimitQueue.addLast(keepAlivePacket);
        }
        this.heartbeatStartTime = System.currentTimeMillis();
    }

    protected void sendIdentify() {
        LOG.debug("Sending Identify-packet...");
        PresenceImpl presenceObj = (PresenceImpl)this.api.getPresence();
        JSONObject connectionProperties = new JSONObject().put("$os", (Object)System.getProperty("os.name")).put("$browser", (Object)"JDA").put("$device", (Object)"JDA").put("$referring_domain", (Object)"").put("$referrer", (Object)"");
        JSONObject payload = new JSONObject().put("presence", (Object)presenceObj.getFullPresence()).put("token", (Object)this.getToken()).put("properties", (Object)connectionProperties).put("v", 6).put("large_threshold", 250).put("compress", true);
        JSONObject identify = new JSONObject().put("op", 2).put("d", (Object)payload);
        if (this.shardInfo != null) {
            payload.put("shard", (Object)new JSONArray().put(this.shardInfo.getShardId()).put(this.shardInfo.getShardTotal()));
        }
        this.send(identify.toString(), true);
        this.handleIdentifyRateLimit = true;
        this.sentAuthInfo = true;
    }

    protected void sendResume() {
        LOG.debug("Sending Resume-packet...");
        JSONObject resume = new JSONObject().put("op", 6).put("d", (Object)new JSONObject().put("session_id", (Object)this.sessionId).put("token", (Object)this.getToken()).put("seq", this.api.getResponseTotal()));
        this.send(resume.toString(), true);
        this.sentAuthInfo = true;
    }

    protected void invalidate() {
        this.sessionId = null;
        this.chunkingAndSyncing = false;
        this.sentAuthInfo = false;
        this.api.getTextChannelMap().clear();
        this.api.getVoiceChannelMap().clear();
        this.api.getCategoryMap().clear();
        this.api.getGuildMap().clear();
        this.api.getUserMap().clear();
        this.api.getPrivateChannelMap().clear();
        this.api.getFakeUserMap().clear();
        this.api.getFakePrivateChannelMap().clear();
        this.api.getEntityBuilder().clearCache();
        this.api.getEventCache().clear();
        this.api.getGuildLock().clear();
        ((ReadyHandler)this.getHandler("READY")).clearCache();
        ((GuildMembersChunkHandler)this.getHandler("GUILD_MEMBERS_CHUNK")).clearCache();
        if (this.api.getAccountType() == AccountType.CLIENT) {
            JDAClientImpl client = (JDAClientImpl)this.api.asClient();
            client.getRelationshipMap().clear();
            client.getGroupMap().clear();
            client.getCallUserMap().clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void updateAudioManagerReferences() {
        TLongObjectMap<AudioManagerImpl> managerMap = this.api.getAudioManagerMap();
        if (managerMap.size() > 0) {
            LOG.trace("Updating AudioManager references");
        }
        TLongObjectMap<AudioManagerImpl> tLongObjectMap = managerMap;
        synchronized (tLongObjectMap) {
            TLongObjectIterator it = managerMap.iterator();
            while (it.hasNext()) {
                it.advance();
                long guildId = it.key();
                AudioManagerImpl mng = (AudioManagerImpl)it.value();
                ConnectionListener listener = mng.getConnectionListener();
                GuildImpl guild = (GuildImpl)this.api.getGuildById(guildId);
                if (guild == null) {
                    this.queuedAudioConnections.remove(guildId);
                    if (listener != null) {
                        listener.onStatusChange(ConnectionStatus.DISCONNECTED_REMOVED_FROM_GUILD);
                    }
                    it.remove();
                    continue;
                }
                AudioManagerImpl newMng = new AudioManagerImpl(guild);
                newMng.setSelfMuted(mng.isSelfMuted());
                newMng.setSelfDeafened(mng.isSelfDeafened());
                newMng.setQueueTimeout(mng.getConnectTimeout());
                newMng.setSendingHandler(mng.getSendingHandler());
                newMng.setReceivingHandler(mng.getReceiveHandler());
                newMng.setConnectionListener(listener);
                newMng.setAutoReconnect(mng.isAutoReconnect());
                if (mng.isConnected() || mng.isAttemptingToConnect()) {
                    long channelId = mng.isConnected() ? mng.getConnectedChannel().getIdLong() : mng.getQueuedAudioConnection().getIdLong();
                    VoiceChannel channel = this.api.getVoiceChannelById(channelId);
                    if (channel != null) {
                        if (mng.isConnected()) {
                            mng.closeAudioConnection(ConnectionStatus.ERROR_CANNOT_RESUME);
                        }
                        newMng.setQueuedAudioConnection(channel);
                    } else {
                        this.queuedAudioConnections.remove(guildId);
                        if (listener != null) {
                            listener.onStatusChange(ConnectionStatus.DISCONNECTED_CHANNEL_DELETED);
                        }
                    }
                }
                it.setValue((Object)newMng);
            }
        }
    }

    protected String getToken() {
        if (this.api.getAccountType() == AccountType.BOT) {
            return this.api.getToken().substring("Bot ".length());
        }
        return this.api.getToken();
    }

    protected void handleEvent(JSONObject raw) {
        JSONObject content;
        String type = raw.getString("t");
        long responseTotal = this.api.getResponseTotal();
        if (type.equals("GUILD_MEMBER_ADD")) {
            ((GuildMembersChunkHandler)this.getHandler("GUILD_MEMBERS_CHUNK")).modifyExpectedGuildMember(raw.getJSONObject("d").getLong("guild_id"), 1);
        }
        if (type.equals("GUILD_MEMBER_REMOVE")) {
            ((GuildMembersChunkHandler)this.getHandler("GUILD_MEMBERS_CHUNK")).modifyExpectedGuildMember(raw.getJSONObject("d").getLong("guild_id"), -1);
        }
        if (!(!this.initiating || type.equals("READY") || type.equals("GUILD_MEMBERS_CHUNK") || type.equals("RESUMED") || type.equals("GUILD_SYNC") || !this.chunkingAndSyncing && type.equals("GUILD_CREATE"))) {
            content = raw.getJSONObject("d");
            if (!this.chunkingAndSyncing && type.equals("GUILD_DELETE") && content.has("unavailable") && content.getBoolean("unavailable")) {
                type = "GUILD_CREATE";
                raw.put("t", (Object)"GUILD_CREATE").put("jda-field", (Object)"This event was originally a GUILD_DELETE but was converted to GUILD_CREATE for WS init Guild streaming");
            } else {
                LOG.debug("Caching " + type + " event during init!");
                this.cachedEvents.add(raw);
                return;
            }
        }
        content = raw.getJSONObject("d");
        LOG.trace(String.format("%s -> %s", type, content.toString()));
        try {
            switch (type) {
                case "READY": {
                    this.processingReady = true;
                    this.handleIdentifyRateLimit = false;
                    this.sessionId = content.getString("session_id");
                    if (!content.isNull("_trace")) {
                        this.updateTraces(content.getJSONArray("_trace"), "READY", 0);
                    }
                    this.handlers.get("READY").handle(responseTotal, raw);
                    break;
                }
                case "RESUMED": {
                    if (!this.processingReady) {
                        this.initiating = false;
                        this.ready();
                    }
                    if (!content.isNull("_trace")) {
                        this.updateTraces(content.getJSONArray("_trace"), "RESUMED", 0);
                    }
                    break;
                }
                default: {
                    SocketHandler handler = this.handlers.get(type);
                    if (handler != null) {
                        handler.handle(responseTotal, raw);
                        break;
                    }
                    LOG.debug("Unrecognized event:\n" + raw);
                    break;
                }
            }
        }
        catch (JSONException ex) {
            LOG.warn("Got an unexpected Json-parse error. Please redirect following message to the devs:\n\t" + ex.getMessage() + "\n\t" + type + " -> " + content);
            LOG.warn((Object)ex);
        }
        catch (Exception ex) {
            LOG.fatal(ex);
        }
    }

    public void onBinaryMessage(WebSocket websocket, byte[] binary) throws UnsupportedEncodingException, DataFormatException {
        ByteArrayOutputStream out = new ByteArrayOutputStream(binary.length * 2);
        try (InflaterOutputStream decompressor = new InflaterOutputStream(out);){
            decompressor.write(binary);
        }
        catch (IOException e) {
            throw (DataFormatException)new DataFormatException("Malformed").initCause(e);
        }
        this.onTextMessage(websocket, out.toString("UTF-8"));
    }

    public void onUnexpectedError(WebSocket websocket, WebSocketException cause) throws Exception {
        this.handleCallbackError(websocket, cause);
    }

    public void handleCallbackError(WebSocket websocket, Throwable cause) {
        LOG.fatal(cause);
        this.api.getEventManager().handle(new ExceptionEvent(this.api, cause, true));
    }

    public void onThreadCreated(WebSocket websocket, ThreadType threadType, Thread thread) throws Exception {
        String identifier = this.api.getIdentifierString();
        switch (threadType) {
            case CONNECT_THREAD: {
                thread.setName(identifier + " MainWS-ConnectThread");
                break;
            }
            case FINISH_THREAD: {
                thread.setName(identifier + " MainWS-FinishThread");
                break;
            }
            case READING_THREAD: {
                thread.setName(identifier + " MainWS-ReadThread");
                break;
            }
            case WRITING_THREAD: {
                thread.setName(identifier + " MainWS-WriteThread");
                break;
            }
            default: {
                thread.setName(identifier + " MainWS-" + threadType);
            }
        }
    }

    public void setChunkingAndSyncing(boolean active) {
        this.chunkingAndSyncing = active;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void queueAudioReconnect(VoiceChannel channel) {
        try {
            this.audioQueueLock.acquire();
            long guildId = channel.getGuild().getIdLong();
            ConnectionRequest request = (ConnectionRequest)this.queuedAudioConnections.get(guildId);
            if (request == null) {
                request = new ConnectionRequest(channel, ConnectionStage.RECONNECT);
                this.queuedAudioConnections.put(guildId, (Object)request);
            } else {
                request.setStage(ConnectionStage.RECONNECT);
            }
            request.setChannel(channel);
        }
        catch (InterruptedException e) {
            LOG.fatal(e);
        }
        finally {
            this.audioQueueLock.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void queueAudioConnect(VoiceChannel channel) {
        try {
            this.audioQueueLock.acquire();
            long guildId = channel.getGuild().getIdLong();
            ConnectionRequest request = (ConnectionRequest)this.queuedAudioConnections.get(guildId);
            if (request == null) {
                request = new ConnectionRequest(channel, ConnectionStage.CONNECT);
                this.queuedAudioConnections.put(guildId, (Object)request);
            } else if (request.getStage() == ConnectionStage.DISCONNECT) {
                request.setStage(ConnectionStage.RECONNECT);
            }
            request.setChannel(channel);
        }
        catch (InterruptedException e) {
            LOG.fatal(e);
        }
        finally {
            this.audioQueueLock.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void queueAudioDisconnect(Guild guild) {
        try {
            this.audioQueueLock.acquire();
            long guildId = guild.getIdLong();
            ConnectionRequest request = (ConnectionRequest)this.queuedAudioConnections.get(guildId);
            if (request == null) {
                this.queuedAudioConnections.put(guildId, (Object)new ConnectionRequest(guild));
            } else {
                request.setStage(ConnectionStage.DISCONNECT);
            }
        }
        catch (InterruptedException e) {
            LOG.fatal(e);
        }
        finally {
            this.audioQueueLock.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ConnectionRequest removeAudioConnection(long guildId) {
        try {
            this.audioQueueLock.acquire();
            ConnectionRequest connectionRequest = (ConnectionRequest)this.queuedAudioConnections.remove(guildId);
            return connectionRequest;
        }
        catch (InterruptedException e) {
            LOG.fatal(e);
        }
        finally {
            this.audioQueueLock.release();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ConnectionRequest updateAudioConnection(long guildId, VoiceChannel connectedChannel) {
        try {
            this.audioQueueLock.acquire();
            ConnectionRequest connectionRequest = this.updateAudioConnection0(guildId, connectedChannel);
            return connectionRequest;
        }
        catch (InterruptedException e) {
            LOG.fatal(e);
        }
        finally {
            this.audioQueueLock.release();
        }
        return null;
    }

    public ConnectionRequest updateAudioConnection0(long guildId, VoiceChannel connectedChannel) {
        ConnectionRequest request = (ConnectionRequest)this.queuedAudioConnections.get(guildId);
        if (request == null) {
            return null;
        }
        ConnectionStage requestStage = request.getStage();
        if (connectedChannel == null) {
            switch (requestStage) {
                case DISCONNECT: {
                    return (ConnectionRequest)this.queuedAudioConnections.remove(guildId);
                }
                case RECONNECT: {
                    request.setStage(ConnectionStage.CONNECT);
                    request.setNextAttemptEpoch(System.currentTimeMillis());
                }
            }
            return null;
        }
        if (requestStage == ConnectionStage.CONNECT && request.getChannel().getIdLong() == connectedChannel.getIdLong()) {
            return (ConnectionRequest)this.queuedAudioConnections.remove(guildId);
        }
        return null;
    }

    protected ConnectionRequest getNextAudioConnectRequest() {
        if (!this.isReady()) {
            return null;
        }
        long now = System.currentTimeMillis();
        TLongObjectIterator it = this.queuedAudioConnections.iterator();
        while (it.hasNext()) {
            it.advance();
            ConnectionRequest audioRequest = (ConnectionRequest)it.value();
            if (audioRequest.getNextAttemptEpoch() >= now) continue;
            Guild guild = this.api.getGuildById(audioRequest.getGuildIdLong());
            if (guild == null) {
                it.remove();
                continue;
            }
            ConnectionListener listener = guild.getAudioManager().getConnectionListener();
            if (audioRequest.getStage() != ConnectionStage.DISCONNECT) {
                VoiceChannel channel = guild.getVoiceChannelById(audioRequest.getChannel().getIdLong());
                if (channel == null) {
                    it.remove();
                    if (listener == null) continue;
                    listener.onStatusChange(ConnectionStatus.DISCONNECTED_CHANNEL_DELETED);
                    continue;
                }
                if (!guild.getSelfMember().hasPermission((Channel)channel, Permission.VOICE_CONNECT)) {
                    it.remove();
                    if (listener == null) continue;
                    listener.onStatusChange(ConnectionStatus.DISCONNECTED_LOST_PERMISSION);
                    continue;
                }
            }
            return audioRequest;
        }
        return null;
    }

    public Map<String, SocketHandler> getHandlers() {
        return this.handlers;
    }

    public <T> T getHandler(String type) {
        return (T)this.handlers.get(type);
    }

    private void setupHandlers() {
        this.handlers.put("CHANNEL_CREATE", new ChannelCreateHandler(this.api));
        this.handlers.put("CHANNEL_DELETE", new ChannelDeleteHandler(this.api));
        this.handlers.put("CHANNEL_UPDATE", new ChannelUpdateHandler(this.api));
        this.handlers.put("GUILD_BAN_ADD", new GuildBanHandler(this.api, true));
        this.handlers.put("GUILD_BAN_REMOVE", new GuildBanHandler(this.api, false));
        this.handlers.put("GUILD_CREATE", new GuildCreateHandler(this.api));
        this.handlers.put("GUILD_DELETE", new GuildDeleteHandler(this.api));
        this.handlers.put("GUILD_EMOJIS_UPDATE", new GuildEmojisUpdateHandler(this.api));
        this.handlers.put("GUILD_MEMBER_ADD", new GuildMemberAddHandler(this.api));
        this.handlers.put("GUILD_MEMBER_REMOVE", new GuildMemberRemoveHandler(this.api));
        this.handlers.put("GUILD_MEMBER_UPDATE", new GuildMemberUpdateHandler(this.api));
        this.handlers.put("GUILD_MEMBERS_CHUNK", new GuildMembersChunkHandler(this.api));
        this.handlers.put("GUILD_ROLE_CREATE", new GuildRoleCreateHandler(this.api));
        this.handlers.put("GUILD_ROLE_DELETE", new GuildRoleDeleteHandler(this.api));
        this.handlers.put("GUILD_ROLE_UPDATE", new GuildRoleUpdateHandler(this.api));
        this.handlers.put("GUILD_SYNC", new GuildSyncHandler(this.api));
        this.handlers.put("GUILD_UPDATE", new GuildUpdateHandler(this.api));
        this.handlers.put("MESSAGE_CREATE", new MessageCreateHandler(this.api));
        this.handlers.put("MESSAGE_DELETE", new MessageDeleteHandler(this.api));
        this.handlers.put("MESSAGE_DELETE_BULK", new MessageBulkDeleteHandler(this.api));
        this.handlers.put("MESSAGE_REACTION_ADD", new MessageReactionHandler(this.api, true));
        this.handlers.put("MESSAGE_REACTION_REMOVE", new MessageReactionHandler(this.api, false));
        this.handlers.put("MESSAGE_REACTION_REMOVE_ALL", new MessageReactionBulkRemoveHandler(this.api));
        this.handlers.put("MESSAGE_UPDATE", new MessageUpdateHandler(this.api));
        this.handlers.put("PRESENCE_UPDATE", new PresenceUpdateHandler(this.api));
        this.handlers.put("READY", new ReadyHandler(this.api));
        this.handlers.put("TYPING_START", new TypingStartHandler(this.api));
        this.handlers.put("USER_UPDATE", new UserUpdateHandler(this.api));
        this.handlers.put("VOICE_SERVER_UPDATE", new VoiceServerUpdateHandler(this.api));
        this.handlers.put("VOICE_STATE_UPDATE", new VoiceStateUpdateHandler(this.api));
        this.handlers.put("CHANNEL_PINS_UPDATE", new SocketHandler.NOPHandler(this.api));
        this.handlers.put("WEBHOOKS_UPDATE", new SocketHandler.NOPHandler(this.api));
        if (this.api.getAccountType() == AccountType.CLIENT) {
            this.handlers.put("CALL_CREATE", new CallCreateHandler(this.api));
            this.handlers.put("CALL_DELETE", new CallDeleteHandler(this.api));
            this.handlers.put("CALL_UPDATE", new CallUpdateHandler(this.api));
            this.handlers.put("CHANNEL_RECIPIENT_ADD", new ChannelRecipientAddHandler(this.api));
            this.handlers.put("CHANNEL_RECIPIENT_REMOVE", new ChannelRecipientRemoveHandler(this.api));
            this.handlers.put("RELATIONSHIP_ADD", new RelationshipAddHandler(this.api));
            this.handlers.put("RELATIONSHIP_REMOVE", new RelationshipRemoveHandler(this.api));
            this.handlers.put("MESSAGE_ACK", new SocketHandler.NOPHandler(this.api));
        }
    }
}

