/*
 * Decompiled with CFR 0.152.
 */
package net.dv8tion.jda.core.requests;

import java.io.IOException;
import java.io.InputStream;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.zip.GZIPInputStream;
import net.dv8tion.jda.core.AccountType;
import net.dv8tion.jda.core.JDA;
import net.dv8tion.jda.core.JDAInfo;
import net.dv8tion.jda.core.entities.impl.JDAImpl;
import net.dv8tion.jda.core.requests.RateLimiter;
import net.dv8tion.jda.core.requests.Request;
import net.dv8tion.jda.core.requests.Response;
import net.dv8tion.jda.core.requests.Route;
import net.dv8tion.jda.core.requests.ratelimit.BotRateLimiter;
import net.dv8tion.jda.core.requests.ratelimit.ClientRateLimiter;
import net.dv8tion.jda.core.utils.SimpleLog;
import okhttp3.Call;
import okhttp3.MediaType;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.internal.http.HttpMethod;

public class Requester {
    public static final SimpleLog LOG = SimpleLog.getLog(Requester.class);
    public static final String DISCORD_API_PREFIX = String.format("https://discordapp.com/api/v%d/", 6);
    public static final String USER_AGENT = "DiscordBot (https://github.com/DV8FromTheWorld/JDA, " + JDAInfo.VERSION + ")";
    public static final MediaType MEDIA_TYPE_JSON = MediaType.parse((String)"application/json; charset=utf-8");
    public static final RequestBody EMPTY_BODY = RequestBody.create(null, (byte[])new byte[0]);
    private final JDAImpl api;
    private final RateLimiter rateLimiter;
    private final OkHttpClient httpClient;

    public Requester(JDA api) {
        this(api, api.getAccountType());
    }

    public Requester(JDA api, AccountType accountType) {
        if (accountType == null) {
            throw new NullPointerException("Provided accountType was null!");
        }
        this.api = (JDAImpl)api;
        this.rateLimiter = accountType == AccountType.BOT ? new BotRateLimiter(this, 5) : new ClientRateLimiter(this, 5);
        this.httpClient = this.api.getHttpClientBuilder().build();
    }

    public JDAImpl getJDA() {
        return this.api;
    }

    public <T> void request(Request<T> apiRequest) {
        if (this.rateLimiter.isShutdown) {
            throw new IllegalStateException("The Requester has been shutdown! No new requests can be requested!");
        }
        if (apiRequest.shouldQueue()) {
            this.rateLimiter.queueRequest(apiRequest);
        } else {
            this.execute(apiRequest, true);
        }
    }

    public Long execute(Request<?> apiRequest) {
        return this.execute(apiRequest, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Long execute(Request<?> apiRequest, boolean handleOnRatelimit) {
        Long l;
        Route.CompiledRoute route = apiRequest.getRoute();
        Long retryAfter = this.rateLimiter.getRateLimit(route);
        if (retryAfter != null) {
            if (handleOnRatelimit) {
                apiRequest.handleResponse(new Response(retryAfter, Collections.emptySet()));
            }
            return retryAfter;
        }
        Request.Builder builder = new Request.Builder();
        String url = DISCORD_API_PREFIX + route.getCompiledRoute();
        builder.url(url);
        String method = apiRequest.getRoute().getMethod().toString();
        RequestBody body = apiRequest.getBody();
        if (body == null && HttpMethod.requiresRequestBody((String)method)) {
            body = EMPTY_BODY;
        }
        builder.method(method, body).header("user-agent", USER_AGENT).header("accept-encoding", "gzip");
        if (url.startsWith(DISCORD_API_PREFIX) && this.api.getToken() != null) {
            builder.header("authorization", this.api.getToken());
        }
        if (apiRequest.getHeaders() != null) {
            for (Map.Entry header : apiRequest.getHeaders().entrySet()) {
                builder.addHeader((String)header.getKey(), (String)header.getValue());
            }
        }
        okhttp3.Request request = builder.build();
        LinkedHashSet<String> rays = new LinkedHashSet<String>();
        okhttp3.Response[] responses = new okhttp3.Response[4];
        okhttp3.Response firstSuccess = null;
        try {
            int attempt = 0;
            do {
                if (apiRequest.isCanceled()) {
                    l = null;
                    return l;
                }
                Call call = this.httpClient.newCall(request);
                responses[attempt] = firstSuccess = call.execute();
                String cfRay = firstSuccess.header("CF-RAY");
                if (cfRay != null) {
                    rays.add(cfRay);
                }
                if (firstSuccess.code() < 500) break;
                LOG.debug(String.format("Requesting %s -> %s returned status %d... retrying (attempt %d)", apiRequest.getRoute().getMethod().toString(), url, firstSuccess.code(), ++attempt));
                try {
                    Thread.sleep(50 * attempt);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            } while (attempt < 3 && firstSuccess.code() >= 500);
            if (firstSuccess.code() >= 500) {
                l = null;
                return l;
            }
            retryAfter = this.rateLimiter.handleResponse(route, firstSuccess);
            if (!rays.isEmpty()) {
                LOG.debug("Received response with following cf-rays: " + rays);
            }
            if (retryAfter == null) {
                apiRequest.handleResponse(new Response(firstSuccess, -1L, rays));
            } else if (handleOnRatelimit) {
                apiRequest.handleResponse(new Response(firstSuccess, retryAfter, rays));
            }
            l = retryAfter;
            return l;
        }
        catch (Exception e) {
            LOG.fatal(e);
            apiRequest.handleResponse(new Response(firstSuccess, e, rays));
            l = null;
            return l;
        }
        finally {
            for (okhttp3.Response r : responses) {
                if (r == null) break;
                r.close();
            }
        }
    }

    public OkHttpClient getHttpClient() {
        return this.httpClient;
    }

    public RateLimiter getRateLimiter() {
        return this.rateLimiter;
    }

    public void shutdown(long time, TimeUnit unit) {
        this.rateLimiter.shutdown(time, unit);
    }

    public void shutdownNow() {
        this.rateLimiter.forceShutdown();
    }

    public static InputStream getBody(okhttp3.Response response) throws IOException {
        String encoding = response.header("content-encoding", "");
        if (encoding.equals("gzip")) {
            return new GZIPInputStream(response.body().byteStream());
        }
        return response.body().byteStream();
    }
}

