/*
 * Decompiled with CFR 0.152.
 */
package net.dv8tion.jda.core.handle;

import net.dv8tion.jda.client.entities.impl.GroupImpl;
import net.dv8tion.jda.client.events.message.group.GroupMessageReceivedEvent;
import net.dv8tion.jda.core.entities.Message;
import net.dv8tion.jda.core.entities.MessageType;
import net.dv8tion.jda.core.entities.impl.JDAImpl;
import net.dv8tion.jda.core.entities.impl.PrivateChannelImpl;
import net.dv8tion.jda.core.entities.impl.TextChannelImpl;
import net.dv8tion.jda.core.events.message.MessageReceivedEvent;
import net.dv8tion.jda.core.events.message.guild.GuildMessageReceivedEvent;
import net.dv8tion.jda.core.events.message.priv.PrivateMessageReceivedEvent;
import net.dv8tion.jda.core.handle.EventCache;
import net.dv8tion.jda.core.handle.SocketHandler;
import net.dv8tion.jda.core.requests.WebSocketClient;
import org.json.JSONObject;

public class MessageCreateHandler
extends SocketHandler {
    public MessageCreateHandler(JDAImpl api) {
        super(api);
    }

    @Override
    protected Long handleInternally(JSONObject content) {
        MessageType type = MessageType.fromId(content.getInt("type"));
        switch (type) {
            case DEFAULT: {
                return this.handleDefaultMessage(content);
            }
        }
        WebSocketClient.LOG.debug("JDA received a message of unknown type. Type: " + (Object)((Object)type) + "  JSON: " + content);
        return null;
    }

    private Long handleDefaultMessage(JSONObject content) {
        Message message;
        try {
            message = this.api.getEntityBuilder().createMessage(content, true);
        }
        catch (IllegalArgumentException e) {
            switch (e.getMessage()) {
                case "MISSING_CHANNEL": {
                    long channelId = content.getLong("channel_id");
                    this.api.getEventCache().cache(EventCache.Type.CHANNEL, channelId, () -> this.handle(this.responseNumber, this.allContent));
                    EventCache.LOG.debug("Received a message for a channel that JDA does not currently have cached");
                    return null;
                }
                case "MISSING_USER": {
                    long authorId = content.getJSONObject("author").getLong("id");
                    this.api.getEventCache().cache(EventCache.Type.USER, authorId, () -> this.handle(this.responseNumber, this.allContent));
                    EventCache.LOG.debug("Received a message for a user that JDA does not currently have cached");
                    return null;
                }
            }
            throw e;
        }
        switch (message.getChannelType()) {
            case TEXT: {
                TextChannelImpl channel = (TextChannelImpl)message.getTextChannel();
                if (this.api.getGuildLock().isLocked(channel.getGuild().getIdLong())) {
                    return channel.getGuild().getIdLong();
                }
                channel.setLastMessageId(message.getIdLong());
                this.api.getEventManager().handle(new GuildMessageReceivedEvent(this.api, this.responseNumber, message));
                break;
            }
            case PRIVATE: {
                PrivateChannelImpl channel = (PrivateChannelImpl)message.getPrivateChannel();
                channel.setLastMessageId(message.getIdLong());
                this.api.getEventManager().handle(new PrivateMessageReceivedEvent(this.api, this.responseNumber, message));
                break;
            }
            case GROUP: {
                GroupImpl channel = (GroupImpl)message.getGroup();
                channel.setLastMessageId(message.getIdLong());
                this.api.getEventManager().handle(new GroupMessageReceivedEvent(this.api, this.responseNumber, message));
                break;
            }
            default: {
                WebSocketClient.LOG.warn("Received a MESSAGE_CREATE with a unknown MessageChannel ChannelType. JSON: " + content);
                return null;
            }
        }
        this.api.getEventManager().handle(new MessageReceivedEvent(this.api, this.responseNumber, message));
        return null;
    }
}

