/*
 * Decompiled with CFR 0.152.
 */
package net.dv8tion.jda.core.handle;

import net.dv8tion.jda.core.entities.Role;
import net.dv8tion.jda.core.entities.impl.GuildImpl;
import net.dv8tion.jda.core.entities.impl.JDAImpl;
import net.dv8tion.jda.core.events.role.RoleCreateEvent;
import net.dv8tion.jda.core.handle.EventCache;
import net.dv8tion.jda.core.handle.SocketHandler;
import org.json.JSONObject;

public class GuildRoleCreateHandler
extends SocketHandler {
    public GuildRoleCreateHandler(JDAImpl api) {
        super(api);
    }

    @Override
    protected Long handleInternally(JSONObject content) {
        long guildId = content.getLong("guild_id");
        if (this.api.getGuildLock().isLocked(guildId)) {
            return guildId;
        }
        GuildImpl guild = (GuildImpl)this.api.getGuildMap().get(guildId);
        if (guild == null) {
            this.api.getEventCache().cache(EventCache.Type.GUILD, guildId, () -> this.handle(this.responseNumber, this.allContent));
            EventCache.LOG.debug("GUILD_ROLE_CREATE was received for a Guild that is not yet cached: " + content);
            return null;
        }
        Role newRole = this.api.getEntityBuilder().createRole(content.getJSONObject("role"), guild.getIdLong());
        this.api.getEventManager().handle(new RoleCreateEvent(this.api, this.responseNumber, newRole));
        this.api.getEventCache().playbackCache(EventCache.Type.ROLE, newRole.getIdLong());
        return null;
    }
}

