/*
 * Decompiled with CFR 0.152.
 */
package net.dv8tion.jda.core.handle;

import gnu.trove.TLongCollection;
import gnu.trove.iterator.TLongIterator;
import gnu.trove.map.TLongObjectMap;
import gnu.trove.set.hash.TLongHashSet;
import net.dv8tion.jda.client.entities.Group;
import net.dv8tion.jda.client.entities.Relationship;
import net.dv8tion.jda.client.entities.RelationshipType;
import net.dv8tion.jda.client.entities.impl.JDAClientImpl;
import net.dv8tion.jda.core.AccountType;
import net.dv8tion.jda.core.audio.hooks.ConnectionStatus;
import net.dv8tion.jda.core.entities.Category;
import net.dv8tion.jda.core.entities.Guild;
import net.dv8tion.jda.core.entities.TextChannel;
import net.dv8tion.jda.core.entities.VoiceChannel;
import net.dv8tion.jda.core.entities.impl.GuildImpl;
import net.dv8tion.jda.core.entities.impl.JDAImpl;
import net.dv8tion.jda.core.entities.impl.PrivateChannelImpl;
import net.dv8tion.jda.core.entities.impl.UserImpl;
import net.dv8tion.jda.core.events.guild.GuildLeaveEvent;
import net.dv8tion.jda.core.events.guild.GuildUnavailableEvent;
import net.dv8tion.jda.core.handle.EventCache;
import net.dv8tion.jda.core.handle.SocketHandler;
import net.dv8tion.jda.core.managers.impl.AudioManagerImpl;
import org.json.JSONObject;

public class GuildDeleteHandler
extends SocketHandler {
    public GuildDeleteHandler(JDAImpl api) {
        super(api);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected Long handleInternally(JSONObject content) {
        TLongObjectMap<AudioManagerImpl> audioManagerMap;
        long id = content.getLong("id");
        GuildImpl guild = (GuildImpl)this.api.getGuildMap().get(id);
        if (guild == null) {
            this.api.getEventCache().cache(EventCache.Type.GUILD, id, () -> this.handle(this.responseNumber, this.allContent));
            EventCache.LOG.debug("Received GUILD_DELETE for a Guild that is not currently cached. ID: " + id);
            return null;
        }
        if (!guild.isAvailable() && content.has("unavailable") && content.getBoolean("unavailable")) {
            return null;
        }
        if (this.api.getGuildLock().isLocked(id)) {
            return id;
        }
        if (content.has("unavailable") && content.getBoolean("unavailable")) {
            guild.setAvailable(false);
            this.api.getEventManager().handle(new GuildUnavailableEvent(this.api, this.responseNumber, guild));
            return null;
        }
        this.api.getClient().removeAudioConnection(id);
        TLongObjectMap<AudioManagerImpl> tLongObjectMap = audioManagerMap = this.api.getAudioManagerMap();
        synchronized (tLongObjectMap) {
            AudioManagerImpl manager = (AudioManagerImpl)audioManagerMap.get(id);
            if (manager != null) {
                manager.closeAudioConnection(ConnectionStatus.DISCONNECTED_REMOVED_FROM_GUILD);
            }
            audioManagerMap.remove(id);
        }
        TLongHashSet memberIds = new TLongHashSet((TLongCollection)guild.getMembersMap().keySet());
        for (Guild guildI : this.api.getGuilds()) {
            GuildImpl g = (GuildImpl)guildI;
            if (g.equals(guild)) continue;
            TLongIterator it = memberIds.iterator();
            while (it.hasNext()) {
                if (!g.getMembersMap().containsKey(it.next())) continue;
                it.remove();
            }
        }
        if (this.api.getAccountType() == AccountType.CLIENT) {
            TLongObjectMap<Relationship> relationships = ((JDAClientImpl)this.api.asClient()).getRelationshipMap();
            TLongIterator it = memberIds.iterator();
            while (it.hasNext()) {
                Relationship rel = (Relationship)relationships.get(it.next());
                if (rel == null || rel.getType() != RelationshipType.FRIEND) continue;
                it.remove();
            }
        }
        long selfId = this.api.getSelfUser().getIdLong();
        memberIds.forEach(memberId -> {
            if (memberId == selfId) {
                return true;
            }
            UserImpl user = (UserImpl)this.api.getUserMap().remove(memberId);
            if (user.hasPrivateChannel()) {
                PrivateChannelImpl priv = (PrivateChannelImpl)user.getPrivateChannel();
                user.setFake(true);
                priv.setFake(true);
                this.api.getFakeUserMap().put(user.getIdLong(), (Object)user);
                this.api.getFakePrivateChannelMap().put(priv.getIdLong(), (Object)priv);
            } else if (this.api.getAccountType() == AccountType.CLIENT) {
                for (Group grp : this.api.asClient().getGroups()) {
                    if (!grp.getNonFriendUsers().contains(user)) continue;
                    user.setFake(true);
                    this.api.getFakeUserMap().put(user.getIdLong(), (Object)user);
                    break;
                }
            }
            this.api.getEventCache().clear(EventCache.Type.USER, memberId);
            return true;
        });
        this.api.getGuildMap().remove(id);
        guild.getTextChannelCache().forEach(chan -> {
            TextChannel cfr_ignored_0 = (TextChannel)this.api.getTextChannelMap().remove(chan.getIdLong());
        });
        guild.getVoiceChannelCache().forEach(chan -> {
            VoiceChannel cfr_ignored_0 = (VoiceChannel)this.api.getVoiceChannelMap().remove(chan.getIdLong());
        });
        guild.getCategoryCache().forEach(chan -> {
            Category cfr_ignored_0 = (Category)this.api.getCategoryMap().remove(chan.getIdLong());
        });
        this.api.getEventManager().handle(new GuildLeaveEvent(this.api, this.responseNumber, guild));
        this.api.getEventCache().clear(EventCache.Type.GUILD, id);
        return null;
    }
}

