/*
 * Decompiled with CFR 0.152.
 */
package net.dv8tion.jda.core.entities.impl;

import gnu.trove.map.TLongObjectMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import net.dv8tion.jda.core.entities.Category;
import net.dv8tion.jda.core.entities.Channel;
import net.dv8tion.jda.core.entities.ChannelType;
import net.dv8tion.jda.core.entities.Invite;
import net.dv8tion.jda.core.entities.Member;
import net.dv8tion.jda.core.entities.TextChannel;
import net.dv8tion.jda.core.entities.VoiceChannel;
import net.dv8tion.jda.core.entities.impl.AbstractChannelImpl;
import net.dv8tion.jda.core.entities.impl.GuildImpl;
import net.dv8tion.jda.core.requests.RestAction;
import net.dv8tion.jda.core.requests.restaction.InviteAction;
import net.dv8tion.jda.core.utils.Checks;
import net.dv8tion.jda.core.utils.MiscUtil;

public class CategoryImpl
extends AbstractChannelImpl<CategoryImpl>
implements Category {
    protected final TLongObjectMap<Channel> channels = MiscUtil.newLongMap();

    public CategoryImpl(long id, GuildImpl guild) {
        super(id, guild);
    }

    @Override
    public Category getParent() {
        return null;
    }

    @Override
    public int compareTo(Category other) {
        Checks.notNull(other, "Other Category");
        if (other.equals(this)) {
            return 0;
        }
        Checks.check(this.getGuild().equals(other.getGuild()), "Cannot compare categories from different guilds!");
        if (this.rawPosition == other.getPositionRaw()) {
            return Long.compare(this.id, other.getIdLong());
        }
        return Integer.compare(this.rawPosition, other.getPositionRaw());
    }

    @Override
    public ChannelType getType() {
        return ChannelType.CATEGORY;
    }

    @Override
    public List<Member> getMembers() {
        return Collections.unmodifiableList(this.getChannels().stream().map(Channel::getMembers).flatMap(Collection::stream).distinct().collect(Collectors.toList()));
    }

    @Override
    public int getPosition() {
        List<Category> channels = this.guild.getCategories();
        for (int i = 0; i < channels.size(); ++i) {
            if (channels.get(i) != this) continue;
            return i;
        }
        throw new AssertionError((Object)"Somehow when determining position we never found the Category in the Guild's channels? wtf?");
    }

    @Override
    public InviteAction createInvite() {
        throw new UnsupportedOperationException("Cannot create invites for category!");
    }

    @Override
    public RestAction<List<Invite>> getInvites() {
        return new RestAction.EmptyRestAction<List<Invite>>(this.getJDA(), Collections.emptyList());
    }

    @Override
    public List<Channel> getChannels() {
        ArrayList<Comparable<TextChannel>> channels = new ArrayList<Comparable<TextChannel>>();
        channels.addAll(this.getTextChannels());
        channels.addAll(this.getVoiceChannels());
        return Collections.unmodifiableList(channels);
    }

    @Override
    public List<TextChannel> getTextChannels() {
        return Collections.unmodifiableList(this.getGuild().getTextChannels().stream().filter(channel -> channel.getParent() != null).filter(channel -> channel.getParent().equals(this)).collect(Collectors.toList()));
    }

    @Override
    public List<VoiceChannel> getVoiceChannels() {
        return Collections.unmodifiableList(this.getGuild().getVoiceChannels().stream().filter(channel -> channel.getParent() != null).filter(channel -> channel.getParent().equals(this)).collect(Collectors.toList()));
    }

    public String toString() {
        return "GC:" + this.getName() + '(' + this.id + ')';
    }
}

