/*
 * Decompiled with CFR 0.152.
 */
package net.dv8tion.jda.core.entities.impl;

import gnu.trove.map.TLongObjectMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import net.dv8tion.jda.core.JDA;
import net.dv8tion.jda.core.Permission;
import net.dv8tion.jda.core.entities.Category;
import net.dv8tion.jda.core.entities.Channel;
import net.dv8tion.jda.core.entities.EntityBuilder;
import net.dv8tion.jda.core.entities.Guild;
import net.dv8tion.jda.core.entities.Invite;
import net.dv8tion.jda.core.entities.Member;
import net.dv8tion.jda.core.entities.PermissionOverride;
import net.dv8tion.jda.core.entities.Role;
import net.dv8tion.jda.core.entities.impl.GuildImpl;
import net.dv8tion.jda.core.exceptions.InsufficientPermissionException;
import net.dv8tion.jda.core.managers.ChannelManager;
import net.dv8tion.jda.core.managers.ChannelManagerUpdatable;
import net.dv8tion.jda.core.requests.Request;
import net.dv8tion.jda.core.requests.Response;
import net.dv8tion.jda.core.requests.RestAction;
import net.dv8tion.jda.core.requests.Route;
import net.dv8tion.jda.core.requests.restaction.AuditableRestAction;
import net.dv8tion.jda.core.requests.restaction.InviteAction;
import net.dv8tion.jda.core.requests.restaction.PermissionOverrideAction;
import net.dv8tion.jda.core.utils.Checks;
import net.dv8tion.jda.core.utils.MiscUtil;
import org.json.JSONArray;

public abstract class AbstractChannelImpl<T extends AbstractChannelImpl<T>>
implements Channel {
    protected final long id;
    protected final GuildImpl guild;
    protected final TLongObjectMap<PermissionOverride> overrides = MiscUtil.newLongMap();
    protected final Object mngLock = new Object();
    protected volatile ChannelManager manager;
    protected volatile ChannelManagerUpdatable managerUpdatable;
    protected long parentId;
    protected String name;
    protected int rawPosition;

    public AbstractChannelImpl(long id, GuildImpl guild) {
        this.id = id;
        this.guild = guild;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public Guild getGuild() {
        return this.guild;
    }

    @Override
    public Category getParent() {
        return (Category)this.guild.getCategoriesMap().get(this.parentId);
    }

    @Override
    public int getPositionRaw() {
        return this.rawPosition;
    }

    @Override
    public JDA getJDA() {
        return this.getGuild().getJDA();
    }

    @Override
    public PermissionOverride getPermissionOverride(Member member) {
        return member != null ? (PermissionOverride)this.overrides.get(member.getUser().getIdLong()) : null;
    }

    @Override
    public PermissionOverride getPermissionOverride(Role role) {
        return role != null ? (PermissionOverride)this.overrides.get(role.getIdLong()) : null;
    }

    @Override
    public List<PermissionOverride> getPermissionOverrides() {
        return Arrays.asList(this.overrides.values((Object[])new PermissionOverride[this.overrides.size()]));
    }

    @Override
    public List<PermissionOverride> getMemberPermissionOverrides() {
        return Collections.unmodifiableList(this.getPermissionOverrides().stream().filter(PermissionOverride::isMemberOverride).collect(Collectors.toList()));
    }

    @Override
    public List<PermissionOverride> getRolePermissionOverrides() {
        return Collections.unmodifiableList(this.getPermissionOverrides().stream().filter(PermissionOverride::isRoleOverride).collect(Collectors.toList()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ChannelManager getManager() {
        ChannelManager mng = this.manager;
        if (mng == null) {
            Object object = this.mngLock;
            synchronized (object) {
                mng = this.manager;
                if (mng == null) {
                    mng = this.manager = new ChannelManager(this);
                }
            }
        }
        return mng;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ChannelManagerUpdatable getManagerUpdatable() {
        ChannelManagerUpdatable mng = this.managerUpdatable;
        if (mng == null) {
            Object object = this.mngLock;
            synchronized (object) {
                mng = this.managerUpdatable;
                if (mng == null) {
                    mng = this.managerUpdatable = new ChannelManagerUpdatable(this);
                }
            }
        }
        return mng;
    }

    @Override
    public AuditableRestAction<Void> delete() {
        this.checkPermission(Permission.MANAGE_CHANNEL);
        Route.CompiledRoute route = Route.Channels.DELETE_CHANNEL.compile(this.getId());
        return new AuditableRestAction<Void>(this.getJDA(), route){

            @Override
            protected void handleResponse(Response response, Request<Void> request) {
                if (response.isOk()) {
                    request.onSuccess(null);
                } else {
                    request.onFailure(response);
                }
            }
        };
    }

    @Override
    public PermissionOverrideAction createPermissionOverride(Member member) {
        this.checkPermission(Permission.MANAGE_PERMISSIONS);
        Checks.notNull(member, "member");
        if (!this.guild.equals(member.getGuild())) {
            throw new IllegalArgumentException("Provided member is not from the same guild as this channel!");
        }
        if (this.overrides.containsKey(member.getUser().getIdLong())) {
            throw new IllegalStateException("Provided member already has a PermissionOverride in this channel!");
        }
        Route.CompiledRoute route = Route.Channels.CREATE_PERM_OVERRIDE.compile(this.getId(), member.getUser().getId());
        return new PermissionOverrideAction(this.getJDA(), route, (Channel)this, member);
    }

    @Override
    public PermissionOverrideAction createPermissionOverride(Role role) {
        this.checkPermission(Permission.MANAGE_PERMISSIONS);
        Checks.notNull(role, "role");
        if (!this.guild.equals(role.getGuild())) {
            throw new IllegalArgumentException("Provided role is not from the same guild as this channel!");
        }
        if (this.overrides.containsKey(role.getIdLong())) {
            throw new IllegalStateException("Provided role already has a PermissionOverride in this channel!");
        }
        Route.CompiledRoute route = Route.Channels.CREATE_PERM_OVERRIDE.compile(this.getId(), role.getId());
        return new PermissionOverrideAction(this.getJDA(), route, (Channel)this, role);
    }

    @Override
    public InviteAction createInvite() {
        if (!this.guild.getSelfMember().hasPermission((Channel)this, Permission.CREATE_INSTANT_INVITE)) {
            throw new InsufficientPermissionException(Permission.CREATE_INSTANT_INVITE);
        }
        return new InviteAction(this.getJDA(), this.getId());
    }

    @Override
    public RestAction<List<Invite>> getInvites() {
        if (!this.guild.getSelfMember().hasPermission((Channel)this, Permission.MANAGE_CHANNEL)) {
            throw new InsufficientPermissionException(Permission.MANAGE_CHANNEL);
        }
        Route.CompiledRoute route = Route.Invites.GET_CHANNEL_INVITES.compile(this.getId());
        return new RestAction<List<Invite>>(this.getJDA(), route){

            @Override
            protected void handleResponse(Response response, Request<List<Invite>> request) {
                if (response.isOk()) {
                    EntityBuilder entityBuilder = this.api.getEntityBuilder();
                    JSONArray array = response.getArray();
                    ArrayList<Invite> invites = new ArrayList<Invite>(array.length());
                    for (int i = 0; i < array.length(); ++i) {
                        invites.add(entityBuilder.createInvite(array.getJSONObject(i)));
                    }
                    request.onSuccess(invites);
                } else {
                    request.onFailure(response);
                }
            }
        };
    }

    @Override
    public long getIdLong() {
        return this.id;
    }

    public int hashCode() {
        return Long.hashCode(this.id);
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof Channel)) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        Channel channel = (Channel)obj;
        return channel.getIdLong() == this.getIdLong();
    }

    public TLongObjectMap<PermissionOverride> getOverrideMap() {
        return this.overrides;
    }

    public T setName(String name) {
        this.name = name;
        return (T)this;
    }

    public T setParent(long parentId) {
        this.parentId = parentId;
        return (T)this;
    }

    public T setRawPosition(int rawPosition) {
        this.rawPosition = rawPosition;
        return (T)this;
    }

    protected void checkPermission(Permission permission) {
        this.checkPermission(permission, null);
    }

    protected void checkPermission(Permission permission, String message) {
        if (!this.guild.getSelfMember().hasPermission((Channel)this, permission)) {
            if (message != null) {
                throw new InsufficientPermissionException(permission, message);
            }
            throw new InsufficientPermissionException(permission);
        }
    }
}

