/*
 * Decompiled with CFR 0.152.
 */
package net.dv8tion.jda.core.entities;

import java.io.File;
import java.io.InputStream;
import java.util.Collections;
import java.util.Formattable;
import java.util.Formatter;
import java.util.LinkedList;
import java.util.List;
import javax.annotation.CheckReturnValue;
import net.dv8tion.jda.core.AccountType;
import net.dv8tion.jda.core.JDA;
import net.dv8tion.jda.core.MessageBuilder;
import net.dv8tion.jda.core.entities.ChannelType;
import net.dv8tion.jda.core.entities.Emote;
import net.dv8tion.jda.core.entities.EntityBuilder;
import net.dv8tion.jda.core.entities.ISnowflake;
import net.dv8tion.jda.core.entities.Message;
import net.dv8tion.jda.core.entities.MessageEmbed;
import net.dv8tion.jda.core.entities.MessageHistory;
import net.dv8tion.jda.core.entities.impl.MessageImpl;
import net.dv8tion.jda.core.exceptions.AccountTypeException;
import net.dv8tion.jda.core.requests.Request;
import net.dv8tion.jda.core.requests.Response;
import net.dv8tion.jda.core.requests.RestAction;
import net.dv8tion.jda.core.requests.Route;
import net.dv8tion.jda.core.requests.restaction.AuditableRestAction;
import net.dv8tion.jda.core.requests.restaction.pagination.MessagePaginationAction;
import net.dv8tion.jda.core.utils.Checks;
import net.dv8tion.jda.core.utils.MiscUtil;
import okhttp3.MediaType;
import okhttp3.MultipartBody;
import okhttp3.RequestBody;
import org.json.JSONArray;
import org.json.JSONObject;

public interface MessageChannel
extends ISnowflake,
Formattable {
    default public String getLatestMessageId() {
        return Long.toUnsignedString(this.getLatestMessageIdLong());
    }

    public long getLatestMessageIdLong();

    public boolean hasLatestMessage();

    public String getName();

    public ChannelType getType();

    public JDA getJDA();

    @CheckReturnValue
    default public RestAction<Message> sendMessage(String text) {
        Checks.notEmpty(text, "Provided text for message");
        Checks.check(text.length() <= 2000, "Provided text for message must be less than 2000 characters in length");
        return this.sendMessage(new MessageBuilder().append(text).build());
    }

    @CheckReturnValue
    default public RestAction<Message> sendMessageFormat(String format, Object ... args) {
        Checks.notEmpty(format, "Format");
        return this.sendMessage(new MessageBuilder().appendFormat(format, args).build());
    }

    @CheckReturnValue
    default public RestAction<Message> sendMessage(MessageEmbed embed) {
        Checks.notNull(embed, "Provided embed");
        return this.sendMessage(new MessageBuilder().setEmbed(embed).build());
    }

    @CheckReturnValue
    default public RestAction<Message> sendMessage(Message msg) {
        Checks.notNull(msg, "Message");
        if (!msg.getEmbeds().isEmpty()) {
            AccountType type = this.getJDA().getAccountType();
            MessageEmbed embed = msg.getEmbeds().get(0);
            Checks.check(embed.isSendable(type), "Provided Message contains an embed with a length greater than %d characters, which is the max for %s accounts!", new Object[]{type == AccountType.BOT ? 4000 : 2000, type});
        }
        Route.CompiledRoute route = Route.Messages.SEND_MESSAGE.compile(this.getId());
        JSONObject json = ((MessageImpl)msg).toJSONObject();
        return new RestAction<Message>(this.getJDA(), route, json){

            @Override
            protected void handleResponse(Response response, Request<Message> request) {
                if (response.isOk()) {
                    Message m = this.api.getEntityBuilder().createMessage(response.getObject(), MessageChannel.this, false);
                    request.onSuccess(m);
                } else {
                    request.onFailure(response);
                }
            }
        };
    }

    @CheckReturnValue
    default public RestAction<Message> sendFile(File file, Message message) {
        Checks.notNull(file, "file");
        return this.sendFile(file, file.getName(), message);
    }

    @CheckReturnValue
    default public RestAction<Message> sendFile(File file, String fileName, Message message) {
        Checks.notNull(file, "file");
        Checks.check(file.exists() && file.canRead(), "Provided file is either null, doesn't exist or is not readable!");
        Checks.check(file.length() <= 0x800000L, "File is to big! Max file-size is 8MB");
        Checks.notNull(fileName, "fileName");
        Route.CompiledRoute route = Route.Messages.SEND_MESSAGE.compile(this.getId());
        MultipartBody.Builder builder = new MultipartBody.Builder().setType(MultipartBody.FORM);
        builder.addFormDataPart("file", fileName, RequestBody.create((MediaType)MediaType.parse((String)"application/octet-stream"), (File)file));
        if (message != null) {
            if (!message.getEmbeds().isEmpty()) {
                AccountType type = this.getJDA().getAccountType();
                MessageEmbed embed = message.getEmbeds().get(0);
                Checks.check(embed.isSendable(type), "Provided Message contains an embed with a length greater than %d characters, which is the max for %s accounts!", new Object[]{type == AccountType.BOT ? 4000 : 2000, type});
            }
            builder.addFormDataPart("payload_json", ((MessageImpl)message).toJSONObject().toString());
        }
        return new RestAction<Message>(this.getJDA(), route, (RequestBody)builder.build()){

            @Override
            protected void handleResponse(Response response, Request<Message> request) {
                if (response.isOk()) {
                    request.onSuccess(this.api.getEntityBuilder().createMessage(response.getObject(), MessageChannel.this, false));
                } else {
                    request.onFailure(response);
                }
            }
        };
    }

    @CheckReturnValue
    default public RestAction<Message> sendFile(InputStream data, String fileName, Message message) {
        Checks.notNull(data, "data InputStream");
        Checks.notNull(fileName, "fileName");
        Route.CompiledRoute route = Route.Messages.SEND_MESSAGE.compile(this.getId());
        MultipartBody.Builder builder = new MultipartBody.Builder().setType(MultipartBody.FORM);
        builder.addFormDataPart("file", fileName, MiscUtil.createRequestBody(MediaType.parse((String)"application/octet-stream"), data));
        if (message != null) {
            if (!message.getEmbeds().isEmpty()) {
                AccountType type = this.getJDA().getAccountType();
                MessageEmbed embed = message.getEmbeds().get(0);
                Checks.check(embed.isSendable(type), "Provided Message contains an embed with a length greater than %d characters, which is the max for %s accounts!", new Object[]{type == AccountType.BOT ? 4000 : 2000, type});
            }
            builder.addFormDataPart("payload_json", ((MessageImpl)message).toJSONObject().toString());
        }
        return new RestAction<Message>(this.getJDA(), route, (RequestBody)builder.build()){

            @Override
            protected void handleResponse(Response response, Request<Message> request) {
                if (response.isOk()) {
                    request.onSuccess(this.api.getEntityBuilder().createMessage(response.getObject(), MessageChannel.this, false));
                } else {
                    request.onFailure(response);
                }
            }
        };
    }

    @CheckReturnValue
    default public RestAction<Message> sendFile(byte[] data, String fileName, Message message) {
        Checks.notNull(data, "file data[]");
        Checks.notNull(fileName, "fileName");
        Checks.check(data.length <= 0x800000, "Provided data is too large! Max file-size is 8MB (%d)", (Object)0x800000);
        Route.CompiledRoute route = Route.Messages.SEND_MESSAGE.compile(this.getId());
        MultipartBody.Builder builder = new MultipartBody.Builder().setType(MultipartBody.FORM).addFormDataPart("file", fileName, RequestBody.create((MediaType)MediaType.parse((String)"application/octet-stream"), (byte[])data));
        if (message != null) {
            if (!message.getEmbeds().isEmpty()) {
                AccountType type = this.getJDA().getAccountType();
                MessageEmbed embed = message.getEmbeds().get(0);
                Checks.check(embed.isSendable(type), "Provided Message contains an embed with a length greater than %d characters, which is the max for %s accounts!", new Object[]{type == AccountType.BOT ? 4000 : 2000, type});
            }
            builder.addFormDataPart("payload_json", ((MessageImpl)message).toJSONObject().toString());
        }
        return new RestAction<Message>(this.getJDA(), route, (RequestBody)builder.build()){

            @Override
            protected void handleResponse(Response response, Request<Message> request) {
                if (response.isOk()) {
                    request.onSuccess(this.api.getEntityBuilder().createMessage(response.getObject(), MessageChannel.this, false));
                } else {
                    request.onFailure(response);
                }
            }
        };
    }

    @CheckReturnValue
    default public RestAction<Message> getMessageById(String messageId) {
        if (this.getJDA().getAccountType() != AccountType.BOT) {
            throw new AccountTypeException(AccountType.BOT);
        }
        Checks.notEmpty(messageId, "Provided messageId");
        Route.CompiledRoute route = Route.Messages.GET_MESSAGE.compile(this.getId(), messageId);
        return new RestAction<Message>(this.getJDA(), route){

            @Override
            protected void handleResponse(Response response, Request<Message> request) {
                if (response.isOk()) {
                    Message m = this.api.getEntityBuilder().createMessage(response.getObject(), MessageChannel.this, false);
                    request.onSuccess(m);
                } else {
                    request.onFailure(response);
                }
            }
        };
    }

    @CheckReturnValue
    default public RestAction<Message> getMessageById(long messageId) {
        return this.getMessageById(Long.toUnsignedString(messageId));
    }

    @CheckReturnValue
    default public AuditableRestAction<Void> deleteMessageById(String messageId) {
        Checks.notEmpty(messageId, "messageId");
        Route.CompiledRoute route = Route.Messages.DELETE_MESSAGE.compile(this.getId(), messageId);
        return new AuditableRestAction<Void>(this.getJDA(), route){

            @Override
            protected void handleResponse(Response response, Request<Void> request) {
                if (response.isOk()) {
                    request.onSuccess(null);
                } else {
                    request.onFailure(response);
                }
            }
        };
    }

    @CheckReturnValue
    default public AuditableRestAction<Void> deleteMessageById(long messageId) {
        return this.deleteMessageById(Long.toUnsignedString(messageId));
    }

    default public MessageHistory getHistory() {
        return new MessageHistory(this);
    }

    @CheckReturnValue
    default public MessagePaginationAction getIterableHistory() {
        return new MessagePaginationAction(this);
    }

    @CheckReturnValue
    default public RestAction<MessageHistory> getHistoryAround(Message message, int limit) {
        Checks.notNull(message, "Provided target message");
        Checks.check(message.getChannel().equals(this), "The provided Message is not from the MessageChannel!");
        return this.getHistoryAround(message.getId(), limit);
    }

    @CheckReturnValue
    default public RestAction<MessageHistory> getHistoryAround(String messageId, int limit) {
        Checks.notEmpty(messageId, "Provided messageId");
        Checks.check(limit >= 1 && limit <= 100, "Provided limit was out of bounds. Minimum: 1, Max: 100. Provided: %d", (Object)limit);
        Route.CompiledRoute route = Route.Messages.GET_MESSAGE_HISTORY.compile(this.getId()).withQueryParams("limit", Integer.toString(limit), "around", messageId);
        return new RestAction<MessageHistory>(this.getJDA(), route){

            @Override
            protected void handleResponse(Response response, Request<MessageHistory> request) {
                if (!response.isOk()) {
                    request.onFailure(response);
                    return;
                }
                MessageHistory mHistory = new MessageHistory(MessageChannel.this);
                EntityBuilder builder = this.api.getEntityBuilder();
                LinkedList<Message> msgs = new LinkedList<Message>();
                JSONArray historyJson = response.getArray();
                for (int i = 0; i < historyJson.length(); ++i) {
                    msgs.add(builder.createMessage(historyJson.getJSONObject(i), MessageChannel.this, false));
                }
                msgs.forEach(msg -> {
                    Message cfr_ignored_0 = (Message)mHistory.history.put((Object)msg.getIdLong(), msg);
                });
                request.onSuccess(mHistory);
            }
        };
    }

    @CheckReturnValue
    default public RestAction<MessageHistory> getHistoryAround(long messageId, int limit) {
        return this.getHistoryAround(Long.toUnsignedString(messageId), limit);
    }

    @CheckReturnValue
    default public RestAction<Void> sendTyping() {
        Route.CompiledRoute route = Route.Channels.SEND_TYPING.compile(this.getId());
        return new RestAction<Void>(this.getJDA(), route){

            @Override
            protected void handleResponse(Response response, Request<Void> request) {
                if (response.isOk()) {
                    request.onSuccess(null);
                } else {
                    request.onFailure(response);
                }
            }
        };
    }

    @CheckReturnValue
    default public RestAction<Void> addReactionById(String messageId, String unicode) {
        Checks.notEmpty(messageId, "MessageId");
        Checks.notEmpty(unicode, "Provided Unicode");
        Checks.noWhitespace(unicode, "Provided Unicode");
        String encoded = MiscUtil.encodeUTF8(unicode);
        Route.CompiledRoute route = Route.Messages.ADD_REACTION.compile(this.getId(), messageId, encoded);
        return new RestAction<Void>(this.getJDA(), route){

            @Override
            protected void handleResponse(Response response, Request<Void> request) {
                if (response.isOk()) {
                    request.onSuccess(null);
                } else {
                    request.onFailure(response);
                }
            }
        };
    }

    @CheckReturnValue
    default public RestAction<Void> addReactionById(long messageId, String unicode) {
        return this.addReactionById(Long.toUnsignedString(messageId), unicode);
    }

    @CheckReturnValue
    default public RestAction<Void> addReactionById(String messageId, Emote emote) {
        Checks.notEmpty(messageId, "MessageId");
        Checks.notNull(emote, "Emote");
        Route.CompiledRoute route = Route.Messages.ADD_REACTION.compile(this.getId(), messageId, String.format("%s:%s", emote.getName(), emote.getId()));
        return new RestAction<Void>(this.getJDA(), route){

            @Override
            protected void handleResponse(Response response, Request<Void> request) {
                if (response.isOk()) {
                    request.onSuccess(null);
                } else {
                    request.onFailure(response);
                }
            }
        };
    }

    @CheckReturnValue
    default public RestAction<Void> addReactionById(long messageId, Emote emote) {
        return this.addReactionById(Long.toUnsignedString(messageId), emote);
    }

    @CheckReturnValue
    default public RestAction<Void> pinMessageById(String messageId) {
        Checks.notEmpty(messageId, "messageId");
        Route.CompiledRoute route = Route.Messages.ADD_PINNED_MESSAGE.compile(this.getId(), messageId);
        return new RestAction<Void>(this.getJDA(), route){

            @Override
            protected void handleResponse(Response response, Request<Void> request) {
                if (response.isOk()) {
                    request.onSuccess(null);
                } else {
                    request.onFailure(response);
                }
            }
        };
    }

    @CheckReturnValue
    default public RestAction<Void> pinMessageById(long messageId) {
        return this.pinMessageById(Long.toUnsignedString(messageId));
    }

    @CheckReturnValue
    default public RestAction<Void> unpinMessageById(String messageId) {
        Checks.notEmpty(messageId, "messageId");
        Route.CompiledRoute route = Route.Messages.REMOVE_PINNED_MESSAGE.compile(this.getId(), messageId);
        return new RestAction<Void>(this.getJDA(), route){

            @Override
            protected void handleResponse(Response response, Request<Void> request) {
                if (response.isOk()) {
                    request.onSuccess(null);
                } else {
                    request.onFailure(response);
                }
            }
        };
    }

    @CheckReturnValue
    default public RestAction<Void> unpinMessageById(long messageId) {
        return this.unpinMessageById(Long.toUnsignedString(messageId));
    }

    @CheckReturnValue
    default public RestAction<List<Message>> getPinnedMessages() {
        Route.CompiledRoute route = Route.Messages.GET_PINNED_MESSAGES.compile(this.getId());
        return new RestAction<List<Message>>(this.getJDA(), route){

            @Override
            protected void handleResponse(Response response, Request<List<Message>> request) {
                if (response.isOk()) {
                    LinkedList<Message> pinnedMessages = new LinkedList<Message>();
                    EntityBuilder builder = this.api.getEntityBuilder();
                    JSONArray pins = response.getArray();
                    for (int i = 0; i < pins.length(); ++i) {
                        pinnedMessages.add(builder.createMessage(pins.getJSONObject(i), MessageChannel.this, false));
                    }
                    request.onSuccess(Collections.unmodifiableList(pinnedMessages));
                } else {
                    request.onFailure(response);
                }
            }
        };
    }

    @CheckReturnValue
    default public RestAction<Message> editMessageById(String messageId, String newContent) {
        Checks.notEmpty(newContent, "Provided message content");
        Checks.check(newContent.length() <= 2000, "Provided newContent length must be 2000 or less characters.");
        return this.editMessageById(messageId, new MessageBuilder().append(newContent).build());
    }

    @CheckReturnValue
    default public RestAction<Message> editMessageById(String messageId, Message newContent) {
        Checks.notEmpty(messageId, "messageId");
        Checks.notNull(newContent, "message");
        if (!newContent.getEmbeds().isEmpty()) {
            AccountType type = this.getJDA().getAccountType();
            MessageEmbed embed = newContent.getEmbeds().get(0);
            Checks.check(embed.isSendable(type), "Provided Message contains an embed with a length greater than %d characters, which is the max for %s accounts!", new Object[]{type == AccountType.BOT ? 4000 : 2000, type});
        }
        JSONObject json = ((MessageImpl)newContent).toJSONObject();
        Route.CompiledRoute route = Route.Messages.EDIT_MESSAGE.compile(this.getId(), messageId);
        return new RestAction<Message>(this.getJDA(), route, json){

            @Override
            protected void handleResponse(Response response, Request<Message> request) {
                if (response.isOk()) {
                    Message m = this.api.getEntityBuilder().createMessage(response.getObject(), MessageChannel.this, false);
                    request.onSuccess(m);
                } else {
                    request.onFailure(response);
                }
            }
        };
    }

    @CheckReturnValue
    default public RestAction<Message> editMessageFormatById(String messageId, String format, Object ... args) {
        Checks.notBlank(format, "Format String");
        return this.editMessageById(messageId, new MessageBuilder().appendFormat(format, args).build());
    }

    @CheckReturnValue
    default public RestAction<Message> editMessageFormatById(long messageId, String format, Object ... args) {
        Checks.notBlank(format, "Format String");
        return this.editMessageById(messageId, new MessageBuilder().appendFormat(format, args).build());
    }

    @CheckReturnValue
    default public RestAction<Message> editMessageById(long messageId, Message newContent) {
        return this.editMessageById(Long.toUnsignedString(messageId), newContent);
    }

    @CheckReturnValue
    default public RestAction<Message> editMessageById(String messageId, MessageEmbed newEmbed) {
        return this.editMessageById(messageId, new MessageBuilder().setEmbed(newEmbed).build());
    }

    @CheckReturnValue
    default public RestAction<Message> editMessageById(long messageId, MessageEmbed newEmbed) {
        return this.editMessageById(Long.toUnsignedString(messageId), newEmbed);
    }

    @Override
    default public void formatTo(Formatter formatter, int flags, int width, int precision) {
        String out;
        boolean leftJustified = (flags & 1) == 1;
        boolean upper = (flags & 2) == 2;
        boolean alt = (flags & 4) == 4;
        String string = out = upper ? this.getName().toUpperCase(formatter.locale()) : this.getName();
        if (alt) {
            out = "#" + out;
        }
        MiscUtil.appendTo(formatter, width, precision, leftJustified, out);
    }
}

