/*
 * Decompiled with CFR 0.152.
 */
package net.dv8tion.jda.core.entities;

import java.io.File;
import java.io.InputStream;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.time.OffsetDateTime;
import java.util.Formattable;
import java.util.List;
import javax.annotation.CheckReturnValue;
import net.dv8tion.jda.client.entities.Group;
import net.dv8tion.jda.core.JDA;
import net.dv8tion.jda.core.entities.Category;
import net.dv8tion.jda.core.entities.ChannelType;
import net.dv8tion.jda.core.entities.Emote;
import net.dv8tion.jda.core.entities.Guild;
import net.dv8tion.jda.core.entities.ISnowflake;
import net.dv8tion.jda.core.entities.Member;
import net.dv8tion.jda.core.entities.MessageChannel;
import net.dv8tion.jda.core.entities.MessageEmbed;
import net.dv8tion.jda.core.entities.MessageReaction;
import net.dv8tion.jda.core.entities.MessageType;
import net.dv8tion.jda.core.entities.PrivateChannel;
import net.dv8tion.jda.core.entities.Role;
import net.dv8tion.jda.core.entities.TextChannel;
import net.dv8tion.jda.core.entities.User;
import net.dv8tion.jda.core.entities.impl.JDAImpl;
import net.dv8tion.jda.core.requests.Requester;
import net.dv8tion.jda.core.requests.RestAction;
import net.dv8tion.jda.core.requests.restaction.AuditableRestAction;
import okhttp3.Request;
import okhttp3.Response;

public interface Message
extends ISnowflake,
Formattable {
    public static final int MAX_FILE_SIZE = 0x800000;

    public List<User> getMentionedUsers();

    public boolean isMentioned(User var1);

    public List<TextChannel> getMentionedChannels();

    public List<Role> getMentionedRoles();

    public boolean mentionsEveryone();

    public boolean isEdited();

    public OffsetDateTime getEditedTime();

    public User getAuthor();

    public Member getMember();

    public String getContent();

    public String getRawContent();

    public String getStrippedContent();

    public boolean isFromType(ChannelType var1);

    public ChannelType getChannelType();

    public boolean isWebhookMessage();

    public MessageChannel getChannel();

    public PrivateChannel getPrivateChannel();

    public Group getGroup();

    public TextChannel getTextChannel();

    public Category getCategory();

    public Guild getGuild();

    public List<Attachment> getAttachments();

    public List<MessageEmbed> getEmbeds();

    public List<Emote> getEmotes();

    public List<MessageReaction> getReactions();

    public boolean isTTS();

    @CheckReturnValue
    public RestAction<Message> editMessage(String var1);

    @CheckReturnValue
    public RestAction<Message> editMessage(MessageEmbed var1);

    @CheckReturnValue
    public RestAction<Message> editMessageFormat(String var1, Object ... var2);

    @CheckReturnValue
    public RestAction<Message> editMessage(Message var1);

    @CheckReturnValue
    public AuditableRestAction<Void> delete();

    public JDA getJDA();

    public boolean isPinned();

    @CheckReturnValue
    public RestAction<Void> pin();

    @CheckReturnValue
    public RestAction<Void> unpin();

    @CheckReturnValue
    public RestAction<Void> addReaction(Emote var1);

    @CheckReturnValue
    public RestAction<Void> addReaction(String var1);

    @CheckReturnValue
    public RestAction<Void> clearReactions();

    public MessageType getType();

    public static class Attachment {
        private final String id;
        private final String url;
        private final String proxyUrl;
        private final String fileName;
        private final int size;
        private final int height;
        private final int width;
        private final JDAImpl jda;

        public Attachment(String id, String url, String proxyUrl, String fileName, int size, int height, int width, JDA jda) {
            this.id = id;
            this.url = url;
            this.proxyUrl = proxyUrl;
            this.fileName = fileName;
            this.size = size;
            this.height = height;
            this.width = width;
            this.jda = (JDAImpl)jda;
        }

        public String getId() {
            return this.id;
        }

        public String getUrl() {
            return this.url;
        }

        public String getProxyUrl() {
            return this.proxyUrl;
        }

        public String getFileName() {
            return this.fileName;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean download(File file) {
            InputStream in = null;
            try {
                Request request = new Request.Builder().addHeader("user-agent", Requester.USER_AGENT).url(this.getUrl()).build();
                Response response = this.jda.getRequester().getHttpClient().newCall(request).execute();
                in = response.body().byteStream();
                Files.copy(in, Paths.get(file.getAbsolutePath(), new String[0]), new CopyOption[0]);
                boolean bl = true;
                return bl;
            }
            catch (Exception e) {
                JDAImpl.LOG.fatal(e);
            }
            finally {
                if (in != null) {
                    try {
                        in.close();
                    }
                    catch (Exception exception) {}
                }
            }
            return false;
        }

        public int getSize() {
            return this.size;
        }

        public int getHeight() {
            return this.height;
        }

        public int getWidth() {
            return this.width;
        }

        public boolean isImage() {
            return this.height > 0 && this.width > 0;
        }
    }
}

