/*
 * Decompiled with CFR 0.152.
 */
package net.dv8tion.jda.client.requests.restaction.pagination;

import java.util.LinkedList;
import java.util.List;
import net.dv8tion.jda.core.JDA;
import net.dv8tion.jda.core.entities.EntityBuilder;
import net.dv8tion.jda.core.entities.Guild;
import net.dv8tion.jda.core.entities.Message;
import net.dv8tion.jda.core.requests.Request;
import net.dv8tion.jda.core.requests.Response;
import net.dv8tion.jda.core.requests.Route;
import net.dv8tion.jda.core.requests.restaction.pagination.PaginationAction;
import org.json.JSONArray;

public class MentionPaginationAction
extends PaginationAction<Message, MentionPaginationAction> {
    protected final Guild guild;
    protected boolean isEveryone = true;
    protected boolean isRole = true;

    public MentionPaginationAction(JDA api) {
        this(api, (Guild)null);
    }

    public MentionPaginationAction(Guild guild) {
        this(guild.getJDA(), guild);
    }

    private MentionPaginationAction(JDA api, Guild guild) {
        super(api, Route.Self.GET_RECENT_MENTIONS.compile(new String[0]), 1, 100, 100);
        this.guild = guild;
    }

    public Guild getGuild() {
        return this.guild;
    }

    public MentionPaginationAction setEveryone(boolean isEveryoneMention) {
        this.isEveryone = isEveryoneMention;
        return this;
    }

    public MentionPaginationAction setRole(boolean isRoleMention) {
        this.isRole = isRoleMention;
        return this;
    }

    @Override
    protected Route.CompiledRoute finalizeRoute() {
        Route.CompiledRoute route = super.finalizeRoute();
        String limit = String.valueOf(super.getLimit());
        String before = this.last != null ? ((Message)this.last).getId() : null;
        String everyone = String.valueOf(this.isEveryone);
        String role = String.valueOf(this.isRole);
        route = route.withQueryParams("limit", limit, "roles", role, "everyone", everyone);
        if (this.guild != null) {
            route = route.withQueryParams("guild_id", this.guild.getId());
        }
        if (before != null) {
            route = route.withQueryParams("before", before);
        }
        return route;
    }

    @Override
    protected void handleResponse(Response response, Request<List<Message>> request) {
        if (!response.isOk()) {
            request.onFailure(response);
            return;
        }
        EntityBuilder builder = this.api.getEntityBuilder();
        LinkedList<Message> mentions = new LinkedList<Message>();
        JSONArray arr = response.getArray();
        for (int i = 0; i < arr.length(); ++i) {
            Message msg = builder.createMessage(arr.getJSONObject(i), false);
            mentions.add(msg);
            if (this.useCache) {
                this.cached.add(msg);
            }
            this.last = msg;
        }
        request.onSuccess(mentions);
    }
}

