/*
 * Decompiled with CFR 0.152.
 */
package net.dv8tion.jda.client.handle;

import net.dv8tion.jda.client.entities.Group;
import net.dv8tion.jda.client.entities.Relationship;
import net.dv8tion.jda.client.entities.RelationshipType;
import net.dv8tion.jda.client.entities.impl.JDAClientImpl;
import net.dv8tion.jda.client.events.relationship.FriendRemovedEvent;
import net.dv8tion.jda.client.events.relationship.FriendRequestCanceledEvent;
import net.dv8tion.jda.client.events.relationship.FriendRequestIgnoredEvent;
import net.dv8tion.jda.client.events.relationship.UserUnblockedEvent;
import net.dv8tion.jda.core.entities.User;
import net.dv8tion.jda.core.entities.impl.GuildImpl;
import net.dv8tion.jda.core.entities.impl.JDAImpl;
import net.dv8tion.jda.core.entities.impl.PrivateChannelImpl;
import net.dv8tion.jda.core.entities.impl.UserImpl;
import net.dv8tion.jda.core.handle.EventCache;
import net.dv8tion.jda.core.handle.SocketHandler;
import net.dv8tion.jda.core.requests.WebSocketClient;
import org.json.JSONObject;

public class RelationshipRemoveHandler
extends SocketHandler {
    public RelationshipRemoveHandler(JDAImpl api) {
        super(api);
    }

    @Override
    protected Long handleInternally(JSONObject content) {
        long userId = content.getLong("id");
        RelationshipType type = RelationshipType.fromKey(content.getInt("type"));
        if (type == RelationshipType.NO_RELATIONSHIP) {
            return null;
        }
        Relationship relationship = this.api.asClient().getRelationshipById(userId, type);
        if (relationship == null) {
            this.api.getEventCache().cache(EventCache.Type.RELATIONSHIP, userId, () -> this.handle(this.responseNumber, this.allContent));
            EventCache.LOG.debug("Received a RELATIONSHIP_REMOVE for a relationship that was not yet cached! JSON: " + content);
            return null;
        }
        ((JDAClientImpl)this.api.asClient()).getRelationshipMap().remove(userId);
        if (relationship.getType() == RelationshipType.FRIEND) {
            if (this.api.getGuildMap().valueCollection().stream().noneMatch(g -> ((GuildImpl)g).getMembersMap().containsKey(userId))) {
                UserImpl user = (UserImpl)this.api.getUserMap().remove(userId);
                if (user.hasPrivateChannel()) {
                    PrivateChannelImpl priv = (PrivateChannelImpl)user.getPrivateChannel();
                    user.setFake(true);
                    priv.setFake(true);
                    this.api.getFakeUserMap().put(user.getIdLong(), (Object)user);
                    this.api.getFakePrivateChannelMap().put(priv.getIdLong(), (Object)priv);
                } else {
                    for (Group grp : this.api.asClient().getGroups()) {
                        if (!grp.getNonFriendUsers().contains(user)) continue;
                        user.setFake(true);
                        this.api.getFakeUserMap().put(user.getIdLong(), (Object)user);
                        break;
                    }
                }
                this.api.getEventCache().clear(EventCache.Type.USER, userId);
            }
        } else {
            User user = relationship.getUser();
            if (user.isFake() && !user.hasPrivateChannel() && this.api.asClient().getGroups().stream().noneMatch(g -> g.getUsers().contains(user))) {
                this.api.getFakeUserMap().remove(userId);
            }
        }
        switch (type) {
            case FRIEND: {
                this.api.getEventManager().handle(new FriendRemovedEvent(this.api, this.responseNumber, relationship));
                break;
            }
            case BLOCKED: {
                this.api.getEventManager().handle(new UserUnblockedEvent(this.api, this.responseNumber, relationship));
                break;
            }
            case INCOMING_FRIEND_REQUEST: {
                this.api.getEventManager().handle(new FriendRequestIgnoredEvent(this.api, this.responseNumber, relationship));
                break;
            }
            case OUTGOING_FRIEND_REQUEST: {
                this.api.getEventManager().handle(new FriendRequestCanceledEvent(this.api, this.responseNumber, relationship));
                break;
            }
            default: {
                WebSocketClient.LOG.warn("Received a RELATIONSHIP_REMOVE with an unknown RelationshipType! JSON: " + content);
                return null;
            }
        }
        this.api.getEventCache().clear(EventCache.Type.RELATIONSHIP, userId);
        return null;
    }
}

