/*
 * Decompiled with CFR 0.152.
 */
package net.dongliu.apk.parser.utils;

import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import net.dongliu.apk.parser.utils.Unsigned;

public class Buffers {
    public static short readUByte(ByteBuffer buffer) {
        byte b = buffer.get();
        return (short)(b & 0xFF);
    }

    public static int readUShort(ByteBuffer buffer) {
        short s = buffer.getShort();
        return s & 0xFFFF;
    }

    public static long readUInt(ByteBuffer buffer) {
        int i = buffer.getInt();
        return (long)i & 0xFFFFFFFFL;
    }

    public static byte[] readBytes(ByteBuffer buffer, int size) {
        byte[] bytes = new byte[size];
        buffer.get(bytes);
        return bytes;
    }

    public static byte[] readBytes(ByteBuffer buffer) {
        return Buffers.readBytes(buffer, buffer.remaining());
    }

    public static String readAsciiString(ByteBuffer buffer, int strLen) {
        byte[] bytes = new byte[strLen];
        buffer.get(bytes);
        return new String(bytes);
    }

    public static String readString(ByteBuffer buffer, int strLen) {
        StringBuilder sb = new StringBuilder(strLen);
        for (int i = 0; i < strLen; ++i) {
            sb.append(buffer.getChar());
        }
        return sb.toString();
    }

    public static String readZeroTerminatedString(ByteBuffer buffer, int strLen) {
        StringBuilder sb = new StringBuilder(strLen);
        for (int i = 0; i < strLen; ++i) {
            char c = buffer.getChar();
            if (c == '\u0000') {
                Buffers.skip(buffer, (strLen - i - 1) * 2);
                break;
            }
            sb.append(c);
        }
        return sb.toString();
    }

    public static void skip(ByteBuffer buffer, int count) {
        Buffers.position(buffer, buffer.position() + count);
    }

    public static void position(ByteBuffer buffer, int position) {
        ((Buffer)buffer).position(position);
    }

    public static void position(ByteBuffer buffer, long position) {
        Buffers.position(buffer, Unsigned.ensureUInt(position));
    }

    public static ByteBuffer sliceAndSkip(ByteBuffer buffer, int size) {
        ByteBuffer buf = buffer.slice().order(ByteOrder.LITTLE_ENDIAN);
        ByteBuffer slice = (ByteBuffer)((Buffer)buf).limit(buf.position() + size);
        Buffers.skip(buffer, size);
        return slice;
    }
}

