/*
 * Decompiled with CFR 0.152.
 */
package net.dongliu.apk.parser.parser;

import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.HashSet;
import java.util.Locale;
import java.util.Set;
import net.dongliu.apk.parser.exception.ParserException;
import net.dongliu.apk.parser.struct.ChunkHeader;
import net.dongliu.apk.parser.struct.StringPool;
import net.dongliu.apk.parser.struct.StringPoolHeader;
import net.dongliu.apk.parser.struct.resource.LibraryEntry;
import net.dongliu.apk.parser.struct.resource.LibraryHeader;
import net.dongliu.apk.parser.struct.resource.NullHeader;
import net.dongliu.apk.parser.struct.resource.PackageHeader;
import net.dongliu.apk.parser.struct.resource.ResTableConfig;
import net.dongliu.apk.parser.struct.resource.ResourcePackage;
import net.dongliu.apk.parser.struct.resource.ResourceTable;
import net.dongliu.apk.parser.struct.resource.ResourceTableHeader;
import net.dongliu.apk.parser.struct.resource.Type;
import net.dongliu.apk.parser.struct.resource.TypeHeader;
import net.dongliu.apk.parser.struct.resource.TypeSpec;
import net.dongliu.apk.parser.struct.resource.TypeSpecHeader;
import net.dongliu.apk.parser.utils.Buffers;
import net.dongliu.apk.parser.utils.Pair;
import net.dongliu.apk.parser.utils.ParseUtils;

public class ResourceTableParser {
    private ByteOrder byteOrder = ByteOrder.LITTLE_ENDIAN;
    private StringPool stringPool;
    private ByteBuffer buffer;
    private ResourceTable resourceTable;
    private Set<Locale> locales;

    public ResourceTableParser(ByteBuffer buffer) {
        this.buffer = buffer.duplicate();
        this.buffer.order(this.byteOrder);
        this.locales = new HashSet<Locale>();
    }

    public void parse() {
        ResourceTableHeader resourceTableHeader = (ResourceTableHeader)this.readChunkHeader();
        this.stringPool = ParseUtils.readStringPool(this.buffer, (StringPoolHeader)this.readChunkHeader());
        this.resourceTable = new ResourceTable();
        this.resourceTable.setStringPool(this.stringPool);
        PackageHeader packageHeader = (PackageHeader)this.readChunkHeader();
        int i = 0;
        while ((long)i < resourceTableHeader.getPackageCount()) {
            Pair<ResourcePackage, PackageHeader> pair = this.readPackage(packageHeader);
            this.resourceTable.addPackage(pair.getLeft());
            packageHeader = pair.getRight();
            ++i;
        }
    }

    private Pair<ResourcePackage, PackageHeader> readPackage(PackageHeader packageHeader) {
        Pair<ResourcePackage, PackageHeader> pair = new Pair<ResourcePackage, PackageHeader>();
        ResourcePackage resourcePackage = new ResourcePackage(packageHeader);
        pair.setLeft(resourcePackage);
        long beginPos = this.buffer.position();
        if (packageHeader.getTypeStrings() > 0) {
            Buffers.position(this.buffer, beginPos + (long)packageHeader.getTypeStrings() - (long)packageHeader.getHeaderSize());
            resourcePackage.setTypeStringPool(ParseUtils.readStringPool(this.buffer, (StringPoolHeader)this.readChunkHeader()));
        }
        if (packageHeader.getKeyStrings() > 0) {
            Buffers.position(this.buffer, beginPos + (long)packageHeader.getKeyStrings() - (long)packageHeader.getHeaderSize());
            resourcePackage.setKeyStringPool(ParseUtils.readStringPool(this.buffer, (StringPoolHeader)this.readChunkHeader()));
        }
        block7: while (this.buffer.hasRemaining()) {
            ChunkHeader chunkHeader = this.readChunkHeader();
            long chunkBegin = this.buffer.position();
            switch (chunkHeader.getChunkType()) {
                case 514: {
                    TypeSpecHeader typeSpecHeader = (TypeSpecHeader)chunkHeader;
                    long[] entryFlags = new long[typeSpecHeader.getEntryCount()];
                    for (int i = 0; i < typeSpecHeader.getEntryCount(); ++i) {
                        entryFlags[i] = Buffers.readUInt(this.buffer);
                    }
                    TypeSpec typeSpec = new TypeSpec(typeSpecHeader);
                    typeSpec.setEntryFlags(entryFlags);
                    typeSpec.setName(resourcePackage.getTypeStringPool().get(typeSpecHeader.getId() - 1));
                    resourcePackage.addTypeSpec(typeSpec);
                    Buffers.position(this.buffer, chunkBegin + (long)typeSpecHeader.getBodySize());
                    break;
                }
                case 513: {
                    TypeHeader typeHeader = (TypeHeader)chunkHeader;
                    long[] offsets = new long[typeHeader.getEntryCount()];
                    for (int i = 0; i < typeHeader.getEntryCount(); ++i) {
                        offsets[i] = Buffers.readUInt(this.buffer);
                    }
                    Type type = new Type(typeHeader);
                    type.setName(resourcePackage.getTypeStringPool().get(typeHeader.getId() - 1));
                    long entryPos = chunkBegin + (long)typeHeader.getEntriesStart() - (long)typeHeader.getHeaderSize();
                    Buffers.position(this.buffer, entryPos);
                    ByteBuffer b = this.buffer.slice();
                    b.order(this.byteOrder);
                    type.setBuffer(b);
                    type.setKeyStringPool(resourcePackage.getKeyStringPool());
                    type.setOffsets(offsets);
                    type.setStringPool(this.stringPool);
                    resourcePackage.addType(type);
                    this.locales.add(type.getLocale());
                    Buffers.position(this.buffer, chunkBegin + (long)typeHeader.getBodySize());
                    break;
                }
                case 512: {
                    pair.setRight((PackageHeader)chunkHeader);
                    break block7;
                }
                case 515: {
                    LibraryHeader libraryHeader = (LibraryHeader)chunkHeader;
                    for (long i = 0L; i < (long)libraryHeader.getCount(); ++i) {
                        int packageId = this.buffer.getInt();
                        String name = Buffers.readZeroTerminatedString(this.buffer, 128);
                        LibraryEntry libraryEntry = new LibraryEntry(packageId, name);
                    }
                    Buffers.position(this.buffer, chunkBegin + (long)chunkHeader.getBodySize());
                    break;
                }
                case 0: {
                    Buffers.position(this.buffer, this.buffer.position() + this.buffer.remaining());
                    break;
                }
                default: {
                    throw new ParserException("unexpected chunk type: 0x" + chunkHeader.getChunkType());
                }
            }
        }
        return pair;
    }

    private ChunkHeader readChunkHeader() {
        long begin = this.buffer.position();
        int chunkType = Buffers.readUShort(this.buffer);
        int headerSize = Buffers.readUShort(this.buffer);
        int chunkSize = (int)Buffers.readUInt(this.buffer);
        switch (chunkType) {
            case 2: {
                ResourceTableHeader resourceTableHeader = new ResourceTableHeader(headerSize, chunkSize);
                resourceTableHeader.setPackageCount(Buffers.readUInt(this.buffer));
                Buffers.position(this.buffer, begin + (long)headerSize);
                return resourceTableHeader;
            }
            case 1: {
                StringPoolHeader stringPoolHeader = new StringPoolHeader(headerSize, chunkSize);
                stringPoolHeader.setStringCount(Buffers.readUInt(this.buffer));
                stringPoolHeader.setStyleCount(Buffers.readUInt(this.buffer));
                stringPoolHeader.setFlags(Buffers.readUInt(this.buffer));
                stringPoolHeader.setStringsStart(Buffers.readUInt(this.buffer));
                stringPoolHeader.setStylesStart(Buffers.readUInt(this.buffer));
                Buffers.position(this.buffer, begin + (long)headerSize);
                return stringPoolHeader;
            }
            case 512: {
                PackageHeader packageHeader = new PackageHeader(headerSize, chunkSize);
                packageHeader.setId(Buffers.readUInt(this.buffer));
                packageHeader.setName(ParseUtils.readStringUTF16(this.buffer, 128));
                packageHeader.setTypeStrings(Buffers.readUInt(this.buffer));
                packageHeader.setLastPublicType(Buffers.readUInt(this.buffer));
                packageHeader.setKeyStrings(Buffers.readUInt(this.buffer));
                packageHeader.setLastPublicKey(Buffers.readUInt(this.buffer));
                Buffers.position(this.buffer, begin + (long)headerSize);
                return packageHeader;
            }
            case 514: {
                TypeSpecHeader typeSpecHeader = new TypeSpecHeader(headerSize, chunkSize);
                typeSpecHeader.setId(Buffers.readUByte(this.buffer));
                typeSpecHeader.setRes0(Buffers.readUByte(this.buffer));
                typeSpecHeader.setRes1(Buffers.readUShort(this.buffer));
                typeSpecHeader.setEntryCount(Buffers.readUInt(this.buffer));
                Buffers.position(this.buffer, begin + (long)headerSize);
                return typeSpecHeader;
            }
            case 513: {
                TypeHeader typeHeader = new TypeHeader(headerSize, chunkSize);
                typeHeader.setId(Buffers.readUByte(this.buffer));
                typeHeader.setRes0(Buffers.readUByte(this.buffer));
                typeHeader.setRes1(Buffers.readUShort(this.buffer));
                typeHeader.setEntryCount(Buffers.readUInt(this.buffer));
                typeHeader.setEntriesStart(Buffers.readUInt(this.buffer));
                typeHeader.setConfig(this.readResTableConfig());
                Buffers.position(this.buffer, begin + (long)headerSize);
                return typeHeader;
            }
            case 515: {
                LibraryHeader libraryHeader = new LibraryHeader(headerSize, chunkSize);
                libraryHeader.setCount(Buffers.readUInt(this.buffer));
                Buffers.position(this.buffer, begin + (long)headerSize);
                return libraryHeader;
            }
            case 0: {
                Buffers.position(this.buffer, begin + (long)headerSize);
                return new NullHeader(headerSize, chunkSize);
            }
        }
        throw new ParserException("Unexpected chunk Type: 0x" + Integer.toHexString(chunkType));
    }

    private ResTableConfig readResTableConfig() {
        long beginPos = this.buffer.position();
        ResTableConfig config = new ResTableConfig();
        long size = Buffers.readUInt(this.buffer);
        config.setMcc(this.buffer.getShort());
        config.setMnc(this.buffer.getShort());
        config.setLanguage(new String(Buffers.readBytes(this.buffer, 2)).replace("\u0000", ""));
        config.setCountry(new String(Buffers.readBytes(this.buffer, 2)).replace("\u0000", ""));
        config.setOrientation(Buffers.readUByte(this.buffer));
        config.setTouchscreen(Buffers.readUByte(this.buffer));
        config.setDensity(Buffers.readUShort(this.buffer));
        long endPos = this.buffer.position();
        Buffers.skip(this.buffer, (int)(size - (endPos - beginPos)));
        return config;
    }

    public ResourceTable getResourceTable() {
        return this.resourceTable;
    }

    public Set<Locale> getLocales() {
        return this.locales;
    }
}

