/*
 * Decompiled with CFR 0.152.
 */
package net.dongliu.apk.parser.bean;

import javax.annotation.Nullable;
import net.dongliu.apk.parser.struct.dex.DexClassStruct;

public class DexClass {
    private final String classType;
    private final String superClass;
    private final int accessFlags;

    public DexClass(String classType, String superClass, int accessFlags) {
        this.classType = classType;
        this.superClass = superClass;
        this.accessFlags = accessFlags;
    }

    public String getPackageName() {
        String packageName = this.classType;
        if (packageName.length() > 0 && packageName.charAt(0) == 'L') {
            packageName = packageName.substring(1);
        }
        if (packageName.length() > 0) {
            int idx = this.classType.lastIndexOf(47);
            if (idx > 0) {
                packageName = packageName.substring(0, this.classType.lastIndexOf(47) - 1);
            } else if (packageName.charAt(packageName.length() - 1) == ';') {
                packageName = packageName.substring(0, packageName.length() - 1);
            }
        }
        return packageName.replace('/', '.');
    }

    public String getClassType() {
        return this.classType;
    }

    @Nullable
    public String getSuperClass() {
        return this.superClass;
    }

    public boolean isInterface() {
        return (this.accessFlags & DexClassStruct.ACC_INTERFACE) != 0;
    }

    public boolean isEnum() {
        return (this.accessFlags & DexClassStruct.ACC_ENUM) != 0;
    }

    public boolean isAnnotation() {
        return (this.accessFlags & DexClassStruct.ACC_ANNOTATION) != 0;
    }

    public boolean isPublic() {
        return (this.accessFlags & DexClassStruct.ACC_PUBLIC) != 0;
    }

    public boolean isProtected() {
        return (this.accessFlags & DexClassStruct.ACC_PROTECTED) != 0;
    }

    public boolean isStatic() {
        return (this.accessFlags & DexClassStruct.ACC_STATIC) != 0;
    }

    public String toString() {
        return this.classType;
    }
}

