/*
 * Decompiled with CFR 0.152.
 */
package net.devh.springboot.autoconfigure.grpc.server;

import io.grpc.ForwardingServerCall;
import io.grpc.Metadata;
import io.grpc.ServerCall;
import io.grpc.ServerCallHandler;
import io.grpc.ServerInterceptor;
import io.grpc.Status;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.cloud.sleuth.Span;
import org.springframework.cloud.sleuth.SpanExtractor;
import org.springframework.cloud.sleuth.Tracer;
import org.springframework.cloud.sleuth.util.ExceptionUtils;

public class TraceServerInterceptor
implements ServerInterceptor {
    private static final Logger log = LoggerFactory.getLogger(TraceServerInterceptor.class);
    private Tracer tracer;
    private SpanExtractor<Metadata> spanExtractor;
    private static final String GRPC_COMPONENT = "gRPC";

    public TraceServerInterceptor(Tracer tracer, SpanExtractor<Metadata> spanExtractor) {
        this.tracer = tracer;
        this.spanExtractor = spanExtractor;
    }

    public <ReqT, RespT> ServerCall.Listener<ReqT> interceptCall(final ServerCall<ReqT, RespT> call, Metadata headers, ServerCallHandler<ReqT, RespT> next) {
        Span span = this.spanExtractor.joinTrace((Object)headers);
        this.tracer.continueSpan(span);
        return next.startCall((ServerCall)new ForwardingServerCall.SimpleForwardingServerCall<ReqT, RespT>(call){
            private Span gRPCSpan;

            public void request(int numMessages) {
                this.gRPCSpan = TraceServerInterceptor.this.tracer.createSpan("gRPC:" + call.getMethodDescriptor().getFullMethodName());
                this.gRPCSpan.logEvent("sr");
                this.gRPCSpan.tag("lc", TraceServerInterceptor.GRPC_COMPONENT);
                super.request(numMessages);
            }

            public void close(Status status, Metadata trailers) {
                this.gRPCSpan.logEvent("ss");
                Status.Code statusCode = status.getCode();
                TraceServerInterceptor.this.tracer.addTag("gRPC status code", String.valueOf(statusCode.value()));
                if (!status.isOk()) {
                    if (null != status.getCause()) {
                        TraceServerInterceptor.this.tracer.addTag("error", ExceptionUtils.getExceptionMessage((Throwable)status.getCause()));
                    } else {
                        TraceServerInterceptor.this.tracer.addTag("error", status.getDescription());
                    }
                }
                TraceServerInterceptor.this.tracer.close(this.gRPCSpan);
                super.close(status, trailers);
            }
        }, headers);
    }
}

