/*
 * Decompiled with CFR 0.152.
 */
package net.devh.springboot.autoconfigure.grpc.server;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import io.grpc.BindableService;
import io.grpc.ServerInterceptor;
import io.grpc.ServerInterceptors;
import io.grpc.ServerServiceDefinition;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import net.devh.springboot.autoconfigure.grpc.server.GlobalServerInterceptorRegistry;
import net.devh.springboot.autoconfigure.grpc.server.GrpcService;
import net.devh.springboot.autoconfigure.grpc.server.GrpcServiceDefinition;
import net.devh.springboot.autoconfigure.grpc.server.GrpcServiceDiscoverer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanCreationException;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;

public class AnnotationGrpcServiceDiscoverer
implements ApplicationContextAware,
GrpcServiceDiscoverer {
    private static final Logger log = LoggerFactory.getLogger(AnnotationGrpcServiceDiscoverer.class);
    private ApplicationContext applicationContext;

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
    }

    public Collection<String> findGrpcServiceBeanNames() {
        String[] beanNames = this.applicationContext.getBeanNamesForAnnotation(GrpcService.class);
        return Arrays.asList(beanNames);
    }

    @Override
    public Collection<GrpcServiceDefinition> findGrpcServices() {
        Collection<String> beanNames = this.findGrpcServiceBeanNames();
        ArrayList definitions = Lists.newArrayListWithCapacity((int)beanNames.size());
        GlobalServerInterceptorRegistry globalServerInterceptorRegistry = (GlobalServerInterceptorRegistry)this.applicationContext.getBean(GlobalServerInterceptorRegistry.class);
        List<ServerInterceptor> globalInterceptorList = globalServerInterceptorRegistry.getServerInterceptors();
        for (String beanName : beanNames) {
            BindableService bindableService = (BindableService)this.applicationContext.getBean(beanName, BindableService.class);
            ServerServiceDefinition serviceDefinition = bindableService.bindService();
            GrpcService grpcServiceAnnotation = (GrpcService)this.applicationContext.findAnnotationOnBean(beanName, GrpcService.class);
            serviceDefinition = this.bindInterceptors(serviceDefinition, grpcServiceAnnotation, globalInterceptorList);
            definitions.add(new GrpcServiceDefinition(beanName, bindableService.getClass(), serviceDefinition));
            log.debug("Found gRPC service: " + serviceDefinition.getServiceDescriptor().getName() + ", bean: " + beanName + ", class: " + bindableService.getClass().getName());
        }
        return definitions;
    }

    private ServerServiceDefinition bindInterceptors(ServerServiceDefinition serviceDefinition, GrpcService grpcServiceAnnotation, List<ServerInterceptor> globalInterceptorList) {
        HashSet interceptorSet = Sets.newHashSet();
        interceptorSet.addAll(globalInterceptorList);
        for (Class<? extends ServerInterceptor> serverInterceptorClass : grpcServiceAnnotation.interceptors()) {
            ServerInterceptor serverInterceptor;
            if (this.applicationContext.getBeanNamesForType(serverInterceptorClass).length > 0) {
                serverInterceptor = (ServerInterceptor)this.applicationContext.getBean(serverInterceptorClass);
            } else {
                try {
                    serverInterceptor = serverInterceptorClass.newInstance();
                }
                catch (Exception e) {
                    throw new BeanCreationException("Failed to create interceptor instance", (Throwable)e);
                }
            }
            interceptorSet.add(serverInterceptor);
        }
        return ServerInterceptors.intercept((ServerServiceDefinition)serviceDefinition, (List)Lists.newArrayList((Iterable)interceptorSet));
    }
}

