/*
 * Decompiled with CFR 0.152.
 */
package net.devh.boot.grpc.client.channelfactory;

import io.grpc.netty.shaded.io.grpc.netty.GrpcSslContexts;
import io.grpc.netty.shaded.io.grpc.netty.NegotiationType;
import io.grpc.netty.shaded.io.grpc.netty.NettyChannelBuilder;
import io.grpc.netty.shaded.io.netty.channel.EventLoopGroup;
import io.grpc.netty.shaded.io.netty.channel.epoll.EpollDomainSocketChannel;
import io.grpc.netty.shaded.io.netty.channel.epoll.EpollEventLoopGroup;
import io.grpc.netty.shaded.io.netty.channel.unix.DomainSocketAddress;
import io.grpc.netty.shaded.io.netty.handler.ssl.SslContextBuilder;
import java.io.InputStream;
import java.net.SocketAddress;
import java.net.URI;
import java.util.List;
import java.util.Objects;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLException;
import javax.net.ssl.TrustManagerFactory;
import net.devh.boot.grpc.client.channelfactory.AbstractChannelFactory;
import net.devh.boot.grpc.client.channelfactory.GrpcChannelConfigurer;
import net.devh.boot.grpc.client.config.GrpcChannelProperties;
import net.devh.boot.grpc.client.config.GrpcChannelsProperties;
import net.devh.boot.grpc.client.interceptor.GlobalClientInterceptorRegistry;
import net.devh.boot.grpc.common.security.KeyStoreUtils;
import net.devh.boot.grpc.common.util.GrpcUtils;
import org.springframework.core.io.Resource;

public class ShadedNettyChannelFactory
extends AbstractChannelFactory<NettyChannelBuilder> {
    public ShadedNettyChannelFactory(GrpcChannelsProperties properties, GlobalClientInterceptorRegistry globalClientInterceptorRegistry, List<GrpcChannelConfigurer> channelConfigurers) {
        super(properties, globalClientInterceptorRegistry, channelConfigurers);
    }

    @Override
    protected NettyChannelBuilder newChannelBuilder(String name) {
        GrpcChannelProperties properties = this.getPropertiesFor(name);
        URI address = properties.getAddress();
        if (address == null) {
            address = URI.create(name);
        }
        if ("unix".equals(address.getScheme())) {
            String path = GrpcUtils.extractDomainSocketAddressPath((String)address.toString());
            return NettyChannelBuilder.forAddress((SocketAddress)new DomainSocketAddress(path)).channelType(EpollDomainSocketChannel.class).eventLoopGroup((EventLoopGroup)new EpollEventLoopGroup());
        }
        return (NettyChannelBuilder)NettyChannelBuilder.forTarget((String)address.toString()).defaultLoadBalancingPolicy(properties.getDefaultLoadBalancingPolicy());
    }

    @Override
    protected void configureSecurity(NettyChannelBuilder builder, String name) {
        GrpcChannelProperties properties = this.getPropertiesFor(name);
        net.devh.boot.grpc.client.config.NegotiationType negotiationType = properties.getNegotiationType();
        builder.negotiationType(ShadedNettyChannelFactory.of(negotiationType));
        if (negotiationType == net.devh.boot.grpc.client.config.NegotiationType.TLS) {
            GrpcChannelProperties.Security security = properties.getSecurity();
            String authorityOverwrite = security.getAuthorityOverride();
            if (authorityOverwrite != null && !authorityOverwrite.isEmpty()) {
                builder.overrideAuthority(authorityOverwrite);
            }
            SslContextBuilder sslContextBuilder = GrpcSslContexts.forClient();
            ShadedNettyChannelFactory.configureProvidedClientCertificate(security, sslContextBuilder);
            ShadedNettyChannelFactory.configureAcceptedServerCertificates(security, sslContextBuilder);
            if (security.getCiphers() != null && !security.getCiphers().isEmpty()) {
                sslContextBuilder.ciphers(security.getCiphers());
            }
            if (security.getProtocols() != null && security.getProtocols().length > 0) {
                sslContextBuilder.protocols(security.getProtocols());
            }
            try {
                builder.sslContext(sslContextBuilder.build());
            }
            catch (SSLException e) {
                throw new IllegalStateException("Failed to create ssl context for grpc client", e);
            }
        }
    }

    protected static void configureProvidedClientCertificate(GrpcChannelProperties.Security security, SslContextBuilder sslContextBuilder) {
        block29: {
            if (security.isClientAuthEnabled()) {
                try {
                    Resource privateKey = security.getPrivateKey();
                    Resource keyStore = security.getKeyStore();
                    if (privateKey != null) {
                        Resource certificateChain = Objects.requireNonNull(security.getCertificateChain(), "certificateChain");
                        String privateKeyPassword = security.getPrivateKeyPassword();
                        try (InputStream certificateChainStream = certificateChain.getInputStream();
                             InputStream privateKeyStream = privateKey.getInputStream();){
                            sslContextBuilder.keyManager(certificateChainStream, privateKeyStream, privateKeyPassword);
                            break block29;
                        }
                    }
                    if (keyStore != null) {
                        KeyManagerFactory keyManagerFactory = KeyStoreUtils.loadKeyManagerFactory((String)security.getKeyStoreFormat(), (Resource)keyStore, (String)security.getKeyStorePassword());
                        sslContextBuilder.keyManager(keyManagerFactory);
                        break block29;
                    }
                    throw new IllegalStateException("Neither privateKey nor keyStore configured");
                }
                catch (Exception e) {
                    throw new IllegalArgumentException("Failed to create SSLContext (PK/Cert)", e);
                }
            }
        }
    }

    protected static void configureAcceptedServerCertificates(GrpcChannelProperties.Security security, SslContextBuilder sslContextBuilder) {
        block16: {
            try {
                Resource trustCertCollection = security.getTrustCertCollection();
                Resource trustStore = security.getTrustStore();
                if (trustCertCollection != null) {
                    try (InputStream trustCertCollectionStream = trustCertCollection.getInputStream();){
                        sslContextBuilder.trustManager(trustCertCollectionStream);
                        break block16;
                    }
                }
                if (trustStore != null) {
                    TrustManagerFactory trustManagerFactory = KeyStoreUtils.loadTrustManagerFactory((String)security.getTrustStoreFormat(), (Resource)trustStore, (String)security.getTrustStorePassword());
                    sslContextBuilder.trustManager(trustManagerFactory);
                }
            }
            catch (Exception e) {
                throw new IllegalArgumentException("Failed to create SSLContext (TrustStore)", e);
            }
        }
    }

    protected static NegotiationType of(net.devh.boot.grpc.client.config.NegotiationType negotiationType) {
        switch (negotiationType) {
            case PLAINTEXT: {
                return NegotiationType.PLAINTEXT;
            }
            case PLAINTEXT_UPGRADE: {
                return NegotiationType.PLAINTEXT_UPGRADE;
            }
            case TLS: {
                return NegotiationType.TLS;
            }
        }
        throw new IllegalArgumentException("Unsupported NegotiationType: " + (Object)((Object)negotiationType));
    }
}

