/*
 * Decompiled with CFR 0.152.
 */
package net.devh.boot.grpc.client.nameresolver;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import io.grpc.Attributes;
import io.grpc.EquivalentAddressGroup;
import io.grpc.NameResolver;
import io.grpc.Status;
import io.grpc.SynchronizationContext;
import io.grpc.internal.SharedResourceHolder;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicReference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.cloud.client.ServiceInstance;
import org.springframework.cloud.client.discovery.DiscoveryClient;
import org.springframework.util.CollectionUtils;

public class DiscoveryClientNameResolver
extends NameResolver {
    private static final Logger log = LoggerFactory.getLogger(DiscoveryClientNameResolver.class);
    @Deprecated
    private static final String LEGACY_CLOUD_DISCOVERY_METADATA_PORT = "gRPC.port";
    private static final List<ServiceInstance> KEEP_PREVIOUS = null;
    private final String name;
    private final DiscoveryClient client;
    private final SynchronizationContext syncContext;
    private final Runnable externalCleaner;
    private final SharedResourceHolder.Resource<Executor> executorResource;
    private final boolean usingExecutorResource;
    private NameResolver.Listener2 listener;
    private Executor executor;
    private boolean resolving;
    private List<ServiceInstance> instanceList = Lists.newArrayList();

    public DiscoveryClientNameResolver(String name, DiscoveryClient client, NameResolver.Args args, SharedResourceHolder.Resource<Executor> executorResource, Runnable externalCleaner) {
        this.name = name;
        this.client = client;
        this.syncContext = Objects.requireNonNull(args.getSynchronizationContext(), "syncContext");
        this.externalCleaner = externalCleaner;
        this.executor = args.getOffloadExecutor();
        this.usingExecutorResource = this.executor == null;
        this.executorResource = executorResource;
    }

    public final String getServiceAuthority() {
        return this.name;
    }

    public void start(NameResolver.Listener2 listener) {
        Preconditions.checkState((this.listener == null ? 1 : 0) != 0, (Object)"already started");
        if (this.usingExecutorResource) {
            this.executor = (Executor)SharedResourceHolder.get(this.executorResource);
        }
        this.listener = (NameResolver.Listener2)Preconditions.checkNotNull((Object)listener, (Object)"listener");
        this.resolve();
    }

    public void refresh() {
        Preconditions.checkState((this.listener != null ? 1 : 0) != 0, (Object)"not started");
        this.resolve();
    }

    public void refreshFromExternal() {
        this.syncContext.execute(() -> {
            if (this.listener != null) {
                this.resolve();
            }
        });
    }

    private void resolve() {
        log.debug("Scheduled resolve for {}", (Object)this.name);
        if (this.resolving) {
            return;
        }
        this.resolving = true;
        this.executor.execute(new Resolve(this.listener, this.instanceList));
    }

    public void shutdown() {
        this.listener = null;
        if (this.executor != null && this.usingExecutorResource) {
            this.executor = (Executor)SharedResourceHolder.release(this.executorResource, (Object)this.executor);
        }
        this.instanceList = Lists.newArrayList();
        if (this.externalCleaner != null) {
            this.externalCleaner.run();
        }
    }

    public String toString() {
        return "DiscoveryClientNameResolver [name=" + this.name + ", discoveryClient=" + this.client + "]";
    }

    private final class Resolve
    implements Runnable {
        private final NameResolver.Listener2 savedListener;
        private final List<ServiceInstance> savedInstanceList;

        Resolve(NameResolver.Listener2 listener, List<ServiceInstance> instanceList) {
            this.savedListener = Objects.requireNonNull(listener, "listener");
            this.savedInstanceList = Objects.requireNonNull(instanceList, "instanceList");
        }

        @Override
        public void run() {
            AtomicReference<List<ServiceInstance>> resultContainer = new AtomicReference<List<ServiceInstance>>();
            try {
                resultContainer.set(this.resolveInternal());
            }
            catch (Exception e) {
                this.savedListener.onError(Status.UNAVAILABLE.withCause((Throwable)e).withDescription("Failed to update server list for " + DiscoveryClientNameResolver.this.name));
                resultContainer.set(Lists.newArrayList());
            }
            finally {
                DiscoveryClientNameResolver.this.syncContext.execute(() -> {
                    DiscoveryClientNameResolver.this.resolving = false;
                    List result = (List)resultContainer.get();
                    if (result != KEEP_PREVIOUS && DiscoveryClientNameResolver.this.listener != null) {
                        DiscoveryClientNameResolver.this.instanceList = result;
                    }
                });
            }
        }

        private List<ServiceInstance> resolveInternal() {
            String name = DiscoveryClientNameResolver.this.name;
            List newInstanceList = DiscoveryClientNameResolver.this.client.getInstances(name);
            log.debug("Got {} candidate servers for {}", (Object)newInstanceList.size(), (Object)name);
            if (CollectionUtils.isEmpty((Collection)newInstanceList)) {
                log.error("No servers found for {}", (Object)name);
                this.savedListener.onError(Status.UNAVAILABLE.withDescription("No servers found for " + name));
                return Lists.newArrayList();
            }
            if (!this.needsToUpdateConnections(newInstanceList)) {
                log.debug("Nothing has changed... skipping update for {}", (Object)name);
                return KEEP_PREVIOUS;
            }
            log.debug("Ready to update server list for {}", (Object)name);
            ArrayList targets = Lists.newArrayList();
            for (ServiceInstance instance : newInstanceList) {
                int port = this.getGRPCPort(instance);
                log.debug("Found gRPC server {}:{} for {}", new Object[]{instance.getHost(), port, name});
                targets.add(new EquivalentAddressGroup((SocketAddress)new InetSocketAddress(instance.getHost(), port), Attributes.EMPTY));
            }
            if (targets.isEmpty()) {
                log.error("None of the servers for {} specified a gRPC port", (Object)name);
                this.savedListener.onError(Status.UNAVAILABLE.withDescription("None of the servers for " + name + " specified a gRPC port"));
                return Lists.newArrayList();
            }
            this.savedListener.onResult(NameResolver.ResolutionResult.newBuilder().setAddresses((List)targets).build());
            log.info("Done updating server list for {}", (Object)name);
            return newInstanceList;
        }

        private int getGRPCPort(ServiceInstance instance) {
            Map metadata = instance.getMetadata();
            if (metadata == null) {
                return instance.getPort();
            }
            String portString = (String)metadata.get("gRPC_port");
            if (portString == null) {
                portString = (String)metadata.get(DiscoveryClientNameResolver.LEGACY_CLOUD_DISCOVERY_METADATA_PORT);
                if (portString == null) {
                    return instance.getPort();
                }
                log.warn("Found legacy grpc port metadata '{}' for client '{}' use '{}' instead", new Object[]{DiscoveryClientNameResolver.LEGACY_CLOUD_DISCOVERY_METADATA_PORT, DiscoveryClientNameResolver.this.name, "gRPC_port"});
            }
            try {
                return Integer.parseInt(portString);
            }
            catch (NumberFormatException e) {
                throw new IllegalArgumentException("Failed to parse gRPC port information from: " + instance, e);
            }
        }

        private boolean needsToUpdateConnections(List<ServiceInstance> newInstanceList) {
            if (this.savedInstanceList.size() != newInstanceList.size()) {
                return true;
            }
            for (ServiceInstance instance : this.savedInstanceList) {
                int port = this.getGRPCPort(instance);
                boolean isSame = false;
                for (ServiceInstance newInstance : newInstanceList) {
                    int newPort = this.getGRPCPort(newInstance);
                    if (!newInstance.getHost().equals(instance.getHost()) || port != newPort) continue;
                    isSame = true;
                    break;
                }
                if (isSame) continue;
                return true;
            }
            return false;
        }
    }
}

