/*
 * Decompiled with CFR 0.152.
 */
package net.devh.springboot.autoconfigure.grpc.client;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Lists;
import com.google.common.collect.Multimap;
import io.grpc.Channel;
import io.grpc.ClientInterceptor;
import io.grpc.stub.AbstractStub;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import net.devh.springboot.autoconfigure.grpc.client.GrpcChannelFactory;
import net.devh.springboot.autoconfigure.grpc.client.GrpcClient;
import org.springframework.aop.framework.Advised;
import org.springframework.aop.support.AopUtils;
import org.springframework.beans.BeanInstantiationException;
import org.springframework.beans.BeansException;
import org.springframework.beans.InvalidPropertyException;
import org.springframework.beans.factory.BeanCreationException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.config.BeanPostProcessor;
import org.springframework.beans.factory.support.DefaultListableBeanFactory;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.util.ReflectionUtils;

public class GrpcClientBeanPostProcessor
implements BeanPostProcessor,
AutoCloseable {
    private final Multimap<String, Field> beansToProcess = HashMultimap.create();
    @Autowired
    private DefaultListableBeanFactory beanFactory;
    @Autowired
    private GrpcChannelFactory channelFactory;

    public Object postProcessBeforeInitialization(Object bean, String beanName) {
        Class<?> clazz = bean.getClass();
        do {
            for (Field field : clazz.getDeclaredFields()) {
                if (!field.isAnnotationPresent(GrpcClient.class)) continue;
                this.beansToProcess.put((Object)beanName, (Object)field);
            }
        } while ((clazz = clazz.getSuperclass()) != null);
        return bean;
    }

    public Object postProcessAfterInitialization(Object bean, String beanName) throws BeansException {
        if (this.beansToProcess.containsKey((Object)beanName)) {
            Object target = this.getTargetBean(bean);
            for (Field field : this.beansToProcess.get((Object)beanName)) {
                Object value;
                GrpcClient annotation = (GrpcClient)AnnotationUtils.getAnnotation((AnnotatedElement)field, GrpcClient.class);
                if (null == annotation) continue;
                ArrayList list = Lists.newArrayList();
                for (Class<? extends ClientInterceptor> clientInterceptorClass : annotation.interceptors()) {
                    ClientInterceptor clientInterceptor;
                    if (this.beanFactory.getBeanNamesForType(ClientInterceptor.class).length > 0) {
                        clientInterceptor = (ClientInterceptor)this.beanFactory.getBean(clientInterceptorClass);
                    } else {
                        try {
                            clientInterceptor = clientInterceptorClass.newInstance();
                        }
                        catch (Exception e) {
                            throw new BeanCreationException("Failed to create interceptor instance", (Throwable)e);
                        }
                    }
                    list.add(clientInterceptor);
                }
                Channel channel = this.channelFactory.createChannel(annotation.value(), list);
                Class<?> fieldType = field.getType();
                if (Channel.class.equals(fieldType)) {
                    value = channel;
                } else if (AbstractStub.class.isAssignableFrom(fieldType)) {
                    try {
                        Constructor constructor = ReflectionUtils.accessibleConstructor(fieldType, (Class[])new Class[]{Channel.class});
                        value = constructor.newInstance(channel);
                    }
                    catch (IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
                        throw new BeanInstantiationException(fieldType, "Failed to create gRPC client for field: " + field, (Throwable)e);
                    }
                } else {
                    throw new InvalidPropertyException(field.getDeclaringClass(), field.getName(), "Unsupported field type " + fieldType.getName());
                }
                ReflectionUtils.makeAccessible((Field)field);
                ReflectionUtils.setField((Field)field, (Object)target, (Object)value);
            }
        }
        return bean;
    }

    private Object getTargetBean(Object bean) {
        Object target = bean;
        while (AopUtils.isAopProxy((Object)target)) {
            target = ((Advised)target).getTargetSource().getTarget();
        }
        return target;
    }

    @Override
    public void close() {
        this.beansToProcess.clear();
    }
}

