/*
 * Decompiled with CFR 0.152.
 */
package net.devh.springboot.autoconfigure.grpc.client;

import com.google.common.collect.Lists;
import io.grpc.LoadBalancer;
import java.util.List;
import net.devh.springboot.autoconfigure.grpc.client.AbstractChannelFactory;
import net.devh.springboot.autoconfigure.grpc.client.DiscoveryClientNameResolver;
import net.devh.springboot.autoconfigure.grpc.client.DiscoveryClientResolverFactory;
import net.devh.springboot.autoconfigure.grpc.client.GlobalClientInterceptorRegistry;
import net.devh.springboot.autoconfigure.grpc.client.GrpcChannelsProperties;
import org.springframework.cloud.client.discovery.DiscoveryClient;
import org.springframework.cloud.client.discovery.event.HeartbeatEvent;
import org.springframework.cloud.client.discovery.event.HeartbeatMonitor;
import org.springframework.context.event.EventListener;

public class DiscoveryClientChannelFactory
extends AbstractChannelFactory {
    private final HeartbeatMonitor monitor = new HeartbeatMonitor();
    private final List<DiscoveryClientNameResolver> discoveryClientNameResolvers = Lists.newArrayList();

    public DiscoveryClientChannelFactory(GrpcChannelsProperties properties, LoadBalancer.Factory loadBalancerFactory, DiscoveryClient client, GlobalClientInterceptorRegistry globalClientInterceptorRegistry) {
        super(properties, loadBalancerFactory, (T thiz) -> new DiscoveryClientResolverFactory(client, (DiscoveryClientChannelFactory)thiz), globalClientInterceptorRegistry);
    }

    public void addDiscoveryClientNameResolver(DiscoveryClientNameResolver discoveryClientNameResolver) {
        this.discoveryClientNameResolvers.add(discoveryClientNameResolver);
    }

    @EventListener(value={HeartbeatEvent.class})
    public void heartbeat(HeartbeatEvent event) {
        if (this.monitor.update(event.getValue())) {
            for (DiscoveryClientNameResolver discoveryClientNameResolver : this.discoveryClientNameResolvers) {
                discoveryClientNameResolver.refresh();
            }
        }
    }
}

