/*
 * Decompiled with CFR 0.152.
 */
package net.devh.springboot.autoconfigure.grpc.client;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import io.grpc.Attributes;
import io.grpc.EquivalentAddressGroup;
import io.grpc.NameResolver;
import io.grpc.Status;
import io.grpc.internal.SharedResourceHolder;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ExecutorService;
import javax.annotation.concurrent.GuardedBy;
import net.devh.springboot.autoconfigure.grpc.client.GrpcChannelProperties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AddressChannelNameResolver
extends NameResolver {
    private static final Logger log = LoggerFactory.getLogger(AddressChannelNameResolver.class);
    private final String name;
    private final GrpcChannelProperties properties;
    private final Attributes attributes;
    private final SharedResourceHolder.Resource<ExecutorService> executorResource;
    @GuardedBy(value="this")
    private boolean shutdown;
    @GuardedBy(value="this")
    private ExecutorService executor;
    @GuardedBy(value="this")
    private boolean resolving;
    @GuardedBy(value="this")
    private NameResolver.Listener listener;
    private final Runnable resolutionRunnable = new Runnable(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            NameResolver.Listener savedListener;
            AddressChannelNameResolver addressChannelNameResolver = AddressChannelNameResolver.this;
            synchronized (addressChannelNameResolver) {
                if (AddressChannelNameResolver.this.shutdown) {
                    return;
                }
                savedListener = AddressChannelNameResolver.this.listener;
                AddressChannelNameResolver.this.resolving = true;
            }
            try {
                int max = Math.max(AddressChannelNameResolver.this.properties.getHost().size(), AddressChannelNameResolver.this.properties.getPort().size());
                AddressChannelNameResolver.this.replace(AddressChannelNameResolver.this.properties.getHost(), max, "127.0.0.1");
                AddressChannelNameResolver.this.replace(AddressChannelNameResolver.this.properties.getPort(), max, GrpcChannelProperties.DEFAULT_PORT);
                if (AddressChannelNameResolver.this.properties.getHost().size() != AddressChannelNameResolver.this.properties.getPort().size()) {
                    log.error("config gRPC server {} error, hosts length isn't equals ports length,hosts [{}], ports [{}]", AddressChannelNameResolver.this.properties.getHost(), AddressChannelNameResolver.this.properties.getPort());
                    savedListener.onError(Status.UNAVAILABLE.withCause((Throwable)new RuntimeException("gRPC config error")));
                    return;
                }
                ArrayList equivalentAddressGroups = Lists.newArrayList();
                for (int i = 0; i < AddressChannelNameResolver.this.properties.getHost().size(); ++i) {
                    String host = AddressChannelNameResolver.this.properties.getHost().get(i);
                    Integer port = AddressChannelNameResolver.this.properties.getPort().get(i);
                    log.info("Found gRPC server {} {}:{}", new Object[]{AddressChannelNameResolver.this.name, host, port});
                    EquivalentAddressGroup addressGroup = new EquivalentAddressGroup((SocketAddress)new InetSocketAddress(host, (int)port), Attributes.EMPTY);
                    equivalentAddressGroups.add(addressGroup);
                }
                savedListener.onAddresses((List)equivalentAddressGroups, Attributes.EMPTY);
            }
            finally {
                AddressChannelNameResolver addressChannelNameResolver2 = AddressChannelNameResolver.this;
                synchronized (addressChannelNameResolver2) {
                    AddressChannelNameResolver.this.resolving = false;
                }
            }
        }
    };

    public AddressChannelNameResolver(String name, GrpcChannelProperties properties, Attributes attributes, SharedResourceHolder.Resource<ExecutorService> executorResource) {
        this.name = name;
        this.properties = properties;
        this.attributes = attributes;
        this.executorResource = executorResource;
    }

    public String getServiceAuthority() {
        return this.name;
    }

    public final synchronized void start(NameResolver.Listener listener) {
        Preconditions.checkState((this.listener == null ? 1 : 0) != 0, (Object)"already started");
        this.executor = (ExecutorService)SharedResourceHolder.get(this.executorResource);
        this.listener = (NameResolver.Listener)Preconditions.checkNotNull((Object)listener, (Object)"listener");
        this.resolve();
    }

    private <T> void replace(List<T> list, int max, T defaultValue) {
        list.replaceAll(e -> e == null ? defaultValue : e);
        for (int i = list.size(); i < max; ++i) {
            list.add(defaultValue);
        }
    }

    public final synchronized void refresh() {
        Preconditions.checkState((this.listener != null ? 1 : 0) != 0, (Object)"not started");
        this.resolve();
    }

    @GuardedBy(value="this")
    private void resolve() {
        if (this.resolving || this.shutdown) {
            return;
        }
        this.executor.execute(this.resolutionRunnable);
    }

    public void shutdown() {
        if (this.shutdown) {
            return;
        }
        this.shutdown = true;
        if (this.executor != null) {
            this.executor = (ExecutorService)SharedResourceHolder.release(this.executorResource, (Object)this.executor);
        }
    }
}

