/*
 * Decompiled with CFR 0.152.
 */
package net.devh.springboot.autoconfigure.grpc.client;

import io.grpc.Channel;
import io.grpc.LoadBalancer;
import io.grpc.ManagedChannel;
import io.grpc.ManagedChannelBuilder;
import io.grpc.NameResolver;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import net.devh.springboot.autoconfigure.grpc.client.AddressChannelResolverFactory;
import net.devh.springboot.autoconfigure.grpc.client.GrpcChannelFactory;
import net.devh.springboot.autoconfigure.grpc.client.GrpcChannelsProperties;

public class AddressChannelFactory
implements GrpcChannelFactory {
    private final GrpcChannelsProperties properties;
    private final LoadBalancer.Factory loadBalancerFactory;
    private final NameResolver.Factory nameResolverFactory;
    private static Map<String, ManagedChannel> channelMap = new ConcurrentHashMap<String, ManagedChannel>();

    public AddressChannelFactory(GrpcChannelsProperties properties, LoadBalancer.Factory loadBalancerFactory) {
        this.properties = properties;
        this.loadBalancerFactory = loadBalancerFactory;
        this.nameResolverFactory = new AddressChannelResolverFactory(properties);
    }

    @Override
    public Channel createChannel(String name) {
        ManagedChannel channel = channelMap.get(name);
        if (channel == null) {
            ManagedChannel newChannel = ManagedChannelBuilder.forTarget((String)name).loadBalancerFactory(this.loadBalancerFactory).nameResolverFactory(this.nameResolverFactory).usePlaintext(this.properties.getChannel(name).isPlaintext()).build();
            channel = channelMap.putIfAbsent(name, newChannel) == null ? newChannel : channelMap.get(name);
        }
        return channel;
    }
}

