/*
 * Decompiled with CFR 0.152.
 */
package net.dathoang.cqrs.commandbus.spring;

import net.dathoang.cqrs.commandbus.command.CommandBus;
import net.dathoang.cqrs.commandbus.command.DefaultCommandBus;
import net.dathoang.cqrs.commandbus.query.DefaultQueryBus;
import net.dathoang.cqrs.commandbus.query.QueryBus;
import net.dathoang.cqrs.commandbus.spring.DefaultHandlerFactoryConfig;
import net.dathoang.cqrs.commandbus.spring.DefaultMiddlewareConfig;
import net.dathoang.cqrs.commandbus.spring.HandlerFactoryConfig;
import net.dathoang.cqrs.commandbus.spring.MiddlewareConfig;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
public class CommandBusSpringConfiguration {
    private final Log log = LogFactory.getLog(CommandBusSpringConfiguration.class);
    private ApplicationContext applicationContext;

    @Autowired
    public CommandBusSpringConfiguration(ApplicationContext applicationContext) {
        this.applicationContext = applicationContext;
    }

    @Bean
    public CommandBus getCommandBus() {
        return new DefaultCommandBus(this.findHandlerFactoryConfig().getCommandHandlerFactory(), this.findMiddlewareConfig().getQueryMiddlewarePipeline());
    }

    @Bean
    public QueryBus getQueryBus() {
        return new DefaultQueryBus(this.findHandlerFactoryConfig().getQueryhandlerFactory(), this.findMiddlewareConfig().getQueryMiddlewarePipeline());
    }

    private HandlerFactoryConfig findHandlerFactoryConfig() {
        HandlerFactoryConfig scannedHandlerFactoryConfig = this.scanHandlerFactoryConfig();
        if (scannedHandlerFactoryConfig != null) {
            return scannedHandlerFactoryConfig;
        }
        this.log.info((Object)"Custom @Configuration-annotated HandlerFactoryConfig not found, using DefaultHandlerFactoryConfig");
        return new DefaultHandlerFactoryConfig(this.applicationContext);
    }

    private MiddlewareConfig findMiddlewareConfig() {
        MiddlewareConfig scannedMiddlewareConfig = this.scanMiddlewareConfig();
        if (scannedMiddlewareConfig != null) {
            return scannedMiddlewareConfig;
        }
        this.log.info((Object)"Custom @Configuration-annotated MiddlewareConfig not found, using DefaultMiddlewareConfig");
        return new DefaultMiddlewareConfig();
    }

    private HandlerFactoryConfig scanHandlerFactoryConfig() {
        return this.applicationContext.getBeansWithAnnotation(Configuration.class).values().stream().filter(c -> c instanceof HandlerFactoryConfig).findFirst().orElse(null);
    }

    private MiddlewareConfig scanMiddlewareConfig() {
        return this.applicationContext.getBeansWithAnnotation(Configuration.class).values().stream().filter(c -> c instanceof MiddlewareConfig).findFirst().orElse(null);
    }
}

