/*
 * Decompiled with CFR 0.152.
 */
package net.dathoang.cqrs.commandbus.spring;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import net.dathoang.cqrs.commandbus.autoscan.AutoScanHandlerFactory;
import net.dathoang.cqrs.commandbus.autoscan.HandlerScan;
import org.springframework.context.ApplicationContext;

public class SpringAutoScanHandlerFactory
extends AutoScanHandlerFactory {
    private final ApplicationContext context;

    public SpringAutoScanHandlerFactory(ApplicationContext context) {
        this.context = context;
        this.startScanningHandler();
    }

    protected Function<Class, Object> getBeanFactory() {
        return cls -> {
            this.context.getAutowireCapableBeanFactory().autowireBean(cls);
            return this.context.getAutowireCapableBeanFactory().createBean(cls);
        };
    }

    protected Set<String> getPackagesToScanConfig() {
        HashSet<String> packagesToScan = new HashSet<String>();
        Map springApplicationInstances = this.context.getBeansWithAnnotation(HandlerScan.class);
        for (Object appInstance : springApplicationInstances.values()) {
            HandlerScan scanAnnotation = appInstance.getClass().getAnnotation(HandlerScan.class);
            if (scanAnnotation == null) continue;
            packagesToScan.addAll(Arrays.asList(scanAnnotation.basePackages()));
        }
        return packagesToScan;
    }
}

